<?php
/**
 * Simple class to query CSS color values and names.
 *
 * @license    GPL 2 (http://www.gnu.org/licenses/gpl.html)
 * @author     LarsDW223
 */

/**
 * Class csscolors
 */
class csscolors {
    protected static $values = array(
                            'aliceblue'            => '#F0F8FF',
                            'antiquewhite'         => '#FAEBD7',
                            'aqua'                 => '#00FFFF',
                            'aquamarine'           => '#7FFFD4',
                            'azure'                => '#F0FFFF',
                            'beige'                => '#F5F5DC',
                            'bisque'               => '#FFE4C4',
                            'black'                => '#000000',
                            'blanchedalmond'       => '#FFEBCD',
                            'blue'                 => '#0000FF',
                            'blueviolet'           => '#8A2BE2',
                            'brown'                => '#A52A2A',
                            'burlywood'            => '#DEB887',
                            'cadetblue'            => '#5F9EA0',
                            'chartreuse'           => '#7FFF00',
                            'chocolate'            => '#D2691E',
                            'coral'                => '#FF7F50',
                            'cornflowerblue'       => '#6495ED',
                            'cornsilk'             => '#FFF8DC',
                            'crimson'              => '#DC143C',
                            'cyan'                 => '#00FFFF',
                            'darkblue'             => '#00008B',
                            'darkcyan'             => '#008B8B',
                            'darkgoldenrod'        => '#B8860B',
                            'darkgray'             => '#A9A9A9',
                            'darkgreen'            => '#006400',
                            'darkkhaki'            => '#BDB76B',
                            'darkmagenta'          => '#8B008B',
                            'darkolivegreen'       => '#556B2F',
                            'darkorange'           => '#FF8C00',
                            'darkorchid'           => '#9932CC',
                            'darkred'              => '#8B0000',
                            'darksalmon'           => '#E9967A',
                            'darkseagreen'         => '#8FBC8F',
                            'darkslateblue'        => '#483D8B',
                            'darkslategray'        => '#2F4F4F',
                            'darkturquoise'        => '#00CED1',
                            'darkviolet'           => '#9400D3',
                            'deeppink'             => '#FF1493',
                            'deepskyblue'          => '#00BFFF',
                            'dimgray'              => '#696969',
                            'dodgerblue'           => '#1E90FF',
                            'firebrick'            => '#B22222',
                            'floralwhite'          => '#FFFAF0',
                            'forestgreen'          => '#228B22',
                            'fuchsia'              => '#FF00FF',
                            'gainsboro'            => '#DCDCDC',
                            'ghostwhite'           => '#F8F8FF',
                            'gold'                 => '#FFD700',
                            'goldenrod'            => '#DAA520',
                            'gray'                 => '#808080',
                            'green'                => '#008000',
                            'greenyellow'          => '#ADFF2F',
                            'honeydew'             => '#F0FFF0',
                            'hotpink'              => '#FF69B4',
                            'indianred'            => '#CD5C5C',
                            'indigo'               => '#4B0082',
                            'ivory'                => '#FFFFF0',
                            'khaki'                => '#F0E68C',
                            'lavender'             => '#E6E6FA',
                            'lavenderblush'        => '#FFF0F5',
                            'lawngreen'            => '#7CFC00',
                            'lemonchiffon'         => '#FFFACD',
                            'lightblue'            => '#ADD8E6',
                            'lightcoral'           => '#F08080',
                            'lightcyan'            => '#E0FFFF',
                            'lightgoldenrodyellow' => '#E0FFFF',
                            'lightgray'            => '#D3D3D3',
                            'lightgreen'           => '#90EE90',
                            'lightpink'            => '#FFB6C1',
                            'lightsalmon'          => '#FFA07A',
                            'lightseagreen'        => '#20B2AA',
                            'lightskyblue'         => '#87CEFA',
                            'lightslategray'       => '#778899',
                            'lightsteelblue'       => '#B0C4DE',
                            'lightyellow'          => '#FFFFE0',
                            'lime'                 => '#00FF00',
                            'limegreen'            => '#32CD32',
                            'linen'                => '#FAF0E6',
                            'magenta'              => '#FF00FF',
                            'maroon'               => '#800000',
                            'mediumaquamarine'     => '#66CDAA',
                            'mediumblue'           => '#0000CD',
                            'mediumorchid'         => '#BA55D3',
                            'mediumpurple'         => '#9370DB',
                            'mediumseagreen'       => '#3CB371',
                            'mediumslateblue'      => '#7B68EE',
                            'mediumspringgreen'    => '#00FA9A',
                            'mediumturquoise'      => '#48D1CC',
                            'mediumvioletred'      => '#C71585',
                            'midnightblue'         => '#191970',
                            'mintcream'            => '#F5FFFA',
                            'mistyrose'            => '#FFE4E1',
                            'moccasin'             => '#FFE4B5',
                            'navajowhite'          => '#FFDEAD',
                            'navy'                 => '#000080',
                            'oldlace'              => '#FDF5E6',
                            'olive'                => '#808000',
                            'olivedrab'            => '#6B8E23',
                            'orange'               => '#FFA500',
                            'orangered'            => '#FF4500',
                            'orchid'               => '#DA70D6',
                            'palegoldenrod'        => '#EEE8AA',
                            'palegreen'            => '#98FB98',
                            'paleturquoise'        => '#AFEEEE',
                            'palevioletred'        => '#DB7093',
                            'papayawhip'           => '#FFEFD5',
                            'peachpuff'            => '#FFDAB9',
                            'peru'                 => '#CD853F',
                            'pink'                 => '#FFC0CB',
                            'plum'                 => '#DDA0DD',
                            'powderblue'           => '#B0E0E6',
                            'purple'               => '#800080',
                            'red'                  => '#FF0000',
                            'rosybrown'            => '#BC8F8F',
                            'royalblue'            => '#4169E1',
                            'saddlebrown'          => '#8B4513',
                            'salmon'               => '#FA8072',
                            'sandybrown'           => '#F4A460',
                            'seagreen'             => '#2E8B57',
                            'seashell'             => '#FFF5EE',
                            'sienna'               => '#A0522D',
                            'silver'               => '#C0C0C0',
                            'skyblue'              => '#87CEEB',
                            'slateblue'            => '#6A5ACD',
                            'slategray'            => '#708090',
                            'snow'                 => '#FFFAFA',
                            'springgreen'          => '#00FF7F',
                            'steelblue'            => '#4682B4',
                            'tan'                  => '#D2B48C',
                            'teal'                 => '#008080',
                            'thistle'              => '#D8BFD8',
                            'tomato'               => '#FF6347',
                            'turquoise'            => '#40E0D0',
                            'violet'               => '#EE82EE',
                            'wheat'                => '#F5DEB3',
                            'white'                => '#FFFFFF',
                            'whitesmoke'           => '#F5F5F5',
                            'yellow'               => '#FFFF00',
                            'yellowgreen'          => '#9ACD32',
                        );
    protected static $names = array(
                            '#F0F8FF' => 'AliceBlue',
                            '#FAEBD7' => 'AntiqueWhite',
                            // '#00FFFF' => 'Aqua',  //duplicated key with Cyan
                            '#7FFFD4' => 'Aquamarine',
                            '#F0FFFF' => 'Azure',
                            '#F5F5DC' => 'Beige',
                            '#FFE4C4' => 'Bisque',
                            '#000000' => 'Black',
                            '#FFEBCD' => 'BlanchedAlmond',
                            '#0000FF' => 'Blue',
                            '#8A2BE2' => 'BlueViolet',
                            '#A52A2A' => 'Brown',
                            '#DEB887' => 'BurlyWood',
                            '#5F9EA0' => 'CadetBlue',
                            '#7FFF00' => 'Chartreuse',
                            '#D2691E' => 'Chocolate',
                            '#FF7F50' => 'Coral',
                            '#6495ED' => 'CornflowerBlue',
                            '#FFF8DC' => 'Cornsilk',
                            '#DC143C' => 'Crimson',
                            '#00FFFF' => 'Cyan',
                            '#00008B' => 'DarkBlue',
                            '#008B8B' => 'DarkCyan',
                            '#B8860B' => 'DarkGoldenRod',
                            '#A9A9A9' => 'DarkGray',
                            '#006400' => 'DarkGreen',
                            '#BDB76B' => 'DarkKhaki',
                            '#8B008B' => 'DarkMagenta',
                            '#556B2F' => 'DarkOliveGreen',
                            '#FF8C00' => 'DarkOrange',
                            '#9932CC' => 'DarkOrchid',
                            '#8B0000' => 'DarkRed',
                            '#E9967A' => 'DarkSalmon',
                            '#8FBC8F' => 'DarkSeaGreen',
                            '#483D8B' => 'DarkSlateBlue',
                            '#2F4F4F' => 'DarkSlateGray',
                            '#00CED1' => 'DarkTurquoise',
                            '#9400D3' => 'DarkViolet',
                            '#FF1493' => 'DeepPink',
                            '#00BFFF' => 'DeepSkyBlue',
                            '#696969' => 'DimGray',
                            '#1E90FF' => 'DodgerBlue',
                            '#B22222' => 'FireBrick',
                            '#FFFAF0' => 'FloralWhite',
                            '#228B22' => 'ForestGreen',
                            //'#FF00FF' => 'Fuchsia',  //duplicated key with Magenta
                            '#DCDCDC' => 'Gainsboro',
                            '#F8F8FF' => 'GhostWhite',
                            '#FFD700' => 'Gold',
                            '#DAA520' => 'GoldenRod',
                            '#808080' => 'Gray',
                            '#008000' => 'Green',
                            '#ADFF2F' => 'GreenYellow',
                            '#F0FFF0' => 'HoneyDew',
                            '#FF69B4' => 'HotPink',
                            '#CD5C5C' => 'IndianRed',
                            '#4B0082' => 'Indigo',
                            '#FFFFF0' => 'Ivory',
                            '#F0E68C' => 'Khaki',
                            '#E6E6FA' => 'Lavender',
                            '#FFF0F5' => 'LavenderBlush',
                            '#7CFC00' => 'LawnGreen',
                            '#FFFACD' => 'LemonChiffon',
                            '#ADD8E6' => 'LightBlue',
                            '#F08080' => 'LightCoral',
                            '#E0FFFF' => 'LightCyan',
                            //'#E0FFFF' => 'LightGoldenRodYellow', //duplicated key with LightCyan
                            '#D3D3D3' => 'LightGray',
                            '#90EE90' => 'LightGreen',
                            '#FFB6C1' => 'LightPink',
                            '#FFA07A' => 'LightSalmon',
                            '#20B2AA' => 'LightSeaGreen',
                            '#87CEFA' => 'LightSkyBlue',
                            '#778899' => 'LightSlateGray',
                            '#B0C4DE' => 'LightSteelBlue',
                            '#FFFFE0' => 'LightYellow',
                            '#00FF00' => 'Lime',
                            '#32CD32' => 'LimeGreen',
                            '#FAF0E6' => 'Linen',
                            '#FF00FF' => 'Magenta',
                            '#800000' => 'Maroon',
                            '#66CDAA' => 'MediumAquaMarine',
                            '#0000CD' => 'MediumBlue',
                            '#BA55D3' => 'MediumOrchid',
                            '#9370DB' => 'MediumPurple',
                            '#3CB371' => 'MediumSeaGreen',
                            '#7B68EE' => 'MediumSlateBlue',
                            '#00FA9A' => 'MediumSpringGreen',
                            '#48D1CC' => 'MediumTurquoise',
                            '#C71585' => 'MediumVioletRed',
                            '#191970' => 'MidnightBlue',
                            '#F5FFFA' => 'MintCream',
                            '#FFE4E1' => 'MistyRose',
                            '#FFE4B5' => 'Moccasin',
                            '#FFDEAD' => 'NavajoWhite',
                            '#000080' => 'Navy',
                            '#FDF5E6' => 'OldLace',
                            '#808000' => 'Olive',
                            '#6B8E23' => 'OliveDrab',
                            '#FFA500' => 'Orange',
                            '#FF4500' => 'OrangeRed',
                            '#DA70D6' => 'Orchid',
                            '#EEE8AA' => 'PaleGoldenRod',
                            '#98FB98' => 'PaleGreen',
                            '#AFEEEE' => 'PaleTurquoise',
                            '#DB7093' => 'PaleVioletRed',
                            '#FFEFD5' => 'PapayaWhip',
                            '#FFDAB9' => 'PeachPuff',
                            '#CD853F' => 'Peru',
                            '#FFC0CB' => 'Pink',
                            '#DDA0DD' => 'Plum',
                            '#B0E0E6' => 'PowderBlue',
                            '#800080' => 'Purple',
                            '#FF0000' => 'Red',
                            '#BC8F8F' => 'RosyBrown',
                            '#4169E1' => 'RoyalBlue',
                            '#8B4513' => 'SaddleBrown',
                            '#FA8072' => 'Salmon',
                            '#F4A460' => 'SandyBrown',
                            '#2E8B57' => 'SeaGreen',
                            '#FFF5EE' => 'SeaShell',
                            '#A0522D' => 'Sienna',
                            '#C0C0C0' => 'Silver',
                            '#87CEEB' => 'SkyBlue',
                            '#6A5ACD' => 'SlateBlue',
                            '#708090' => 'SlateGray',
                            '#FFFAFA' => 'Snow',
                            '#00FF7F' => 'SpringGreen',
                            '#4682B4' => 'SteelBlue',
                            '#D2B48C' => 'Tan',
                            '#008080' => 'Teal',
                            '#D8BFD8' => 'Thistle',
                            '#FF6347' => 'Tomato',
                            '#40E0D0' => 'Turquoise',
                            '#EE82EE' => 'Violet',
                            '#F5DEB3' => 'Wheat',
                            '#FFFFFF' => 'White',
                            '#F5F5F5' => 'WhiteSmoke',
                            '#FFFF00' => 'Yellow',
                            '#9ACD32' => 'YellowGreen',
                        );

    /**
     * @param string|null $name
     * @return string
     */
    public static function getColorValue ($name=NULL) {
        $value = '#000000';
        if ($name != NULL) {
            $value = self::$values [strtolower($name)];
            if ($value == NULL)
                $value = '#000000';
        }
        return $value;
    }

    /**
     * @param null $value
     * @return string
     */
    public static function getValueName ($value=NULL) {
        $name = 'Black';
        if ($value != NULL) {
            $name = self::$names [$value];
            if ($name == NULL)
                $name = 'Black';
        }
        return $name;
    }

    /**
     * @param string $name
     * @return boolean
     */
    public static function isKnownColorName ($name=NULL) {
        if ($name != NULL) {
            return array_key_exists(strtolower($name), self::$values);
        }
        return false;
    }
}
