a:46:{i:0;a:3:{i:0;s:14:"document_start";i:1;a:0:{}i:2;i:0;}i:1;a:3:{i:0;s:6:"p_open";i:1;a:0:{}i:2;i:0;}i:2;a:3:{i:0;s:11:"strong_open";i:1;a:0:{}i:2;i:1;}i:3;a:3:{i:0;s:5:"cdata";i:1;a:1:{i:0;s:13:"OData Samples";}i:2;i:3;}i:4;a:3:{i:0;s:12:"strong_close";i:1;a:0:{}i:2;i:16;}i:5;a:3:{i:0;s:7:"p_close";i:1;a:0:{}i:2;i:18;}i:6;a:3:{i:0;s:6:"p_open";i:1;a:0:{}i:2;i:18;}i:7;a:3:{i:0;s:5:"cdata";i:1;a:1:{i:0;s:155:"This sample illustrates how to create simple dataspace with tables and reference links, generate OData metadata and import it into PowerQuery Excel plugin.";}i:2;i:20;}i:8;a:3:{i:0;s:7:"p_close";i:1;a:0:{}i:2;i:175;}i:9;a:3:{i:0;s:6:"p_open";i:1;a:0:{}i:2;i:175;}i:10;a:3:{i:0;s:5:"cdata";i:1;a:1:{i:0;s:59:"At first create Dataspace, SDO, tables and reference links.";}i:2;i:177;}i:11;a:3:{i:0;s:7:"p_close";i:1;a:0:{}i:2;i:242;}i:12;a:3:{i:0;s:4:"code";i:1;a:3:{i:0;s:1573:"
set delimiter $$

// create sdo
create sdo EmployeeAddress as 
{ 
    string address1;
    string address2;
    string zipcode;
} 
namespace sdo.organization 
replace archive organization 
replace package organization
$$

// create dataspace
create dataspace Organization type tspace $$
use TSPACE.Organization $$

// create tables
create persistent table employees
(
    id int primary key,
    name string,
    age int,
    email string,
    address EmployeeAddress,
    deptId int
)
$$

create persistent table departments
(
    id int primary key,
    name string
)
$$

create persistent table states
(
    zipcode string primary key,
    state string,
    city string
)
$$

create persistent table tasks
(
    id int primary key,
    description string,
    owner int,
    assigned int,
)   
$$

// create reference links

create reference link employee_department with source at employees.deptId and target at departments.id $$
create reference link department_employees with source at departments.id and target at employees.deptId $$

create reference link employee_state with source at employees.address spath '//zipcode' and target at states.zipcode $$
create reference link state_employees with source at states.zipcode and target at employees.address spath '//zipcode' $$

create reference link task_owner with source at tasks.owner and target at employees.id $$
create reference link task_assignee with source at tasks.assigned and target at employees.id $$

create reference link employee_owned_tasks with source at employees.id and target at tasks.owner $$

";i:1;N;i:2;N;}i:2;i:242;}i:13;a:3:{i:0;s:6:"p_open";i:1;a:0:{}i:2;i:242;}i:14;a:3:{i:0;s:5:"cdata";i:1;a:1:{i:0;s:31:"At second fill tables with data";}i:2;i:1825;}i:15;a:3:{i:0;s:7:"p_close";i:1;a:0:{}i:2;i:1862;}i:16;a:3:{i:0;s:4:"code";i:1;a:3:{i:0;s:1677:"
// departments
insert into departments values(1, 'IT') $$
insert into departments values(2, 'Sales') $$
insert into departments values(3, 'Marketing') $$

// states
insert into states values('10001', 'NY', 'New York') $$
insert into states values('90011', 'CA', 'Los Angeles') $$
insert into states values('94112', 'CA', 'San Francisco') $$

// employees 
EmployeeAddress addr = new EmployeeAddress();

addr.address1 = '99 Broadway' $$
addr.zipcode = '10001' $$
insert into employees values(1, 'Mike', 30, 'mike@gmail.com', addr, 1) $$

addr.address1 = '333 5 Ave' $$
addr.zipcode = '10001' $$
insert into employees values(2, 'John', 31, 'john@gmail.com', addr, 1) $$

addr.address1 = '6725 Sunset' $$
addr.zipcode = '90011' $$
insert into employees values(3, 'Karen', 25, 'karen@gmail.com', addr, 2) $$

addr.address1 = '111 Catro' $$
addr.zipcode = '94112' $$
insert into employees values(4, 'Bill', 26, 'bill@gmail.com', addr, 2) $$

addr.address1 = '324 Market st' $$
addr.zipcode = '94112' $$
insert into employees values(5, 'Dave', 26, 'dave@gmail.com', addr, 2) $$


addr.address1 = '6300 Beverly' $$
addr.zipcode = '90011' $$
insert into employees values(6, 'Steve', 29, 'steve@gmail.com', addr, 3) $$

addr.address1 = '1312 Venice' $$
addr.zipcode = '90011' $$
insert into employees values(7, 'Bob', 29, 'bob@gmail.com', addr, 3) $$


// tasks

insert into tasks values(1, 'task1', 1, 2) $$
insert into tasks values(2, 'task2', 3, 2) $$
insert into tasks values(3, 'task2', 6, 7) $$
insert into tasks values(4, 'task4', 6, 5) $$
insert into tasks values(5, 'task5', 6, 6) $$
insert into tasks values(6, 'task6', 5, 4) $$
insert into tasks values(7, 'task7', 3, 4) $$
";i:1;N;i:2;N;}i:2;i:1862;}i:17;a:3:{i:0;s:6:"p_open";i:1;a:0:{}i:2;i:1862;}i:18;a:3:{i:0;s:5:"cdata";i:1;a:1:{i:0;s:30:"Now we can get OData metadata ";}i:2;i:3549;}i:19;a:3:{i:0;s:7:"acronym";i:1;a:1:{i:0;s:3:"URL";}i:2;i:3579;}i:20;a:3:{i:0;s:5:"cdata";i:1;a:1:{i:0;s:6:" link.";}i:2;i:3582;}i:21;a:3:{i:0;s:7:"p_close";i:1;a:0:{}i:2;i:3588;}i:22;a:3:{i:0;s:6:"p_open";i:1;a:0:{}i:2;i:3588;}i:23;a:3:{i:0;s:5:"cdata";i:1;a:1:{i:0;s:21:"For that navigate to ";}i:2;i:3590;}i:24;a:3:{i:0;s:14:"monospace_open";i:1;a:0:{}i:2;i:3611;}i:25;a:3:{i:0;s:5:"cdata";i:1;a:1:{i:0;s:38:"<node_http_address>/sor/dataspace/list";}i:2;i:3613;}i:26;a:3:{i:0;s:15:"monospace_close";i:1;a:0:{}i:2;i:3651;}i:27;a:3:{i:0;s:5:"cdata";i:1;a:1:{i:0;s:14:" and click on ";}i:2;i:3653;}i:28;a:3:{i:0;s:7:"acronym";i:1;a:1:{i:0;s:3:"URL";}i:2;i:3667;}i:29;a:3:{i:0;s:5:"cdata";i:1;a:1:{i:0;s:9:" link in ";}i:2;i:3670;}i:30;a:3:{i:0;s:14:"monospace_open";i:1;a:0:{}i:2;i:3679;}i:31;a:3:{i:0;s:5:"cdata";i:1;a:1:{i:0;s:9:"Open Data";}i:2;i:3681;}i:32;a:3:{i:0;s:15:"monospace_close";i:1;a:0:{}i:2;i:3690;}i:33;a:3:{i:0;s:5:"cdata";i:1;a:1:{i:0;s:12:" column for ";}i:2;i:3692;}i:34;a:3:{i:0;s:14:"monospace_open";i:1;a:0:{}i:2;i:3704;}i:35;a:3:{i:0;s:5:"cdata";i:1;a:1:{i:0;s:12:"Organization";}i:2;i:3706;}i:36;a:3:{i:0;s:15:"monospace_close";i:1;a:0:{}i:2;i:3718;}i:37;a:3:{i:0;s:5:"cdata";i:1;a:1:{i:0;s:11:" dataspace.";}i:2;i:3720;}i:38;a:3:{i:0;s:7:"p_close";i:1;a:0:{}i:2;i:3731;}i:39;a:3:{i:0;s:6:"p_open";i:1;a:0:{}i:2;i:3731;}i:40;a:3:{i:0;s:5:"cdata";i:1;a:1:{i:0;s:76:"Then copy link from popup window and provide this link to PowerQuery plugin.";}i:2;i:3733;}i:41;a:3:{i:0;s:7:"p_close";i:1;a:0:{}i:2;i:3809;}i:42;a:3:{i:0;s:6:"p_open";i:1;a:0:{}i:2;i:3809;}i:43;a:3:{i:0;s:5:"cdata";i:1;a:1:{i:0;s:98:"Once PowerQuery plugin loads metadata, you can navigate within created tables and reference links.";}i:2;i:3811;}i:44;a:3:{i:0;s:7:"p_close";i:1;a:0:{}i:2;i:3909;}i:45;a:3:{i:0;s:12:"document_end";i:1;a:0:{}i:2;i:3909;}}