/* ---------------------------------------------------- */
/*  Generated by Enterprise Architect Version 13.5 		*/
/*  Created On : 15-May-2019 12:21:20 PM 				*/
/*  DBMS       : Oracle 						*/
/* ---------------------------------------------------- */

/* Drop Tables */

begin
	EXECUTE IMMEDIATE 'DROP TABLE   "sdc_audit_track" CASCADE CONSTRAINTS';
	EXCEPTION WHEN OTHERS THEN NULL;
end;  
/

begin
	EXECUTE IMMEDIATE 'DROP TABLE   "sdc_ca_acl" CASCADE CONSTRAINTS';
	EXCEPTION WHEN OTHERS THEN NULL;
end;  
/

begin
	EXECUTE IMMEDIATE 'DROP TABLE   "sdc_ca_codes" CASCADE CONSTRAINTS';
	EXCEPTION WHEN OTHERS THEN NULL;
end;  
/

begin
	EXECUTE IMMEDIATE 'DROP TABLE   "sdc_ca_sources" CASCADE CONSTRAINTS';
	EXCEPTION WHEN OTHERS THEN NULL;
end;  
/

begin
	EXECUTE IMMEDIATE 'DROP TABLE   "sdc_cmpl_audit_log" CASCADE CONSTRAINTS';
	EXCEPTION WHEN OTHERS THEN NULL;
end;  
/

begin
	EXECUTE IMMEDIATE 'DROP TABLE   "sdc_country_codes" CASCADE CONSTRAINTS';
	EXCEPTION WHEN OTHERS THEN NULL;
end;  
/

begin
	EXECUTE IMMEDIATE 'DROP TABLE   "sdc_flex_exclusions" CASCADE CONSTRAINTS';
	EXCEPTION WHEN OTHERS THEN NULL;
end;  
/

begin
	EXECUTE IMMEDIATE 'DROP TABLE   "sdc_flex_measures" CASCADE CONSTRAINTS';
	EXCEPTION WHEN OTHERS THEN NULL;
end;  
/

begin
	EXECUTE IMMEDIATE 'DROP TABLE   "sdc_holiday_sched" CASCADE CONSTRAINTS';
	EXCEPTION WHEN OTHERS THEN NULL;
end;  
/

begin
	EXECUTE IMMEDIATE 'DROP TABLE   "sdc_intg_audit_log" CASCADE CONSTRAINTS';
	EXCEPTION WHEN OTHERS THEN NULL;
end;  
/

begin
	EXECUTE IMMEDIATE 'DROP TABLE   "sdc_qlty_audit_log" CASCADE CONSTRAINTS';
	EXCEPTION WHEN OTHERS THEN NULL;
end;  
/

begin
	EXECUTE IMMEDIATE 'DROP TABLE   "sdc_qlty_audit_summary" CASCADE CONSTRAINTS';
	EXCEPTION WHEN OTHERS THEN NULL;
end;  
/

begin
	EXECUTE IMMEDIATE 'DROP TABLE   "sdc_qlty_cde_measures" CASCADE CONSTRAINTS';
	EXCEPTION WHEN OTHERS THEN NULL;
end;  
/

begin
	EXECUTE IMMEDIATE 'DROP TABLE   "sdc_qlty_excp_tracking" CASCADE CONSTRAINTS';
	EXCEPTION WHEN OTHERS THEN NULL;
end;  
/

/* Create Tables */

CREATE TABLE  "sdc_audit_track"
(
	"AUDIT_ID" VARCHAR2(50) NOT NULL,
	"EXPECTED_DATE" TIMESTAMP(6) NOT NULL,
	"USE_WEEKENDS" CHAR(1) NOT NULL,
	"USE_HOLIDAYS" CHAR(1) NOT NULL
)
;

CREATE TABLE  "sdc_ca_acl"
(
	"USER_ID" VARCHAR2(10) NOT NULL,
	"GROUP_NAME" VARCHAR2(50) NOT NULL,
	"USER_NAME" VARCHAR2(50) NULL,
	"ORG_UNIT" VARCHAR2(255) NULL,
	"PERMISSION" VARCHAR2(3) NULL
)
;

CREATE TABLE  "sdc_ca_codes"
(
	"CODE" VARCHAR2(5) NOT NULL,
	"DESCRIPTION" VARCHAR2(30) NOT NULL,
	"TYPE" VARCHAR2(20) NULL
)
;

CREATE TABLE  "sdc_ca_sources"
(
	"AUDIT_ID" VARCHAR2(50) NOT NULL,
	"SOURCE_NAME" VARCHAR2(255) NOT NULL,
	"CTYPE" VARCHAR2(10) NOT NULL,
	"DATA_SET_NAME" VARCHAR2(255) NULL,
	"SOURCE_NARID" VARCHAR2(50) NULL,
	"TARGET_NARID" VARCHAR2(50) NOT NULL,
	"GROUP_NAME" VARCHAR2(50) NOT NULL,
	"INSTANCE_NAME" VARCHAR2(50) NOT NULL,
	"JURISDICTION" VARCHAR2(50) NOT NULL,
	"DATA_FREQUENCY" VARCHAR2(10) NOT NULL,
	"DATA_TRANSPORT" VARCHAR2(10) NOT NULL,
	"DATA_TEMPLATE" VARCHAR2(100) NOT NULL,
	"API_KEY" VARCHAR2(255) NOT NULL,
	"CREATOR" VARCHAR2(30) NULL,
	"CREATED_ON" TIMESTAMP(6) NULL,
	"ACTIVE" VARCHAR2(1) NOT NULL,
	"MODIFIED_BY" VARCHAR2(30) NULL,
	"MODIFIED_ON" VARCHAR2(6) NULL,
	"COUNTRY_CODE" VARCHAR2(4) NULL
)
;

CREATE TABLE  "sdc_cmpl_audit_log"
(
	"AUDIT_KEY" VARCHAR2(255) NOT NULL,
	"AUDIT_TS" TIMESTAMP(6) DEFAULT systimestamp NOT NULL,
	"AUDIT_ID" VARCHAR2(50) NOT NULL,
	"JURISDICTION" VARCHAR2(50) NOT NULL,
	"BUSINESS_DATE" DATE NOT NULL,
	"DATA_ELEMENT_NAME" VARCHAR2(255) NOT NULL,
	"IS_PRIMARY" CHAR(1) NOT NULL,
	"DATA_ARRIVAL_TIME" TIMESTAMP(6) NULL,
	"RECON_CHECK" CHAR(1) NOT NULL,
	"D1" NUMBER(18,2) NULL,
	"D2" NUMBER(18,2) NULL,
	"D3" NUMBER(18,2) NULL,
	"D4" NUMBER(18,2) NULL,
	"D5" NUMBER(18,2) NULL,
	"D6" NUMBER(18,2) NULL,
	"D7" NUMBER(18) NULL,
	"D8" NUMBER(18) NULL,
	"D9" NUMBER(18) NULL,
	"D10" NUMBER(18) NULL,
	"D11" NUMBER(18) NULL,
	"D12" NUMBER(18) NULL,
	"D13" NUMBER(18) NULL,
	"D14" TIMESTAMP(6) NULL,
	"D15" TIMESTAMP(6) NULL,
	"D16" VARCHAR2(255) NULL,
	"D17" VARCHAR2(255) NULL,
	"D18" VARCHAR2(255) NULL,
	"D19" VARCHAR2(255) NULL,
	"D20" VARCHAR2(255) NULL
)
;

CREATE TABLE  "sdc_country_codes"
(
	"COUNTRY_CODE" VARCHAR2(4) NOT NULL,
	"COUNTRY_NAME" VARCHAR2(50) NOT NULL,
	"REGION" VARCHAR2(50) NULL
)
;

CREATE TABLE  "sdc_flex_exclusions"
(
	"AUDIT_ID" VARCHAR2(50) NOT NULL,
	"MEASURE_NAME" VARCHAR2(255) NOT NULL,
	"MEASURE_VALUE" VARCHAR2(50) NULL,
	"EXCLUSION_DESC" VARCHAR2(255) NULL
)
;

CREATE TABLE  "sdc_flex_measures"
(
	"AUDIT_ID" VARCHAR2(50) NOT NULL,
	"DIMENSION_ID" VARCHAR2(3) NOT NULL,
	"MEASURE_NAME" VARCHAR2(255) NOT NULL,
	"MEASURE_DESC" VARCHAR2(255) NULL,
	"SEQ_ID" NUMBER(8) NULL
)
;

CREATE TABLE  "sdc_holiday_sched"
(
	"SCHED_YEAR" NUMBER(8) NOT NULL,
	"SCHED_DATE" DATE NOT NULL,
	"DESCRIPTION" VARCHAR2(50) NULL,
	"JURISDICTION" VARCHAR2(10) NULL
)
;

CREATE TABLE  "sdc_intg_audit_log"
(
	"AUDIT_KEY" VARCHAR2(255) NOT NULL,
	"AUDIT_TS" TIMESTAMP(6) DEFAULT systimestamp NOT NULL,
	"AUDIT_ID" VARCHAR2(50) NOT NULL,
	"JURISDICTION" VARCHAR2(50) NOT NULL,
	"BUSINESS_DATE" DATE NOT NULL,
	"DATA_ELEMENT_NAME" VARCHAR2(255) NOT NULL,
	"SET_SEQ_ID" NUMBER(10) NOT NULL,
	"IS_PRIMARY" CHAR(1) NOT NULL,
	"DATA_ARRIVAL_TIME" TIMESTAMP(6) NULL,
	"NON_REPUDIATION" CHAR(1) NULL,
	"DUP_CHECK" CHAR(1) NULL,
	"GAP_CHECK" CHAR(1) NULL,
	"VOLUME_CHECK" CHAR(1) NULL,
	"RECON_CHECK" CHAR(1) NULL,
	"SCHEMA_CHECK" CHAR(1) NULL,
	"MESSAGE_DIGEST_SOURCE" VARCHAR2(255) NULL,
	"MESSAGE_DIGEST_TARGET" VARCHAR2(255) NULL,
	"RECORD_COUNT" NUMBER(10) NULL,
	"HEADER_COUNT" NUMBER(10) NULL,
	"TOTAL_TX_AMOUNT" NUMBER(38,2) NULL,
	"CURRENCY" CHAR(3) NULL,
	"HEADER_AMOUNT" NUMBER(38,2) NULL,
	"SEND_COUNT" NUMBER(10) NULL,
	"RECEIVE_COUNT" NUMBER(10) NULL
)
;

CREATE TABLE  "sdc_qlty_audit_log"
(
	"AUDIT_ID" VARCHAR2(50) NOT NULL,
	"AUDIT_TS" TIMESTAMP(6) NULL,
	"CDE_RULE_ID" VARCHAR2(50) NOT NULL,
	"CDE_VALUE" NUMBER(8,2) NOT NULL,
	"CDE_RESULT_MSG" VARCHAR2(50) NULL,
	"CDE_RESULT_DATA" VARCHAR2(50) NULL,
	"CDE_RECORD_ID" VARCHAR2(50) NULL,
	"BUSINESS_DATE" DATE NULL,
	"IS_PRIMARY" CHAR(1) NULL,
	"DAY_REPORTED" DATE NULL,
	"DAYS_ACTIVE" NUMBER(8) NULL,
	"CDE_METRIC_SCORE" NUMBER(8,2) NULL,
	"CDE_SCORE" NUMBER(8,2) NULL
)
;

CREATE TABLE  "sdc_qlty_audit_summary"
(
	"AUDIT_KEY" VARCHAR2(255) NOT NULL,
	"AUDIT_TS" TIMESTAMP(6) DEFAULT systimestamp NOT NULL,
	"AUDIT_ID" VARCHAR2(50) NULL,
	"JURISDICTION" VARCHAR2(50) NULL,
	"BUSINESS_DATE" DATE NULL,
	"DATA_ELEMENT_NAME" VARCHAR2(255) NULL,
	"IS_PRIMARY" CHAR(1) NULL,
	"TOTAL_RECORDS_PROCESSED" NUMBER(8) NULL,
	"CDE_EXCEPTION_COUNT" NUMBER(8) NULL,
	"RECORDS_PASSED" NUMBER(8) NULL,
	"RECORDS_FAILED" NUMBER(8) NULL,
	"RULES_FAILED" NUMBER(8) NULL
)
;

CREATE TABLE  "sdc_qlty_cde_measures"
(
	"AUDIT_ID" VARCHAR2(50) NOT NULL,
	"CDE_NAME" VARCHAR2(50) NOT NULL,
	"CDE_TYPE" VARCHAR2(10) NOT NULL,
	"CDE_RULE_ID" VARCHAR2(10) NOT NULL,
	"CDE_RULE_DESCRIPTION" VARCHAR2(255) NULL,
	"CDE_METRIC_WEIGHT" NUMBER(3) NULL
)
;

CREATE TABLE  "sdc_qlty_excp_tracking"
(
	"AUDIT_ID" VARCHAR2(50) NOT NULL,
	"CDE_RULE_ID" VARCHAR2(50) NOT NULL,
	"CDE_RECORD_ID" VARCHAR2(50) NULL,
	"CDE_SOURCE_ID" VARCHAR2(10) NOT NULL,    -- The IDQ identifier for source systems such as 2023, 2091, etc..
	"CDE_RULE_RESULT_MSG" VARCHAR2(50) NOT NULL,
	"CDE_RULE_RESULT_DATA" VARCHAR2(50) NOT NULL,
	"CDE_EXCP_CREATED_ON" DATE NOT NULL,
	"CDE_EXCP_DAYS_ACTIVE" NUMBER(8) NULL
)
;

/* Create Comments, Sequences and Triggers for Autonumber Columns */

COMMENT ON TABLE  "sdc_cmpl_audit_log" IS 'Staging Table for Completeness Control Audits'
;

COMMENT ON TABLE  "sdc_intg_audit_log" IS 'Staging Table for Integrity Check Auditing'
;

COMMENT ON TABLE  "sdc_qlty_audit_log" IS 'This table contains CDE names, values and metrics reported by source systems by (AUDIT_ID) '
;

COMMENT ON TABLE  "sdc_qlty_cde_measures" IS 'This table contains Rule definitions for  a given CDE within a specific audit source (AUDIT_ID) '
;

COMMENT ON TABLE  "sdc_qlty_excp_tracking" IS 'This table contains Rule definitions for a given CDE within a specific audit source (AUDIT_ID) '
;

COMMENT ON COLUMN  "sdc_qlty_excp_tracking"."CDE_SOURCE_ID" IS 'The IDQ identifier for source systems such as 2023, 2091, etc..'
;

/* Create Primary Keys, Indexes, Uniques, Checks, Triggers */

ALTER TABLE  "sdc_ca_acl" 
 ADD CONSTRAINT "PK_sdc_ca_acl"
	PRIMARY KEY ("USER_ID") 
 USING INDEX
;

ALTER TABLE  "sdc_ca_sources" 
 ADD CONSTRAINT "PK_sdc_ca_sources"
	PRIMARY KEY ("AUDIT_ID") 
 USING INDEX
;

CREATE INDEX "AUDIT_KEY_IDX"   
 ON  "sdc_cmpl_audit_log" ("AUDIT_KEY") 
;

ALTER TABLE  "sdc_flex_exclusions" 
 ADD CONSTRAINT "PK_sdc_flex_exclusions"
	PRIMARY KEY ("AUDIT_ID","MEASURE_NAME") 
 USING INDEX
;

ALTER TABLE  "sdc_flex_measures" 
 ADD CONSTRAINT "PK_sdc_flex_measures"
	PRIMARY KEY ("AUDIT_ID","DIMENSION_ID") 
 USING INDEX
;

ALTER TABLE  "sdc_intg_audit_log" 
 ADD CONSTRAINT "PK_SDC_CMPL_AUDIT_LOG"
	PRIMARY KEY ("AUDIT_KEY") 
 USING INDEX
;

ALTER TABLE  "sdc_qlty_audit_log" 
 ADD CONSTRAINT "PK_sdc_quality_rules"
	PRIMARY KEY ("AUDIT_ID","CDE_RULE_ID") 
 USING INDEX
;

ALTER TABLE  "sdc_qlty_cde_measures" 
 ADD CONSTRAINT "PK_sdc_quality_rules"
	PRIMARY KEY ("AUDIT_ID","CDE_NAME","CDE_RULE_ID") 
 USING INDEX
;

ALTER TABLE  "sdc_qlty_excp_tracking" 
 ADD CONSTRAINT "PK_sdc_quality_rules"
	PRIMARY KEY ("AUDIT_ID","CDE_RULE_ID") 
 USING INDEX
;
