from __future__ import absolute_import

import logging

logger = logging.getLogger(__name__)


class TypeConverter(object):
    """
    Interface for system and user defined converters.
    Provides methods to deserialize/serialize value from/to dictionary.
    """

    def typeClass(self, name = None):
        """
        Returns type of object that can be converted by this converter.
        :param name: type name
        :return: type
        """
        raise Exception("Should be implemented by inherited class.")

    def readFromMap(self, rawValue, typeFactory=None):
        """
        Deserialize rawValue to object instance.

        :param rawValue: primitive or dict
        :param typeFactory: type factory reference
        :return: object instance
        """
        raise Exception("Should be implemented by inherited class.")

    def writeToMap(self, value, typeFactory=None):
        """
        Serialize specified value to dict.
        :param value: value
        :param typeFactory: type factory reference
        :return: dict
        """
        raise Exception("Should be implemented by inherited class.")
