#### Summary
Web applications like Quilt are deployed to MNode to `.htcache/<acceptor name>/webapps/stquilt`  
and then are available at `https://<mnode address>:<mnode port>/<alias>`. 
`alias` is configured in web.xml and for Quilt it is `sysadmin`.

The idea is to make Quilt available at address like `https//quilt.mycompany.com`. To do it we only need to configure reverse proxy  to redirect requests to `https//quilt.mycompany.com` to `https://<monde address>:<mnode port>/<alias>` 

#### CloudFront Configuration

CloudFront can do this redirection. 

1. Create CloudFront distribution
 - Go to `https://console.aws.amazon.com/cloudfront/home`
 - Origin Domain Name = `<mnode address>`
 - Origin Path = `sysadmin`
 - Origin Protocol Policy = `HTTPS Only`
 - Viewer Protocol Policy = `Redirect HTTP to HTTPS`
 - HTTPS Port = `<mnode port>`
 - Allowed HTTP Methods = `GET, HEAD, OPTIONS, PUT, POST, PATCH, DELETE`
 - Alternate Domain Names (CNAMEs) = `quilt.mycompany.com`
 - Custom SSL Certificate (example.com) - request or import new certificate for `quilt.mycompany.com`
 - Cache and origin request settings = `Use legacy cache settings`
 - Query String Forwarding and Caching = `Forward all, cache based on all`

2. Configure CloudFront distribution(optional if Query String Forwarding and Caching is not set on step 1)
  - Create Behaviours for the following path patterns
    * `dropbox*`
    * `fabric*`
    * `security*`
  - Behaviour configuration
    * Origin or Origin Group = `there is only ione available origin`
    * Viewer Protocol Policy = `Redirect HTTP to HTTPS`    
    * Allowed HTTP Methods = `GET, HEAD, OPTIONS, PUT, POST, PATCH, DELET`
    * Cache and origin request settings = `Use legacy cache settings`
    * Object Caching = `Customize`
    * Minimum TTL, Maximum TTL, Default TTL = `0`
    * Query String Forwarding and Caching = `Forward all, cache based on all`

3. Request a certificate and confirm you certificate
  - Create certificate at `https://console.aws.amazon.com/acm/home` 
    * Domain name* = `quilt.mycompany.com`
    * Select validation method = ` DNS validation`
  - Update your DNS
    * Go to your DNS and add CNAME record
    * Go to DNS and add CNAME record for  `quilt.mycompany.com` => `cloudfront address got on step 1`
  - Wait for certificate issue and set in CloudFront distribution.

 