function ServiceAccessor(url, xSessionToken)
{
    this.httpRequest    = newHttpRequest(url, 60000);
    this.xSessionToken  = xSessionToken;
  
    // set header x-session-token
    this.httpRequest.setHeader("x-session-token", this.xSessionToken);

    // If authentication is failed on server, server sends HTTP 401 Unauthorized response.
    // When browser receives HTTP 401 code it shows dialog box to enter uid/pwd and there is no way to catch and handle this in javascript.
    // To disable 401 answers from server js-client header should be set. If js-client header is set server sends HTTP OK response with "WWW-Authenticate:" string instead of HTTP 401 code.
    // "WWW-Authenticate: FAILED" - if authorization failed
    // "WWW-Authenticate:digest|basic ... auth params" - if missing authentication params.
    // see AuthenticationHelper.js for more details
    this.httpRequest.setHeader("js-client", "true");
}

ServiceAccessor.prototype =
{
    invoke : function(callback, uri)
    {
        var accessor = this;
        var invokeCallback = function(response, id, statusCode)
        {
            // check that there is no authentication error
            if (AuthenticationHelper.isWwwAuthenticationAnswer(response))
                statusCode =  401;
                
            if (callback != null)
                callback(response, statusCode);
        }
        this.httpRequest.get(invokeCallback, uri, null);
    }
}
