package oauthsample;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

//import com.streamscape.lib.http.HTTPClient;
//import com.streamscape.lib.http.HTTPClientResponse;
//import com.streamscape.lib.http.ModuleException;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.methods.PostMethod;

 @WebServlet(name="/GetAndUseTokenServlet", urlPatterns={"/getandusetoken"})
 public class GetAndUseTokenServlet extends HttpServlet 
 {
	 private static final long serialVersionUID = 1L;

	 public GetAndUseTokenServlet() 
	 {
		 super();
	 }

	 protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException 
	 {
		 requestToken(request, response, "authorization_code");
		 
	 }

	 protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException 
	 {
		 requestToken(request, response, "password");
	 }

	 protected void requestToken(HttpServletRequest request, HttpServletResponse response, String grantType)  throws ServletException, IOException
	 {
		 String url = request.getParameter("acceptorurl");
		 String query = "/security/oauth2/token/";
		 query += "?grant_type=" + grantType;
		 query += "&client_id=" + request.getParameter("client_id");
		 
		 if (grantType.equals("authorization_code"))
		 {
			 query += "&redirect_uri=" + request.getParameter("redirect_uri");
			 query += "&code=" + request.getParameter("code");
		 }
		 else
		 {
			 query += "&username=" + request.getParameter("username");
			 query += "&password=" + request.getParameter("password");
		 }

		 ServletOutputStream answer = response.getOutputStream();
		 
		 answer.println("<html>");
		 answer.println("The following URL is used to request access_token:<br>");
		 answer.println(url+query + "<br><br>");
		 
		 HttpClient client = new HttpClient();
		 PostMethod method = new PostMethod(url+query);
		 
		 try
		 {
			 client.executeMethod(method);
			 String responseBody = method.getResponseBodyAsString();
			 
			 if (method.getStatusCode() != 200)
			 {
				 answer.println("Access token request failed: <br><br>" + responseBody);
				 answer.println("<br><br><a href=\"/OAuthSample/index.html\">Go to the first page</a>");
			 }
			 else
			 {
				 answer.println("Access token successfully received: <br><br>" + responseBody);
				 
				 Pattern access_token_pattern =
						 Pattern.compile("(?s).*\"access_token\"\\s*:\\s*\"([^\"]*)\".*");

		         Matcher matcher = access_token_pattern.matcher(responseBody);
		         if (matcher.find() && matcher.group().equals(responseBody))
		         {
		        	 String access_token = matcher.group(1);
		        	 
		    		 query =  "token=" + access_token;
		    		 query += "&acceptorurl=" + request.getParameter("acceptorurl");;
		    		 query += "&client_id=" + request.getParameter("client_id");

					 answer.println("<br><br><a href=\"/OAuthSample/usetoken?" + query +"\">Use token</a>");
					 answer.println("<br><br><a href=\"/OAuthSample/revoketoken?" + query + "\">Revoke token</a>");
					 answer.println("<br><a href=\"/OAuthSample/revoketoken?" + query + "1\">Revoke token with wrong client_id</a>");
		         }
		         else
		        	 answer.println("<br><br> FAILED TO EXTRACT ACCESS TOKEN<br><br>");
		         
				 answer.println("<br><br><a href=\"/OAuthSample/index.html\">Go to first page</a>");
			 }
			 answer.println("</html>");
		 } 
		 catch (HttpException he) 
		 {

			 response.getOutputStream().println("Http error connecting to '" + url + "'");
			 response.getOutputStream().println(he.getMessage());
			 response.setStatus(method.getStatusCode());
		 } 
		 catch (IOException ioe)
		 {

			 response.getOutputStream().println("Unable to connect to '" + url + "'");
			 response.setStatus(method.getStatusCode());
		 }		 
		 
//		 try 
//		 {
//			HTTPClient httpClient = new HTTPClient(request.getParameter(url));
//			HTTPClientResponse resp = httpClient.Post(query);
//			
//			response.getOutputStream().println(new String(resp.getData()));
//		 } 
//		 catch (ModuleException e) 
//		 {
//			 response.getOutputStream().println("Exception: " + e.getMessage());
//			 return;
//		 }

	 }
	 
 }
