#####################################################################
#
# This sample shows operations with LOB objects.
#
#####################################################################

# import ds module
from stpy import ds

# connect to the dataspace
# NOTE: update url to the your node dataspace and created corresponding dataspace name
# you can create dataspace with the following dataspace command:
#   create dataspace pythonds type tspace
db=ds.connect(url="http://localhost:8888", dataspace="tspace.pythonds",
              username="Admin", password="Admin", timeout=30, autocommit=True)

# create a cursor
c=db.cursor()

# create table with LOB columns
c.execute("create persistent table LobsTable(id int identity, b Blob, c Clob)")

# insert lob data
c.execute("insert into LobsTable values(1, ?, ?)", [bytearray([1,2,3, 4, 5]), 'qwerty'])
c.execute("insert into LobsTable values(2, ?, ?)", [bytearray([10,11,12,13,14,15,16,17,18,19,20]), 'qwerty12345678'])

# LOB column values are returned as objects with interfaces ``Clob`` or ``Blob``, depending of lob type
# By default full lob data are downloaded in first fetch.
# This can be changed with method ``db.set_downloadable_lob_size(size)``
# If lob size is greater than downloadable lob size then lob proxy will be returned and lob data will be downloaded by request.

# set downloadable size to 7
db.set_downloadable_lob_size(7)

# select lobs

c.execute("select * from LobsTable")

# fetch rows
row = c.fetchone()
row

# get BLOB length
row[1].length()

# get full lob content
row[1].get_all_bytes()

# get specified bytes
row[1].get_bytes(1,2)

# get CLOB length
row[2].length()

# get CLOB full content
row[2].get_all_string()

# get CLOB substring
row[2].get_sub_string(1,2)

# fetch next row
row = c.fetchone()
row

row[1].length()
row[1].get_all_bytes()
row[1].get_bytes(1,2)
row[2].length()
row[2].get_all_string()
row[2].get_sub_string(1,2)

# close cursor and connection
c.close()
db.close()