#####################################################################
#
# This sample shows operations with date and time objects.
#
#####################################################################

# import ds module
from stpy import ds

# connect to the dataspace
# NOTE: update url to the your node dataspace and created corresponding dataspace name
# you can create dataspace with the following dataspace command:
#   create dataspace pythonds type tspace
db=ds.connect(url="http://localhost:8888", dataspace="tspace.pythonds",
              username="Admin", password="Admin", timeout=30, autocommit=True)

# create a cursor
c=db.cursor()

# there are 3 date/time types in dataspace
#  - SqlDate - only date
#  - SqlTime - only time
#  - SqlTimestamp - date and time

# create table with date and time columns
c.execute("create persistent table DateTimeTable(id int identity, sDate SqlDate, sTime SqlTime, sTimestamp SqlTimestamp)")

# date and time values can be inserted in different ways

# 1. using string representation
#    in this case timestamp should be in timezone of dataspace
c.execute("insert into DateTimeTable values(1, '2017-02-28', '10:11:12', '2017-02-28 10:11:12.123')")

# 2. using date, time python objects
#    in this case timezone can be in any timezone, by default UTC

#  timezone in UTC timezone
from datetime import datetime, date, time
c.execute("insert into DateTimeTable values(2, ?, ?, ?)", [date(2017, 2, 28), time(13, 17, 20), datetime(2017, 2, 28, 12, 17, 20)])

# timestamp in local timezone
import pytz # $ pip install pytz
from tzlocal import get_localzone # $ pip install tzlocal
sTimestampLocal = get_localzone().localize(datetime(2017, 2, 28, 12, 17, 20))
c.execute("insert into DateTimeTable values(3, ?, ?, ?)", [date(2017, 2, 28), time(13, 17, 20), sTimestampLocal])

# select data

c.execute("select * from DateTimeTable")
row = c.fetchone()
row[0]
row[1]
row[2]
row[3]  # inserted value in dataspace timezone converted to UTC

row[0]
row[1]
row[2]
row[3]  # result in UTC, the same as was passed to insert

row = c.fetchone()
row[0]
row[1]
row[2]
row[3]   # result in UTC, value passed to insert converted to UTC timezone


c.close()
db.close()