#####################################################################
#
# This sample shows basic operations, like create table,
# insert rows and select that can be executed with stpy.ds
#
#####################################################################

# import ds module
from stpy import ds

# connect to the dataspace
# NOTE: update url to the your node dataspace and created corresponding dataspace name
# you can create dataspace with the following dataspace command:
#   create dataspace pythonds type tspace
db=ds.connect(url="http://localhost:11801", dataspace="tspace.pythonds",
              username="admin", password="admin", timeout=30, autocommit=True)

# create a cursor
c=db.cursor()

# set fetch size to 0 that means download all rows at first time
c.arraysize = 0

# create table
c.execute("create persistent table accounts(id int, name string, followers long, primary key(id))")

# insert rows into the table
c.execute("insert into accounts values(1, 'Bill', 80)")
c.execute("insert into accounts values(2, ?, 10000)", ('Steve',))  # using question mark formatting
c.execute("insert into accounts values(3, ?, ?)", ['Mark', 900])  # using question mark formatting
c.execute("insert into accounts values(4, 'Mike', 12000)")
c.execute("insert into accounts values(5, 'Dave', 200)")

# select from table:
min_followers=100
c.execute("select name, followers from accounts where followers > ?", (min_followers,))

# get info about returned row set
c.description

# get rows count
c.rowcount

# fetch first row
c.fetchone()

# fetch second row
c.next()

# fetch using fetchmany()
c.fetchmany(10)

# scroll the cursor to first row
c.scroll(0, "absolute")

# fetch 10 rows
c.fetchmany(10)

# fetch next
c.next()

# close the cursor
c.close()

# close the connection
db.close()

