function alertExceptionHandler(exception)
{
    if ((exception != null) && (exception.detailMessage != null))
        alert(exception.detailMessage);
    else
        alert("Exception: " + exception);
}

function showNodeName(fabricNode)
{
    var node = document.getElementById('node');
    node.innerHTML = fabricNode.node.name;

    var url = document.getElementById('url');
    var domain = document.getElementById('domain');
    if ((url.value == null) || (url.value.length == 0))
    {
        domain.selectedIndex = 0;

        var port = window.location.port;
        if ((port == null) || (port.length == 0))
            port = '80';
        url.value = window.location.hostname + ':' + port;
    }
    else
    {
        domain.selectedIndex = 1;
    }
}

fabricConnection = null;

function connect()
{
    var url = document.getElementById('url').value;
    var login = document.getElementById('login').value;
    var password = document.getElementById('password').value;
    fabricConnection = new HTTPFabricConnection(login, password, alertExceptionHandler, url);
    fabricConnection.open();
    fabricConnection.getModerator().getFabricNode(showNodeName);

    var connectButton = document.getElementById('connect');
    if (connectButton != null)
        connectButton.disabled = true;

    var eventIdField = document.getElementById('eventId');
    if (eventIdField != null)
        eventIdField.disabled = false;

    var subsButton = document.getElementById('subscribe');
    if (subsButton != null)
        subsButton.disabled = false;
}

function onMessage(receivedEvent)
{
    var console = document.getElementById('console');
    if (receivedEvent == null)
        return;

    var str = '';
    str = Utilities.encode(receivedEvent);
    str = str.replace(/,/g, ',\n  ');
    str = str.replace(/:{/g, ':\n  {');
    str = str.replace(/"}/g, '"\n  }');
    str = str.replace(/{/g, '{\n  ');
    str = str.replace(/}}/g, '}\n}');

    console.value = console.value + str + '\n---------------------------------------\n';
}

function subscribe()
{
    var eventId = document.getElementById('eventId').value;
    var name = 'Consumer_' + eventId;
    if (fabricConnection.getEventAsyncConsumer(name) == null)
    {
        var listener = new EventListener(onMessage);
        var consumer = fabricConnection.createEventAsyncConsumer(
            name, listener, eventId, null, 'INHERITED', false);
        consumer.start();
    }
    else
    {
        alert('Already subscribed to ' + eventId);
    }
}


