function alertExceptionHandler(exception)
{
    if ((exception != null) && (exception.detailMessage != null))
        alert(exception.detailMessage);
    else
        alert("Exception: " + exception);
}

function showNodeName(fabricNode)
{
    var node = document.getElementById('node');
    node.innerHTML = fabricNode.node.name;

    var url = document.getElementById('url');
    var domain = document.getElementById('domain');
    if ((url.value == null) || (url.value.length == 0))
    {
        domain.selectedIndex = 0;

        var port = window.location.port;
        if ((port == null) || (port.length == 0))
            port = '80';
        url.value = window.location.hostname + ':' + port;
    }
    else
    {
        domain.selectedIndex = 1;
    }
}

fabricConnection = null;

function connect()
{
    var url = document.getElementById('url').value;
    var login = document.getElementById('login').value;
    var password = document.getElementById('password').value;
    fabricConnection = new HTTPFabricConnection(login, password, alertExceptionHandler, url);
    fabricConnection.open();
    fabricConnection.getModerator().getFabricNode(showNodeName);

    var id = document.getElementById('eventId').value;
    var factory = fabricConnection.getEventDatagramFactory();
    factory.createEvent(id, processEvent);

    var connectButton = document.getElementById('connect');
    if (connectButton != null)
        connectButton.disabled = true;

    var eventIdField = document.getElementById('eventId');
    if (eventIdField != null)
        eventIdField.disabled = false;

    var sendButton = document.getElementById('send');
    if (sendButton != null)
        sendButton.disabled = false;
}

var eventObject = null;

var testObject = 
{
    '@type' : 'TestData',
    firstname    : 'neeve',
    lastname     : 'tech',
    id           : 0,
    title        : 'best'
};

var testXml = '<?xml version="1.0"?>\n<TestXml>\n <name>Neeve</name>\n <surname>Tech</surname>\n <success>true</success>\n</TestXml>';

var eventCaches = {};

function processEventId()
{
    var id = document.getElementById('eventId').value;
    var factory = fabricConnection.getEventDatagramFactory();
    factory.createEvent(id, processEvent);
}

function processEvent(createdEvent)
{
    eventObject = createdEvent;
}

function raise() 
{
    setData(eventObject);
    var eventId = eventObject.getEventId();
    fabricConnection.bindProducerFor(eventId);
    if (eventCaches[eventId] == null)
    {
        eventCaches[eventId] = true;
        fabricConnection.addEventCache(eventId, 5, 'LRE_DISCARD');
    }
    fabricConnection.raiseEvent(eventObject, 'INHERITED', 0);
}

function setData(event)
{
    var data = document.getElementById('data').value;

    if (event instanceof Event.TextEvent)
    {
        event.setText(data);
    }
    else if (event instanceof Event.DataEvent)
    {
        ++(testObject.id);
        testObject.title = data;
        event.setData(testObject);
    }
    else if (event instanceof Event.AcknowledgementEvent)
    {
        event.setData(data);
    }
    else if (event instanceof Event.BytesEvent)
    {
        event.setBytes(Base64.encode(data));
    }
    else if (event instanceof Event.MapEvent)
    {
        event.setValue('data', data);
    }
    else if (event instanceof Event.XMLEvent)
    {
        event.setXML('<?xml version="1.0"?>\n<TestXml>\n <name>Neeve</name>\n'
            + '<surname>Tech</surname>\n <success>true</success>\n</TestXml>');
    }
    else if (event instanceof Event.RowEvent)
    {
        event.getRow().setColumn(1, data);
    }
    else if (event instanceof Event.RowSetEvent)
    {
        var row = [ data, ++(testObject.id) ];
        event.getRowSet().addRow(row);
    }
    else if (event instanceof Event.RowArrayEvent)
    {
        var row = event.getRowArray().newRow();
        row.setColumn(2, data);
        event.getRowArray().addRow(row);
    }
}

