package data.analyzer;

import com.streamscape.lib.analyzer.*;
import com.streamscape.omf.mf.admin.ObjectMediationAliasManager;

import java.io.FileOutputStream;

/**
 * <p>Title: Java Samples</p>
 *
 * <p>Description: Sample for {@link com.streamscape.lib.analyzer.TypeAnalyzer}.</p>
 *
 * <p>Copyright: Copyright (c) 2011</p>
 *
 * <p>Company: StreamScape Technologies</p>
 *
 * @author Mikhail Batsyn
 * @version 3.2
 */
 public class TypeAnalyzerSample
 {
   static class SimpleCache extends ObjectMediationAliasManager
   {
      public String resolveSemanticType(String typeName)
      {
         return typeName;
      }
   }

   public static void main(String[] args)
   {
      if (args.length < 1)
      {
         System.out.println("Please specify a full class name as an argument.");
         System.out.println("Examples: java.util.HashMap, data.analyzer.TypeAnalyzerSample, com.streamscape.lib.analyzer.TypeGraph, " +
                            "com.streamscape.lib.analyzer.TypeAnalyzerFactory");
         return;
      }
      TypeAnalyzerFactory factory = TypeAnalyzerFactory.getInstance();
      factory.setSemanticTypeCache(new SimpleCache());
      TypeAnalyzer analyzer = factory.createTypeAnalyzer();
      try
      {
         TypeGraph graph = analyzer.getTypeGraph("//{" + args[0] + "}");

         TypeGraphPrintVisitor visitor = new TypeGraphPrettyPrintVisitor();
         visitor.setOutput(new FileOutputStream("graph.txt"));
         graph.traverse(visitor);

         visitor = new TypeGraphXmlPrintVisitor();
         visitor.setOutput(new FileOutputStream("graph.xml"));
         graph.traverse(visitor);

         visitor = new TypeGraphJsonPrintVisitor();
         visitor.setOutput(new FileOutputStream("graph.json"));
         graph.traverse(visitor);

         System.out.println("Printed the type graph text, xml, json representations to 'graph.txt', 'graph.xml', 'graph.json' files");
      }
      catch (Exception exception)
      {
         exception.printStackTrace();
      }
   }
 }
