package client.reliable;

import com.streamscape.Trace;
import com.streamscape.runtime.RuntimeContext;

/**
 * <p>Title: Java Samples</p>
 *
 * <p>Description: Proxy node of the 'client/reliable' sample.
 *
 * <p>User can re-launch this node and both clients will automatically reconnect to it.
 *
 * <p>Copyright: Copyright (c) 2014</p>
 *
 * <p>Company: StreamScape Technologies</p>
 *
 * @author Mikhail Filichev
 * @version 3.4
 */
 public class ProxyRuntime
 {
    private static final String EVENT_ID = "event.sample";

    public static void main(String[] args)
    {
       try
       {
          // Enables some traces.
          Trace.enable("*",                         Trace.Level.ERROR);
          Trace.enable("com.streamscape.runtime.*", Trace.Level.INFO);

          // Sets a startup directory of the Runtime.
          System.setProperty(RuntimeContext.STARTUP_DIR, ".");
          // Sets a path to the directory containing a deployment descriptor archive (stdeploy.jar).
          System.setProperty(RuntimeContext.DEPLOYMENT, ".");

          // Initializes the Runtime Context.
          RuntimeContext context = RuntimeContext.getInstance();

          System.out.println("\nAdd prototype...\n");
          if (!context.getDatagramPrototypeFactory().existsPrototype(EVENT_ID))
             context.getDatagramPrototypeFactory().addEventPrototype("TextEvent", EVENT_ID);
       }
       catch (Exception exception)
       {
          exception.printStackTrace();
          System.exit(1);
       }
    }
 }
