<?xml version="1.0"?>
<ServiceConfiguration>
  <serviceType>HTTPEventSource</serviceType>
  <serviceName>prototype</serviceName>
  <serviceDisplayName>HTTP Event Source</serviceDisplayName>
  <serviceDesc>Allows to send HTTP requests with specified interval to the configured HTTP server.</serviceDesc>
  <serviceClass>com.streamscape.service.http.evSource.HTTPEventSource</serviceClass>
  <eimPlugin></eimPlugin>
  <validatorClass>com.streamscape.service.ui.validators.DefaultValidator</validatorClass>
  <invokeMode>ASYNC</invokeMode>
  <daemonService>false</daemonService>
  <interruptable>false</interruptable>
  <propertiesRegistry>
    <propertiesTable>
      <entry>
        <string>enable.buffering</string>
        <Property>
          <propertyName>enable.buffering</propertyName>
          <labelName>Enable Buffering</labelName>
          <propertyDescription>Specifies whether buffering of HTTP responses should be enabled.</propertyDescription>
          <propertyGroup>main.group</propertyGroup>
          <dataType>BOOLEAN</dataType>
          <isRequired>false</isRequired>
          <rangeList></rangeList>
          <propertyValue SemanticType="boolean">false</propertyValue>
          <isExportable>true</isExportable>
        </Property>
      </entry>
      <entry>
        <string>response.format</string>
        <Property>
          <propertyName>response.format</propertyName>
          <labelName>Response Format</labelName>
          <propertyDescription>Specifies format of HTTP response.</propertyDescription>
          <propertyGroup>main.group</propertyGroup>
          <dataType>STRING</dataType>
          <isRequired>false</isRequired>
          <rangeList>TEXT,XML,JSON,BINARY</rangeList>
          <propertyValue SemanticType="string">TEXT</propertyValue>
          <isExportable>true</isExportable>
        </Property>
      </entry>
      <entry>
        <string>include.http.headers</string>
        <Property>
          <propertyName>include.http.headers</propertyName>
          <labelName>Include HTTP Headers</labelName>
          <propertyDescription>Specifies whether HTTP headers should be included into response.</propertyDescription>
          <propertyGroup>main.group</propertyGroup>
          <dataType>BOOLEAN</dataType>
          <isRequired>false</isRequired>
          <rangeList></rangeList>
          <propertyValue SemanticType="boolean">false</propertyValue>
          <isExportable>true</isExportable>
        </Property>
      </entry>
      <entry>
        <string>event.id</string>
        <Property>
          <propertyName>event.id</propertyName>
          <labelName>Publish Event Id</labelName>
          <propertyDescription>Specifies event Id of the event which will be used for HTTP responses publishing.</propertyDescription>
          <propertyGroup>main.group</propertyGroup>
          <dataType>STRING</dataType>
          <isRequired>false</isRequired>
          <rangeList></rangeList>
          <propertyValue SemanticType="string"></propertyValue>
          <isExportable>true</isExportable>
        </Property>
      </entry>
      <entry>
        <string>connection.http</string>
        <Property>
          <propertyName>connection.http</propertyName>
          <labelName>HTTP Connection Factory</labelName>
          <propertyDescription>Specifies HTTP connection factory.</propertyDescription>
          <propertyGroup>main.group</propertyGroup>
          <dataType>CLIENT_FACTORY</dataType>
          <isRequired>false</isRequired>
          <rangeList></rangeList>
          <propertyValue SemanticType="Value.CLIENT_FACTORY">
            <factoryType>FactoryType</factoryType>
            <factoryName>FactoryName</factoryName>
          </propertyValue>
          <isExportable>true</isExportable>
        </Property>
      </entry>
      <entry>
        <string>polling.interval</string>
        <Property>
          <propertyName>polling.interval</propertyName>
          <labelName>Polling Interval</labelName>
          <propertyDescription>Specifies interval of HTTP server polling.</propertyDescription>
          <propertyGroup>main.group</propertyGroup>
          <dataType>NUMERIC</dataType>
          <isRequired>false</isRequired>
          <rangeList></rangeList>
          <propertyValue SemanticType="long">1000</propertyValue>
          <isExportable>true</isExportable>
        </Property>
      </entry>
      <entry>
        <string>http.method</string>
        <Property>
          <propertyName>http.method</propertyName>
          <labelName>HTTP Method Name</labelName>
          <propertyDescription>Specifies HTTP method which should be used to call HTTP server (GET, POST, etc...).</propertyDescription>
          <propertyGroup>main.group</propertyGroup>
          <dataType>STRING</dataType>
          <isRequired>false</isRequired>
          <rangeList></rangeList>
          <propertyValue SemanticType="string">GET</propertyValue>
          <isExportable>true</isExportable>
        </Property>
      </entry>
      <entry>
        <string>request.uri</string>
        <Property>
          <propertyName>request.uri</propertyName>
          <labelName>Request URI</labelName>
          <propertyDescription>Specifies request URI which should be sent to HTTP server.</propertyDescription>
          <propertyGroup>main.group</propertyGroup>
          <dataType>STRING</dataType>
          <isRequired>false</isRequired>
          <rangeList></rangeList>
          <propertyValue SemanticType="string"></propertyValue>
          <isExportable>true</isExportable>
        </Property>
      </entry>
    </propertiesTable>
    <propertyGroups>
      <string>main.group</string>
    </propertyGroups>
  </propertiesRegistry>
  <advancedPropertiesRegistry>
    <advancedPropertiesTable>
      <entry>
        <string>tlpSessionFlushDelay</string>
        <Property.ADVANCED>
          <name>tlpSessionFlushDelay</name>
          <value SemanticType="long">2</value>
          <label>Session Flush Delay</label>
          <description>Specifies in milliseconds the session&apos;s event flush delay. Defaults to 2 milliseconds.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>tlpLinkSolicitAllow</string>
        <Property.ADVANCED>
          <name>tlpLinkSolicitAllow</name>
          <value SemanticType="boolean">false</value>
          <label>Allow Dynamic Link Soliciting</label>
          <description>When enabled, allows components to dynamically register links when solicited.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>enableServiceStats</string>
        <Property.ADVANCED>
          <name>enableServiceStats</name>
          <value SemanticType="boolean">false</value>
          <label>Enable Service Stats</label>
          <description>Enables statistics collecting for service, such as method execution time.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>tlpSessionExchangeMode</string>
        <Property.ADVANCED>
          <name>tlpSessionExchangeMode</name>
          <value SemanticType="string">optimistic</value>
          <label>Session Exchange Mode</label>
          <description>The datagram exchange mode of a session (&apos;optimistic&apos;, &apos;adaptive&apos;, &apos;sync&apos;, &apos;sequenced&apos;).</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>producerMfLeaseInterval</string>
        <Property.ADVANCED>
          <name>producerMfLeaseInterval</name>
          <value SemanticType="long">360000</value>
          <label>Producer Lease Interval</label>
          <description>For event producers, the interval at which the moderator statistics lease is renewed (defaults to 1 hour).</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>consumerAsyncQueueMaxDepth</string>
        <Property.ADVANCED>
          <name>consumerAsyncQueueMaxDepth</name>
          <value SemanticType="long">10000</value>
          <label>Async Event Queue Depth</label>
          <description>For async listeners, the depth of the event delivery queue (defaults to 10000).</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>daemonServiceMaxWorkTime</string>
        <Property.ADVANCED>
          <name>daemonServiceMaxWorkTime</name>
          <value SemanticType="long">3600</value>
          <label>Daemon Service Max Work Time</label>
          <description>This timeout in seconds is used by Service Watcher thread to check if the service is alive and doesn&apos;t hang.
Default max work time is 3600 seconds(60 minutes). Max time for one service iterations is a sum of passive iteration
interval and max work time.Check is performed every 30 seconds. [advisory.service.blocked] advisory is sent every 5 minutes.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>consumerAsyncSpinWait</string>
        <Property.ADVANCED>
          <name>consumerAsyncSpinWait</name>
          <value SemanticType="long">3</value>
          <label>Async Event Delivery Interval</label>
          <description>For async listeners, the milliseconds a delivery thread waits between scheduled spins.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>serviceStopTimeout</string>
        <Property.ADVANCED>
          <name>serviceStopTimeout</name>
          <value SemanticType="long">15</value>
          <label>Service Stop Timeout</label>
          <description>Specifies the wait time (in seconds) for completion of pending operations during service stopping. Non-positive value means that service will not wait for completion of pending operations. Default is 15 seconds.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>tlpForceConnection</string>
        <Property.ADVANCED>
          <name>tlpForceConnection</name>
          <value SemanticType="boolean">false</value>
          <label>Force New Connection</label>
          <description>When true, this component will form a new socket connection to it&apos;s peer.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>exceptionSuppressStacktrace</string>
        <Property.ADVANCED>
          <name>exceptionSuppressStacktrace</name>
          <value SemanticType="boolean">true</value>
          <label>Suppress Exception Stack Trace</label>
          <description>Removes stack trace from exceptions thrown by Service methods invoked via Accessor (defaults to false).</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>servicePoolSize</string>
        <Property.ADVANCED>
          <name>servicePoolSize</name>
          <value SemanticType="long">1</value>
          <label>Service Pool Size</label>
          <description>Specifies service pool size in the service component.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>consumerAsyncDeliveryMode</string>
        <Property.ADVANCED>
          <name>consumerAsyncDeliveryMode</name>
          <value SemanticType="string">async</value>
          <label>Async Event Delivery Mode</label>
          <description>For async listeners, the mode of event delivery (&apos;async&apos; or &apos;async_paced&apos;).</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>consumerAsyncQueueFlowcontrol</string>
        <Property.ADVANCED>
          <name>consumerAsyncQueueFlowcontrol</name>
          <value SemanticType="string">exception</value>
          <label>Async Flow Control Mode</label>
          <description>For async listeners, the flow control mode (&apos;notify&apos; or &apos;exception&apos;).</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>tlpEventScope</string>
        <Property.ADVANCED>
          <name>tlpEventScope</name>
          <value SemanticType="string">observable</value>
          <label>Component Event Scope</label>
          <description>The visibility scope of events for this component (&apos;local&apos;, &apos;observable&apos;, &apos;global&apos;, &apos;clustered&apos;).</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>tlpLinkMaxSessions</string>
        <Property.ADVANCED>
          <name>tlpLinkMaxSessions</name>
          <value SemanticType="long">20</value>
          <label>Maximum Link Sessions</label>
          <description>Sets the number of concurrent link sessions this component may have.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>componentRefNamespace</string>
        <Property.ADVANCED>
          <name>componentRefNamespace</name>
          <value SemanticType="string">/service</value>
          <label>Reference Context Namespace</label>
          <description>Specifies a Namespace (ie. /service/db) in the repository where the component may store supporting objects.</description>
        </Property.ADVANCED>
      </entry>
    </advancedPropertiesTable>
  </advancedPropertiesRegistry>
  <metricsRegistry>
    <metricsTable/>
  </metricsRegistry>
  <advisoriesRegistry>
    <stateAdvisoriesTable/>
    <advisoriesTable>
      <string>advisory.component.StateChange</string>
      <string>advisory.connection.StateChange</string>
    </advisoriesTable>
  </advisoriesRegistry>
  <actionableEventsRegistry>
    <actionableEventsTable/>
  </actionableEventsRegistry>
  <eventHandlersRegistry>
    <handlersTable/>
  </eventHandlersRegistry>
  <exceptionsRegistry>
    <exceptionsTable>
      <string>exception.service.Framework</string>
      <string>exception.cli.Interface</string>
    </exceptionsTable>
  </exceptionsRegistry>
  <configTimeStamp>1535704533287</configTimeStamp>
  <eventTriggersRegistry>
    <triggers/>
  </eventTriggersRegistry>
</ServiceConfiguration>