#!/bin/sh

RELATIVE_SLANG_DIR=`dirname $0`
CURRENT_DIR=`pwd`
SLANG_DIR=$RELATIVE_SLANG_DIR
echo $RELATIVE_SLANG_DIR | grep -E "^\..*" > /dev/null
if [ $? -eq 0 ]; then
   SLANG_DIR=$CURRENT_DIR/$RELATIVE_SLANG_DIR
fi

SHELL_PATH=`where sh`
if [ $? -ne 0 ]; then
	echo "Failed to find sh.exe" 
	exit -1;
fi
SHELL_PATH=`echo $SHELL_PATH | sed -e 's/ *$//g'`
#SHELL_PATH=`cygpath -w $SHELL_PATH 2>/dev/null`

TTY=`tty`
if [ $? -ne 0 ]; then
	echo "Failed to determine tty" 
	exit -1;
fi

stty -icanon min 1 -icrnl -inlcr 
stty intr ^q
stty -echo

$SLANG_DIR/slang.exe $* -cygwin -shellpath "$SHELL_PATH" -tty $TTY

ret_code=$?

stty sane

exit $ret_code
