/*
 * Decompiled with CFR 0.152.
 */
package samples.txfs;

import com.streamscape.lib.txfs.FileTransaction;
import com.streamscape.lib.txfs.FileTransactionStateAdvisoryListener;
import com.streamscape.lib.txfs.TransactionState;
import com.streamscape.lib.txfs.mf.admin.FileResourceManagerFactory;
import java.io.BufferedReader;
import java.io.IOException;
import samples.txfs.SuspendTransactionDemo;

public class AbstractTXFSDemo {
    protected FileTransaction tx;
    protected String txId;
    protected static BufferedReader reader;
    protected static AbstractTXFSDemo txDemo;
    protected boolean isRecover = false;
    protected boolean isRollback = false;
    protected boolean isCommitted = false;

    protected void chooseAction() throws IOException {
        System.out.println("");
        System.out.println("Choose further action.");
        if (!this.isCommitted) {
            System.out.println("(1) - add copy action");
            System.out.println("(2) - add move action");
            System.out.println("(3) - add delete action");
            System.out.println("(4) - add rename action");
            System.out.println("-----------------------");
            System.out.println("(6) - checkpoint");
            System.out.println("(7) - commit");
        }
        if (this.isRecover) {
            System.out.println("(8) - recover");
        }
        if (this.isRollback) {
            System.out.println("(9) - rollback");
        }
        System.out.println("-----------------------");
        System.out.println("(0) - exit");
        System.out.print("Enter you choice: ");
        String line = SuspendTransactionDemo.reader.readLine();
        if (line == null || line.length() <= 0) {
            System.out.println("Wrong parameter. Please, re-enter.");
            this.chooseAction();
        } else {
            char ac = line.charAt(0);
            try {
                switch (ac) {
                    case '1': {
                        this.addCopy();
                        break;
                    }
                    case '2': {
                        this.addMove();
                        break;
                    }
                    case '3': {
                        this.addDelete();
                        break;
                    }
                    case '4': {
                        this.addRename();
                        break;
                    }
                    case '6': {
                        this.checkpoint();
                        break;
                    }
                    case '7': {
                        this.commit();
                        break;
                    }
                    case '8': {
                        this.recover();
                        break;
                    }
                    case '9': {
                        this.rollback();
                        break;
                    }
                    case '0': {
                        this.exit();
                    }
                    default: {
                        System.out.println("Wrong input. Try again");
                        this.chooseAction();
                        break;
                    }
                }
            }
            catch (Exception e) {
                System.out.println();
                System.out.println("Exception: " + e.getLocalizedMessage());
                this.waitForUser();
                this.chooseAction();
            }
        }
    }

    protected void waitForUser() throws IOException {
        System.out.println("Press 'Enter' to continue...");
        SuspendTransactionDemo.reader.readLine();
    }

    protected void addCopy() throws IOException {
        System.out.println("Enter parameters for copy action:");
        String from = this.readUserInput("source file");
        String to = this.readUserInput("destination file");
        FileResourceManagerFactory.getTransaction((String)this.txId).copy(from, to);
        System.out.println("Add copy action from '" + from + "' to '" + to + "'");
        this.chooseAction();
    }

    protected void addMove() throws IOException {
        System.out.println("Enter parameters for move action:");
        String from = this.readUserInput("source file");
        String to = this.readUserInput("destination file");
        FileResourceManagerFactory.getTransaction((String)this.txId).moveFile(from, to);
        System.out.println("Add move action from '" + from + "' to '" + to + "'");
        this.chooseAction();
    }

    protected void addDelete() throws IOException {
        System.out.println("Enter parameters for delete action:");
        String from = this.readUserInput("file to delete");
        this.tx.delete(from);
        System.out.println("Add delete action for '" + from + "'");
        this.chooseAction();
    }

    protected void addRename() throws IOException {
        System.out.println("Enter parameters for rename action:");
        String from = this.readUserInput("source file");
        String to = this.readUserInput("destination file");
        this.tx.rename(from, to);
        System.out.println("Add rename action from '" + from + "' to '" + to + "'");
        this.chooseAction();
    }

    protected void commit() throws IOException {
        System.out.println("Committing");
        try {
            this.isCommitted = true;
            this.tx.commit();
            while (!this.tx.isDone()) {
                System.out.print(".");
                Thread.sleep(200L);
            }
            this.tx.getResult();
            System.out.println("");
            System.out.println("Successful commit");
            this.waitForUser();
            this.exit();
        }
        catch (Exception e) {
            System.out.println("\nException while committing: " + e.getCause().getLocalizedMessage());
            this.isRollback = true;
            if (this.tx.isSuspendable()) {
                this.isRecover = true;
            }
            if (this.tx.isAutoRecovery()) {
                System.out.println("Waiting for auto-recovery");
                this.tx.setListener((FileTransactionStateAdvisoryListener)new MyFileTransactionStateAdvisoryListener());
            }
            this.chooseAction();
        }
    }

    protected void checkpoint() throws IOException {
        System.out.println("Start making a checkpoint...");
        try {
            this.tx.checkpoint();
            while (!this.tx.isDone()) {
                System.out.print(".");
                Thread.sleep(200L);
            }
            this.tx.getResult();
            System.out.println("");
            System.out.println("Successful commit");
            System.out.println("Checkpoint done");
            this.waitForUser();
            this.isRollback = true;
            this.chooseAction();
        }
        catch (Exception e) {
            if (this.tx.isSuspendable()) {
                this.isRecover = true;
            }
            this.isRollback = true;
            System.out.println("\nException while checkpoint: " + e.getCause().getLocalizedMessage());
            if (this.tx.isAutoRecovery()) {
                System.out.println("Waiting for auto-recovery");
                this.tx.setListener((FileTransactionStateAdvisoryListener)new MyFileTransactionStateAdvisoryListener());
            }
            this.chooseAction();
        }
    }

    protected void rollback() throws IOException {
        System.out.println("Starting rollback...");
        try {
            this.tx.rollback();
            System.out.println("Successful rollback");
            this.waitForUser();
            this.exit();
        }
        catch (Exception e) {
            System.out.println("Exception while rolling back: " + e.getLocalizedMessage());
            this.chooseAction();
        }
    }

    protected void recover() throws IOException {
        System.out.println("Starting recover...");
        try {
            this.tx.recover();
            System.out.println("Successful recover");
            this.waitForUser();
            this.exit();
        }
        catch (Exception e) {
            System.out.println("Exception while recovering: " + e.getLocalizedMessage());
            this.chooseAction();
        }
    }

    protected String readUserInput(String message) {
        System.out.print("Enter " + message + ": ");
        try {
            String directory = SuspendTransactionDemo.reader.readLine();
            boolean success = true;
            if (directory == null || directory.length() <= 0) {
                success = false;
            }
            if (success) {
                return directory;
            }
            System.out.println(message + "is not correct. Please, re-enter.");
            return this.readUserInput(message);
        }
        catch (IOException ioe) {
            System.out.println("IO error trying to read " + message + "!");
            return this.readUserInput(message);
        }
    }

    protected void exit() {
        System.exit(0);
    }

    private class MyFileTransactionStateAdvisoryListener
    implements FileTransactionStateAdvisoryListener {
        private MyFileTransactionStateAdvisoryListener() {
        }

        public void onStateChange(TransactionState state) {
            System.out.println("Change transaction state to " + String.valueOf(state));
            try {
                if (state == TransactionState.ONLY_ROLLBACK) {
                    AbstractTXFSDemo.this.chooseAction();
                } else if (state == TransactionState.COMMITED) {
                    System.out.println("Successfully commit transaction");
                    AbstractTXFSDemo.this.exit();
                } else if (state == TransactionState.ROLLED_BACK) {
                    System.out.println("Successfully rolled back transaction");
                    AbstractTXFSDemo.this.exit();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
    }
}

