/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.xml.evSink;

import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationFactory;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationObject;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.SecurityViolationException;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sdo.event.XMLEvent;
import com.streamscape.sdo.excp.XMLParseException;
import com.streamscape.sdo.mf.admin.TypeFactory;
import com.streamscape.sdo.utils.SDOUtils;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.service.AbstractService;
import com.streamscape.service.file.StreamWriter;
import com.streamscape.service.osf.config.AbstractServiceConfigurationObject;
import com.streamscape.service.osf.config.ServiceConfigurationException;
import com.streamscape.service.osf.config.ServiceConfigurationProperty;
import com.streamscape.service.osf.config.ServicePropertyType;
import com.streamscape.service.osf.enums.InvokeMode;
import com.streamscape.service.osf.evh.EventHandler;
import com.streamscape.service.xml.enums.FileWriterIncomingType;
import com.streamscape.service.xml.enums.XMLStreamState;
import com.streamscape.service.xml.evSink.Version;
import com.streamscape.service.xml.utils.EventSenders;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;

public class XMLEventSink
extends AbstractService {
    public static final String TEMP_FILE_EXTENSION = ".tmp";
    public static final String RESULT_FILE_EXTENSION = ".xml";
    private String header = "";
    private String rootElement = null;
    private String mainRootElement = null;
    private String mainRootElementClosed = "";
    private String resultfilePrefix = null;
    private String currentFileName = null;
    private StreamWriter writer = null;
    private boolean sendOpenStreamEvent = false;
    private boolean sendCloseStreamEvent = false;
    private boolean sendAbortStreamEvent = false;
    private FileWriterIncomingType incomingDataType = FileWriterIncomingType.XML_DOCUMENT;
    private String streamStateEventId = null;
    private String fileActionEventId = null;
    private String timestampFormat = "yyyyMMdd_HHmmssSSS";
    private EventDatagramFactory datagramFactory = null;

    protected void doInit() {
        try {
            if (this.sco.getServiceConfigurationProperties().hasProperty("xml.processing.strategy")) {
                String incomType = this.sco.getServiceConfigurationProperties().getProperty("xml.processing.strategy").toString();
                this.incomingDataType = incomType.equals(FileWriterIncomingType.XML_DOCUMENT.name()) ? FileWriterIncomingType.XML_DOCUMENT : FileWriterIncomingType.XML_FRAGMENT;
            }
            if (!this.sco.getServiceConfigurationProperties().hasProperty("file.name")) {
                throw new RuntimeException("Output filename must be specified");
            }
            this.resultfilePrefix = this.sco.getServiceConfigurationProperties().getProperty("file.name").toString();
            if (this.sco.getServiceConfigurationProperties().hasProperty("xml.fragment.name")) {
                this.rootElement = this.sco.getServiceConfigurationProperties().getProperty("xml.fragment.name").toString();
                if (this.rootElement.length() <= 0) {
                    this.rootElement = null;
                }
            }
            this.header = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
            if (this.sco.getServiceConfigurationProperties().hasProperty("xml.custom.header")) {
                this.mainRootElement = this.sco.getServiceConfigurationProperties().getProperty("xml.custom.header").toString();
            }
            if (this.sco.getServiceConfigurationProperties().hasProperty("xml.root")) {
                this.mainRootElementClosed = this.sco.getServiceConfigurationProperties().getProperty("xml.root").toString();
            }
            if (this.sco.getServiceConfigurationProperties().hasProperty("timestamp.format")) {
                this.timestampFormat = this.sco.getServiceConfigurationProperties().getProperty("timestamp.format").toString();
            }
            if (this.mainRootElement == null) {
                this.mainRootElement = this.mainRootElementClosed;
            }
            this.streamStateEventId = this.sco.getServiceConfigurationProperties().getProperty("stream.state.eventId").toString();
            this.sendOpenStreamEvent = Boolean.parseBoolean(this.sco.getServiceConfigurationProperties().getProperty("raise.open.stream.event").toString());
            this.sendCloseStreamEvent = Boolean.parseBoolean(this.sco.getServiceConfigurationProperties().getProperty("raise.close.stream.event").toString());
            this.sendAbortStreamEvent = Boolean.parseBoolean(this.sco.getServiceConfigurationProperties().getProperty("raise.abort.stream.event").toString());
            this.fileActionEventId = this.sco.getServiceConfigurationProperties().getProperty("file.action.eventId").toString();
            this.datagramFactory = this.context.getEventDatagramFactory();
        }
        catch (ServiceConfigurationException error) {
            throw new RuntimeException(error);
        }
    }

    public int getMinorBuild() {
        return Version.getBuild();
    }

    public int getMajorVersion() {
        return Version.getMajorVersion();
    }

    public int getMinorVersion() {
        return Version.getMinorVersion();
    }

    public String getVersion() {
        return Version.getVersionString();
    }

    public void streamStateChange(XMLStreamState state) throws Exception {
        if (state.equals((Object)XMLStreamState.OPENED)) {
            SimpleDateFormat DATE_FORMAT = new SimpleDateFormat(this.timestampFormat);
            String timestamp = DATE_FORMAT.format(new Date(System.currentTimeMillis()));
            this.currentFileName = this.resultfilePrefix + timestamp + TEMP_FILE_EXTENSION;
            this.writer = new StreamWriter(this.currentFileName);
            this.ctx.logInfo("File '" + this.currentFileName + "' has been opened for writing.");
            EventSenders.sendXMLStreamStateEvent(XMLStreamState.OPENED, this.datagramFactory, this.ctx, this.sendOpenStreamEvent, this.streamStateEventId);
            if (this.incomingDataType.equals((Object)FileWriterIncomingType.XML_FRAGMENT)) {
                this.writer.writeStringToFile(this.header + "\n");
                this.writer.writeStringToFile("<" + this.mainRootElement + ">\n");
            }
        } else if (state.equals((Object)XMLStreamState.CLOSED)) {
            if (this.incomingDataType.equals((Object)FileWriterIncomingType.XML_FRAGMENT)) {
                this.writer.writeStringToFile("</" + this.mainRootElementClosed + ">");
            }
            this.writer.closeWriter();
            this.ctx.logInfo("File '" + this.currentFileName + "' has been closed.");
            EventSenders.sendXMLStreamStateEvent(XMLStreamState.CLOSED, this.datagramFactory, this.ctx, this.sendCloseStreamEvent, this.streamStateEventId);
            this.renameResultFile();
        } else if (state.equals((Object)XMLStreamState.ABORTED)) {
            boolean deleted;
            this.writer.closeWriter();
            if (FileIOUtils.fileAvailable((String)this.currentFileName) && !(deleted = FileIOUtils.deleteFile((String)this.currentFileName))) {
                this.ctx.getLogger().logError("Error deleting file: " + this.currentFileName);
            }
            EventSenders.sendXMLStreamStateEvent(XMLStreamState.ABORTED, this.datagramFactory, this.ctx, this.sendAbortStreamEvent, this.streamStateEventId);
        } else {
            throw new RuntimeException("Unknown XML Stream state:'" + String.valueOf((Object)state) + "'.");
        }
    }

    private void renameResultFile() throws Exception {
        File currentFile = new File(this.currentFileName);
        File resultFile = new File(this.currentFileName.substring(0, this.currentFileName.length() - TEMP_FILE_EXTENSION.length()) + RESULT_FILE_EXTENSION);
        currentFile.renameTo(resultFile);
        this.ctx.logInfo("File '" + String.valueOf(resultFile) + "' has been populated.");
        EventSenders.sendFileProcessedEvent(resultFile, this.datagramFactory, this.ctx, this.fileActionEventId);
        this.currentFileName = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onDataEvent(ImmutableEventDatagram event) throws XMLParseException {
        if (event == null || !(event instanceof XMLEvent)) {
            throw new IllegalStateException("Null or invalid Event Datagram.");
        }
        XMLEvent xmlEvent = (XMLEvent)event;
        String xml = "";
        try {
            xml = xmlEvent.getXML();
        }
        catch (SecurityViolationException exception) {
            throw new XMLParseException(3000, exception.getMessage());
        }
        if (xml == null || xml.equals("")) throw new XMLParseException(3000, "Null or empty xml.");
        try {
            if (this.incomingDataType.equals((Object)FileWriterIncomingType.XML_DOCUMENT)) {
                SimpleDateFormat DATE_FORMAT = new SimpleDateFormat(this.timestampFormat);
                String timestamp = DATE_FORMAT.format(new Date(System.currentTimeMillis()));
                this.currentFileName = this.resultfilePrefix + timestamp + TEMP_FILE_EXTENSION;
                this.writer = new StreamWriter(this.currentFileName);
                this.writer.writeStringToFile(xml);
                this.writer.closeWriter();
                EventSenders.sendXMLStreamStateEvent(XMLStreamState.CLOSED, this.datagramFactory, this.ctx, this.sendCloseStreamEvent, this.streamStateEventId);
                this.renameResultFile();
                return;
            } else {
                if (this.rootElement != null) {
                    this.writer.writeStringToFile("<" + this.rootElement + ">\n");
                }
                this.writer.writeStringToFile(xml + "\n");
                if (this.rootElement == null) return;
                this.writer.writeStringToFile("</" + this.rootElement + ">\n");
            }
            return;
        }
        catch (Exception exception) {
            throw new XMLParseException(3000, "XML processing exception. Cause: " + exception.getMessage());
        }
    }

    public static ServiceConfigurationObject generateSco() throws Exception {
        RuntimeContext.getInstance();
        if (!TypeFactory.existsSemanticType((String)XMLStreamState.class.getSimpleName())) {
            SemanticType type = new SemanticType(XMLStreamState.class.getSimpleName(), XMLStreamState.class.getName());
            TypeFactory.addSemanticType((SemanticType)type);
        }
        SDOUtils.addEventPrototype((String)"XMLEvent", (String)"event.xml");
        ServiceConfigurationObject sco = ServiceConfigurationFactory.createServiceConfiguration((FabricComponent)RuntimeContext.getInstance(), (String)"prototype", (String)"XMLEventSink", (boolean)false);
        sco.setServiceClassName(XMLEventSink.class.getName());
        sco.setServiceDescription("Writes out an XML driven by inbound events.");
        sco.setServiceDisplayName("XML Event Sink");
        sco.setInvokeMode(InvokeMode.ASYNC);
        SemanticType streamStateType = RuntimeContext.getInstance().getSemanticTypeCache().lookupSemanticType("XMLStreamState");
        EventHandler handler = new EventHandler((AbstractServiceConfigurationObject)sco, "onDataEvent", "XmlChunkWritingHandler");
        EventDatagram prototype = EventDatagramFactory.getInstance().createEvent("event.xml");
        handler.bindRequestEvent((ImmutableEventDatagram)prototype);
        handler.bindVoidResponseObject("event.xml.written");
        sco.addEventHandler(handler);
        handler = new EventHandler((AbstractServiceConfigurationObject)sco, "streamStateChange", "StreamStateChangesHandler");
        handler.bindRequestObject("event.stream.state.changed", streamStateType);
        handler.bindVoidResponseObject("event.xml.written");
        sco.addEventHandler(handler);
        ServiceConfigurationProperty prop = sco.createProperty("xml.custom.header", ServicePropertyType.STRING, null);
        prop.setLabel("Custom Main Root Element");
        prop.setDescription("Specifies custom root element of the XML file (if it is different from closing tag).");
        prop.setValue("");
        sco.addProperty(prop);
        prop = sco.createProperty("xml.root", ServicePropertyType.STRING, null);
        prop.setLabel("Main Root Element");
        prop.setDescription("Specifies root element of the XML file (opening and closing).");
        prop.setValue("");
        sco.addProperty(prop);
        prop = sco.createProperty("xml.fragment.name", ServicePropertyType.STRING, null);
        prop.setLabel("Fragment Root Element");
        prop.setDescription("Specifies XML fragment root element.");
        prop.setValue("");
        sco.addProperty(prop);
        prop = sco.createProperty("file.action.eventId", ServicePropertyType.STRING, null);
        prop.setLabel("File Action Event Id");
        prop.setDescription("Specifies Event Id of FileEvent which will be emited once XML file is written.");
        prop.setValue("event.xml.file.written");
        sco.addProperty(prop);
        prop = sco.createProperty("xml.processing.strategy", ServicePropertyType.ENUMERATION, null);
        prop.setLabel("Incoming Data Type");
        prop.setDescription("Specifies incomging data type, wheather it is a whole XML document or just a fragment.");
        prop.setRange(String.valueOf((Object)FileWriterIncomingType.XML_DOCUMENT) + "," + String.valueOf((Object)FileWriterIncomingType.XML_FRAGMENT));
        prop.setValue(FileWriterIncomingType.XML_DOCUMENT.name());
        sco.addProperty(prop);
        prop = sco.createProperty("file.name", ServicePropertyType.STRING, null);
        prop.setLabel("Output File Name");
        prop.setDescription("Specifies name of the XML file to be written.");
        prop.setValue("");
        sco.addProperty(prop);
        prop = sco.createProperty("stream.state.eventId", ServicePropertyType.STRING, null);
        prop.setLabel("Stream State Event Id");
        prop.setDescription("Specifies EventId of the DataEvent with XMLStreamState which is sent on stream state change.");
        prop.setValue("event.xml.stream.state.changed");
        sco.addProperty(prop);
        prop = sco.createProperty("timestamp.format", ServicePropertyType.STRING, null);
        prop.setLabel("Timestamp Format");
        prop.setDescription("Specifies format of the timestamp which will be appended to the result XML file name.");
        prop.setValue("");
        sco.addProperty(prop);
        prop = sco.createProperty("raise.abort.stream.event", ServicePropertyType.BOOLEAN, null);
        prop.setLabel("Raise Abort Stream Event");
        prop.setDescription("Specifies whether XMLStreamState should be sent in case of stream abort.");
        prop.setValue((Object)true);
        sco.addProperty(prop);
        prop = sco.createProperty("raise.open.stream.event", ServicePropertyType.BOOLEAN, null);
        prop.setLabel("Raise Open Stream Event");
        prop.setDescription("Specifies whether XMLStreamState should be sent in case of stream opened.");
        prop.setValue((Object)true);
        sco.addProperty(prop);
        prop = sco.createProperty("raise.close.stream.event", ServicePropertyType.BOOLEAN, null);
        prop.setLabel("Raise Close Stream Event");
        prop.setDescription("Specifies whether XMLStreamState should be sent in case of stream closed.");
        prop.setValue((Object)true);
        sco.addProperty(prop);
        sco.addActionableEvent("event.xml.stream.state.changed");
        sco.addActionableEvent("event.xml.file.written");
        sco.addException("exception.xml.Parsing");
        return sco;
    }
}

