/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.mapper.evSink;

import com.streamscape.Trace;
import com.streamscape.cli.ds.DataspaceType;
import com.streamscape.omf.mapper.SemanticMap;
import com.streamscape.omf.mapper.SemanticMapperException;
import com.streamscape.omf.mapper.SemanticMapperImpl;
import com.streamscape.omf.mapper.parser.LocalSemanticMapperContext;
import com.streamscape.omf.mapper.parser.Parser;
import com.streamscape.omf.mapper.parser.SemanticMapperContext;
import com.streamscape.omf.mapper.parser.Statement;
import com.streamscape.omf.serializer.TextSerializer;
import com.streamscape.repository.object.ReferenceContext;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.obj.SemanticObjectReferenceStore;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationFactory;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationObject;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.excp.ServiceFrameworkException;
import com.streamscape.sdo.excp.ValidationException;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.service.AbstractService;
import com.streamscape.sef.service.SuspectState;
import com.streamscape.service.mapper.evSink.DataFormat;
import com.streamscape.service.mapper.evSink.Version;
import com.streamscape.service.osf.config.AbstractServiceConfigurationObject;
import com.streamscape.service.osf.config.ObjectPropertyValue;
import com.streamscape.service.osf.config.ServiceConfigurationProperty;
import com.streamscape.service.osf.config.ServicePropertyType;
import com.streamscape.service.osf.enums.InvokeMode;
import com.streamscape.service.osf.evh.EventHandler;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class SemanticMapperService
extends AbstractService {
    private static final String CURRENT_EVENT = "CurrentEvent";
    private static final String CURRENT_OBJECT = "CurrentObject";
    private SemanticMap map;
    private SemanticMapperImpl mapper;
    boolean enableCustomization = false;
    ObjectMeta targetObject = null;
    List<ObjectMeta> sourceObjects = new ArrayList<ObjectMeta>();

    public int getMajorVersion() {
        return Version.getMajorVersion();
    }

    public int getMinorVersion() {
        return Version.getMinorVersion();
    }

    public int getMinorBuild() {
        return Version.getBuild();
    }

    public String getVersion() {
        return Version.getVersionString();
    }

    protected void doInit() throws ServiceFrameworkException {
        try {
            this.enableCustomization = this.ctx.lookupBooleanProperty("enable.customization");
            this.targetObject = this.initObjectMeta("target", this.ctx.lookupTableProperty("target.object"));
            List sources = this.ctx.lookupListProperty("source.objects");
            for (ServiceConfigurationProperty object : sources) {
                ObjectMeta meta = this.initObjectMeta("source", (Hashtable)object.getValue());
                this.sourceObjects.add(meta);
            }
            boolean validateSource = false;
            if (this.enableCustomization && this.ctx.existsProperty("source.validation")) {
                validateSource = this.ctx.lookupBooleanProperty("source.validation");
                this.ctx.logInfo("Validate source : " + validateSource);
            }
            boolean validateTarget = false;
            if (this.enableCustomization && this.ctx.existsProperty("target.validation")) {
                validateTarget = this.ctx.lookupBooleanProperty("target.validation");
                this.ctx.logInfo("Validate target : " + validateTarget);
            }
            String defaultDataspace = null;
            if (this.enableCustomization && this.ctx.existsProperty("default.dataspace")) {
                defaultDataspace = this.ctx.lookupStringProperty("default.dataspace");
            }
            ObjectPropertyValue semTableObject = this.ctx.lookupObjectProperty("semantic.map");
            SemanticObjectReferenceStore.beginXact((FabricComponent)this.ctx);
            this.map = (SemanticMap)SemanticObjectReferenceStore.loadObject((ObjectPropertyValue)semTableObject);
            SemanticObjectReferenceStore.commitXact();
            this.ctx.logInfo("Semantic map version: " + this.map.getVersion() + ", successfully loaded.");
            LocalSemanticMapperContext semanticMapperContext = new LocalSemanticMapperContext(this.ctx.getPackageManifestManager().getManifestClassLoader(), (FabricComponent)this.ctx);
            this.mapper = new SemanticMapperImpl((SemanticMapperContext)semanticMapperContext);
            if (this.enableCustomization) {
                this.map.setValidateSource(validateSource);
                this.map.setValidateTarget(validateTarget);
                if (defaultDataspace != null) {
                    this.map.setDefaultDataspace(defaultDataspace);
                }
            }
            this.mapper.setSemanticMap(this.map);
            this.mapper.init();
        }
        catch (Exception exception) {
            this.ctx.setSuspectState(SuspectState.SuspectStateOriginator.service(), exception.getMessage());
            Trace.logException((Object)((Object)this), (Throwable)exception, (boolean)true);
        }
    }

    private ObjectMeta initObjectMeta(String objectType, Hashtable<String, ServiceConfigurationProperty> config) {
        ObjectMeta meta = new ObjectMeta();
        meta.alias = (String)config.get("alias").getValue();
        this.ctx.logInfo("Loading " + objectType + " object " + meta.alias + " configuration.");
        if (config.containsKey("expression")) {
            meta.expression = (String)config.get("expression").getValue();
            this.ctx.logDebug("Expression : " + meta.expression);
        }
        meta.dataFormat = DataFormat.valueOf((String)config.get("data.format").getValue());
        this.ctx.logInfo("Data Format : " + String.valueOf((Object)meta.dataFormat));
        if (meta.dataFormat != DataFormat.DATA_OBJECT) {
            if ((meta.dataFormat == DataFormat.XML_ARRAY || meta.dataFormat == DataFormat.JSON_ARRAY) && config.containsKey("encoding")) {
                meta.encoding = (String)config.get("encoding").getValue();
                this.ctx.logDebug("Encoding : " + meta.encoding);
            }
            String datePattern = null;
            if (config.containsKey("date.pattern")) {
                datePattern = (String)config.get("date.pattern").getValue();
                this.ctx.logDebug("Date Pattern : " + datePattern);
            }
            switch (meta.dataFormat) {
                case XML_DOCUMENT: 
                case XML_ARRAY: {
                    meta.serializer = RuntimeContext.getInstance().getXSerializer();
                    if (datePattern == null) break;
                    break;
                }
                case JSON_DOCUMENT: 
                case JSON_ARRAY: {
                    meta.serializer = RuntimeContext.getInstance().getJSONSerializer();
                    if (datePattern == null) break;
                }
            }
        }
        return meta;
    }

    public Object map(Object inbound) throws SemanticMapperException, ValidationException {
        this.ctx.logDebug("Inbound request for mapping...");
        this.prepareSourceObjects(inbound);
        Object result = this.prepareTargetObject(this.mapper.convert());
        this.ctx.logDebug("Mapping completed.");
        return result;
    }

    private void prepareSourceObjects(Object inbound) throws ValidationException, SemanticMapperException {
        this.ctx.logDebug("Preparing inbound objects...");
        this.mapper.resetSourceObjects();
        Parser parser = new Parser();
        LocalSemanticMapperContext mapperContext = new LocalSemanticMapperContext(this.ctx.getPackageManifestManager().getManifestClassLoader(), (FabricComponent)this.ctx);
        mapperContext.initDataspaceAccessor(this.map.getDefaultDataspace());
        if (inbound instanceof ImmutableEventDatagram) {
            mapperContext.setMacroProcessorEvent((ImmutableEventDatagram)inbound);
        }
        if (ImmutableEventDatagram.class.isAssignableFrom(inbound.getClass())) {
            mapperContext.addMappingObject(CURRENT_EVENT, inbound);
        } else {
            mapperContext.addMappingObject(CURRENT_OBJECT, inbound);
        }
        for (ObjectMeta meta : this.sourceObjects) {
            Statement stat = parser.parse((SemanticMapperContext)mapperContext, meta.expression);
            stat.execute((SemanticMapperContext)mapperContext);
            Object obj = mapperContext.getMappingObject(meta.alias);
            if (obj != null) {
                obj = this.prepareSourceObject(meta, obj);
                this.mapper.setSourceObject(meta.alias, obj);
                continue;
            }
            throw new SemanticMapperException(3013, "Unable to resolve '" + meta.alias + "' source object.");
        }
        mapperContext.destroy();
        this.ctx.logDebug("Objects initialized.");
    }

    private Object prepareSourceObject(ObjectMeta meta, Object result) throws SemanticMapperException {
        if (meta.dataFormat != DataFormat.DATA_OBJECT) {
            if (result instanceof byte[]) {
                if (meta.encoding != null) {
                    try {
                        result = new String((byte[])result, meta.encoding);
                    }
                    catch (Exception error) {
                        throw new SemanticMapperException(3015, "Unable to decode source object using specified encoding '" + meta.encoding + "'. " + error.getMessage());
                    }
                } else {
                    result = new String((byte[])result);
                }
            }
            if (result instanceof String) {
                try {
                    result = meta.serializer.deserialize((String)result);
                }
                catch (Exception error) {
                    throw new SemanticMapperException(3015, "Unable to deserialize source object. " + error.getMessage());
                }
            } else {
                throw new IllegalArgumentException("Unknown source object received. Expected either string or byte[].");
            }
        }
        return result;
    }

    private Object prepareTargetObject(Object outbound) throws SemanticMapperException {
        if (this.targetObject.dataFormat != DataFormat.DATA_OBJECT) {
            String text = null;
            try {
                text = this.targetObject.serializer.serialize(outbound);
            }
            catch (Exception error) {
                throw new SemanticMapperException(3014, "Unable to serializer target object. " + error.getMessage());
            }
            if (this.targetObject.dataFormat == DataFormat.XML_DOCUMENT || this.targetObject.dataFormat == DataFormat.JSON_DOCUMENT) {
                outbound = text;
            } else if (this.targetObject.encoding != null) {
                try {
                    outbound = text.getBytes(this.targetObject.encoding);
                }
                catch (Exception error) {
                    throw new SemanticMapperException(3015, "Unable to encode target object using specified encoding '" + this.targetObject.encoding + "'. " + error.getMessage());
                }
            } else {
                outbound = text.getBytes();
            }
        }
        return outbound;
    }

    public static ServiceConfigurationObject generateSco() throws Exception {
        RuntimeContext.getInstance();
        ServiceConfigurationObject sco = ServiceConfigurationFactory.createServiceConfiguration((FabricComponent)RuntimeContext.getInstance(), (String)"prototype", (String)"SemanticMapper", (boolean)false);
        sco.setServiceClassName(SemanticMapperService.class.getName());
        sco.setServiceDescription("Performs mapping from one object format to another.");
        sco.setServiceDisplayName("Semantic Mapper");
        sco.setInvokeMode(InvokeMode.ASYNC);
        ReferenceContext ref = new ReferenceContext(new ReferenceContext(null, null), "/mapper");
        SemanticType objectSemType = RuntimeContext.getInstance().getSemanticTypeCache().lookupSemanticType("object");
        EventHandler handler = new EventHandler((AbstractServiceConfigurationObject)sco, "map", "MappingHandler");
        handler.bindRequestObject("event.source", objectSemType);
        handler.bindResponseObject("event.target", objectSemType);
        sco.addEventHandler(handler);
        ServiceConfigurationProperty prop = sco.createProperty("enable.customization", ServicePropertyType.BOOLEAN, null);
        prop.setLabel("Enable Customization");
        prop.setDescription("Specifies whether some semantic map fields should be overwritten (e.g. validation or default dataspace).");
        prop.setValue((Object)false);
        sco.addProperty(prop);
        prop = sco.createProperty("source.validation", ServicePropertyType.BOOLEAN, null);
        prop.setLabel("Source Validation");
        prop.setDescription("Specifies whether source object should be validated.");
        prop.setValue((Object)false);
        sco.addProperty(prop);
        prop = sco.createProperty("target.validation", ServicePropertyType.BOOLEAN, null);
        prop.setLabel("Target Validation");
        prop.setDescription("Specifies whether target object should be validated.");
        prop.setValue((Object)false);
        sco.addProperty(prop);
        prop = sco.createProperty("default.dataspace", ServicePropertyType.STRING, null);
        prop.setLabel("Default Dataspace");
        prop.setDescription("Specifies default dataspace.");
        prop.setValue(String.valueOf(DataspaceType.TSPACE) + ".SDS");
        sco.addProperty(prop);
        prop = SemanticMapperService.getObjectConfiguration("TargetObject", "target.object", true, sco);
        prop.setLabel("Target Object");
        prop.setDescription("Desribes target object configuration.");
        sco.addProperty(prop);
        prop = sco.createProperty("source.objects", ServicePropertyType.LIST, null);
        prop.setLabel("Source Objects");
        prop.setDescription("Contains source object configurations.");
        ArrayList<ServiceConfigurationProperty> sources = new ArrayList<ServiceConfigurationProperty>();
        ServiceConfigurationProperty source = SemanticMapperService.getObjectConfiguration("SourceObject", "source.object", false, sco);
        prop.setLabel("Source Object");
        prop.setDescription("Desribes source object configuration.");
        sources.add(source);
        prop.setValue(sources);
        sco.addProperty(prop);
        prop = sco.createProperty("semantic.map", ServicePropertyType.OBJECT, null);
        prop.setLabel("Semantic Table");
        prop.setDescription("Specifies semantic table object which contains mapping rules.");
        prop.setValue((Object)new ObjectPropertyValue("mappingTable", "SemanticMap", ref));
        sco.addProperty(prop);
        sco.addException("exception.omf.SemanticMapper");
        return sco;
    }

    private static ServiceConfigurationProperty getObjectConfiguration(String objectType, String propName, boolean target, ServiceConfigurationObject sco) throws Exception {
        ServiceConfigurationProperty configuration = sco.createProperty(propName, ServicePropertyType.TABLE, null);
        Hashtable configValue = (Hashtable)configuration.getValue();
        ServiceConfigurationProperty prop = sco.createProperty("alias", ServicePropertyType.STRING, null);
        prop.setLabel("Object Alias");
        prop.setDescription("Specifies alias for this object which is used for mapping.");
        prop.setValue(objectType);
        configValue.put(prop.getName(), prop);
        if (!target) {
            prop = sco.createProperty("expression", ServicePropertyType.STRING, null);
            prop.setLabel("Object Evaluation Expression");
            prop.setDescription("Specifies expression for object evaluation.");
            prop.setValue("%SourceObject = %CurrentObject");
            configValue.put(prop.getName(), prop);
        }
        prop = sco.createProperty("data.format", ServicePropertyType.ENUMERATION, null);
        prop.setLabel("Data Format");
        prop.setDescription("Specifies object format.");
        prop.setRange(String.valueOf((Object)DataFormat.DATA_OBJECT) + "," + String.valueOf((Object)DataFormat.XML_DOCUMENT) + "," + String.valueOf((Object)DataFormat.JSON_DOCUMENT) + "," + String.valueOf((Object)DataFormat.XML_ARRAY) + "," + String.valueOf((Object)DataFormat.JSON_ARRAY));
        prop.setValue(DataFormat.DATA_OBJECT.name());
        configValue.put(prop.getName(), prop);
        prop = sco.createProperty("encoding", ServicePropertyType.STRING, null);
        prop.setLabel("Encoding");
        prop.setDescription("Specifies encoding for XML or JSON array data format.");
        prop.setValue("utf-8");
        configValue.put(prop.getName(), prop);
        prop = sco.createProperty("date.pattern", ServicePropertyType.STRING, null);
        prop.setLabel("Date Pattern");
        prop.setDescription("Specifies pattern which should be used for date decoding from the source document.");
        prop.setValue("yyyy/MM/dd hh:mm:ss aaa");
        configValue.put(prop.getName(), prop);
        return configuration;
    }

    public void destroy() throws ServiceFrameworkException {
        if (this.mapper != null) {
            this.mapper.destroy();
            this.mapper = null;
        }
        super.destroy();
    }

    public static class ObjectMeta {
        String alias;
        String expression;
        DataFormat dataFormat;
        String encoding;
        TextSerializer serializer;
    }
}

