/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.mail.reader;

import com.streamscape.lib.utils.Utils;
import com.streamscape.sef.service.ServiceContext;
import com.streamscape.service.mail.reader.MailReaderUtils;
import com.streamscape.service.mail.reader.ProcessedMessage;
import com.sun.mail.iap.Argument;
import com.sun.mail.iap.ProtocolException;
import com.sun.mail.iap.Response;
import com.sun.mail.imap.IMAPFolder;
import com.sun.mail.imap.protocol.BODY;
import com.sun.mail.imap.protocol.FetchResponse;
import com.sun.mail.imap.protocol.IMAPProtocol;
import com.sun.mail.imap.protocol.INTERNALDATE;
import com.sun.mail.imap.protocol.UID;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Properties;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;

public class FullFetchByUIDCommand
implements IMAPFolder.ProtocolCommand {
    private ServiceContext ctx;
    private long startUID;
    private long endUID;
    private HashMap<Integer, ProcessedMessage> messages = new HashMap();

    public FullFetchByUIDCommand(ServiceContext ctx, long startUID, long endUID) {
        this.ctx = ctx;
        this.startUID = startUID;
        this.endUID = endUID;
    }

    public Object doCommand(IMAPProtocol protocol) throws ProtocolException {
        Argument args = new Argument();
        args.writeString(Long.toString(this.startUID) + ":" + Long.toString(this.endUID));
        args.writeString("BODY[] INTERNALDATE");
        Response[] resp = protocol.command("UID FETCH", args);
        Response response = resp[resp.length - 1];
        if (response.isOK()) {
            Properties props = new Properties();
            props.setProperty("mail.store.protocol", "imaps");
            props.setProperty("mail.mime.base64.ignoreerrors", "true");
            props.setProperty("mail.imap.partialfetch", "false");
            props.setProperty("mail.imaps.partialfetch", "false");
            Session session = Session.getInstance((Properties)props, null);
            ByteArrayInputStream is = null;
            for (int i = 0; i < resp.length - 1; ++i) {
                if (!(resp[i] instanceof FetchResponse)) continue;
                try {
                    FetchResponse fetch = (FetchResponse)resp[i];
                    BODY body = (BODY)fetch.getItem(BODY.class);
                    UID uid = (UID)fetch.getItem(UID.class);
                    INTERNALDATE intDate = (INTERNALDATE)fetch.getItem(INTERNALDATE.class);
                    is = body.getByteArrayInputStream();
                    MimeMessage mm = new MimeMessage(session, (InputStream)is);
                    ProcessedMessage prMsg = MailReaderUtils.parseMessage(this.ctx, (Message)mm, uid.uid);
                    prMsg.mailDescriptor.receivedDate = intDate.getDate();
                    this.messages.put(uid.seqnum, prMsg);
                    continue;
                }
                catch (Exception e) {
                    this.ctx.logError("FullFetchByUIDCommand error: " + Utils.formatException((Throwable)e, (String)"\n"));
                }
            }
        }
        protocol.notifyResponseHandlers(resp);
        protocol.handleResult(response);
        return "" + (resp.length - 1);
    }

    public HashMap<Integer, ProcessedMessage> getMessagesMap() {
        return this.messages;
    }
}

