/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.file.evSink;

import com.streamscape.Trace;
import com.streamscape.lib.file.DefaultFSCustomSerializer;
import com.streamscape.lib.file.FSCustomSerializer;
import com.streamscape.lib.reflection.ReflectionProvider;
import com.streamscape.omf.serializer.SerializerException;
import com.streamscape.omf.serializer.TextSerializer;
import com.streamscape.omf.xml.XSerializer;
import com.streamscape.omf.xml.XSerializerFactory;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationFactory;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationObject;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.SDOException;
import com.streamscape.sdo.SecurityViolationException;
import com.streamscape.sdo.enums.FileState;
import com.streamscape.sdo.event.AcknowledgementEvent;
import com.streamscape.sdo.event.AuditEvent;
import com.streamscape.sdo.event.BytesEvent;
import com.streamscape.sdo.event.DataEvent;
import com.streamscape.sdo.event.DeltaEvent;
import com.streamscape.sdo.event.ExceptionEvent;
import com.streamscape.sdo.event.FileEvent;
import com.streamscape.sdo.event.MapEvent;
import com.streamscape.sdo.event.OpaqueEvent;
import com.streamscape.sdo.event.RowArrayEvent;
import com.streamscape.sdo.event.RowChangeEvent;
import com.streamscape.sdo.event.RowEvent;
import com.streamscape.sdo.event.RowSetEvent;
import com.streamscape.sdo.event.StreamStateEvent;
import com.streamscape.sdo.event.TextEvent;
import com.streamscape.sdo.event.XMLEvent;
import com.streamscape.sdo.event.XMPPEvent;
import com.streamscape.sdo.excp.ServiceFrameworkException;
import com.streamscape.sdo.rowset.Row;
import com.streamscape.sdo.rowset.RowArray;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sdo.rowset.RowSetPrinter;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.service.AbstractCancellableService;
import com.streamscape.service.file.evSink.AppendMode;
import com.streamscape.service.file.evSink.OutputFormat;
import com.streamscape.service.file.evSink.Version;
import com.streamscape.service.osf.config.AbstractServiceConfigurationObject;
import com.streamscape.service.osf.config.ServiceConfigurationException;
import com.streamscape.service.osf.config.ServiceConfigurationProperty;
import com.streamscape.service.osf.config.ServicePropertyType;
import com.streamscape.service.osf.enums.InvokeMode;
import com.streamscape.service.osf.evh.EventHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.HashMap;
import java.util.Set;

public class FileWriter
extends AbstractCancellableService {
    private AppendMode appendMode = AppendMode.APPEND;
    private OutputFormat outputFormat = OutputFormat.SPECIFIC;
    private boolean eventPayload = false;
    private String charset = "";
    private String customSerializerName = "";
    private FSCustomSerializer customSerializer = null;
    private TextSerializer serializer = null;
    private static final String beforeHeader = "===================   BEFORE   ====================";
    private static final String afterHeader = "===================   AFTER    ====================";
    private static final String lineSepar = System.getProperty("line.separator");
    private static final byte[] doubleLineSeparBytes = (lineSepar + lineSepar).getBytes();

    protected void doInit() throws ServiceFrameworkException {
        try {
            if (this.ctx.existsProperty("append.mode")) {
                this.appendMode = AppendMode.valueOf(this.ctx.lookupEnumProperty("append.mode"));
                this.ctx.logInfo("Append mode parameter is set to : " + String.valueOf((Object)this.appendMode));
            } else {
                this.appendMode = AppendMode.APPEND;
                this.ctx.logInfo("Output Format property not found. Set to APPEND.");
            }
            if (this.ctx.existsProperty("output.format")) {
                this.outputFormat = OutputFormat.valueOf(this.ctx.lookupEnumProperty("output.format"));
                this.ctx.logInfo("Output Format parameter is set to : " + String.valueOf((Object)this.outputFormat));
            } else {
                this.outputFormat = OutputFormat.JSON;
                this.ctx.logInfo("Output Format property not found. Set to JSON.");
            }
            if (this.ctx.existsProperty("event.payload")) {
                this.eventPayload = this.ctx.lookupBooleanProperty("event.payload");
                this.ctx.logInfo("Event Payload parameter is set to : " + this.eventPayload);
            } else {
                this.eventPayload = false;
                this.ctx.logInfo("Event Payload property not found. Set to false");
            }
            if (this.outputFormat == OutputFormat.SPECIFIC) {
                if (this.ctx.existsProperty("custom.serializer")) {
                    this.customSerializerName = this.ctx.lookupStringProperty("custom.serializer");
                    this.ctx.logInfo("Custom Serilizer parameter is set to : " + this.customSerializerName);
                } else {
                    this.ctx.logInfo("Custom Serilizer property not found. Set to default.");
                }
            }
            if (this.ctx.existsProperty("charset")) {
                this.charset = this.ctx.lookupStringProperty("charset");
                this.ctx.logInfo("Charset parameter is set to : " + this.charset);
            } else {
                this.charset = "";
                this.ctx.logInfo("Charset property not found. Set to default.");
            }
            switch (this.outputFormat) {
                case XML: {
                    XSerializerFactory factory = this.context.getXSerializerFactory();
                    XSerializer xSerializer = factory.createSerializer("FileWriterSerializer");
                    xSerializer.mapAttribute("SemanticType", "class");
                    this.serializer = xSerializer;
                    break;
                }
                case JSON: {
                    this.serializer = this.context.getJSONSerializerFactory().getDefaultSerializer().withPrettyPrint(true);
                }
            }
        }
        catch (ServiceConfigurationException error) {
            this.ctx.logError("Unable to initialize service. " + error.getMessage());
            throw new ServiceFrameworkException(6065, error.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FileEvent writeToFile(Object object) throws ServiceFrameworkException {
        File fileObject = null;
        RandomAccessFile file = null;
        FileLock fileLock = null;
        FileState fileStatus = null;
        try {
            String fileName;
            if (this.outputFormat == OutputFormat.SPECIFIC) {
                if (this.customSerializer == null) {
                    this.customSerializer = this.customSerializerName.isEmpty() || this.customSerializerName.equalsIgnoreCase("default") ? new DefaultFSCustomSerializer() : (FSCustomSerializer)ReflectionProvider.getInstance().newInstance(this.context.getSystemClassLoaderChain().loadClass(this.customSerializerName));
                }
                this.ctx.logDebug("Custom Serializer: " + this.customSerializer.getClass().getCanonicalName());
            }
            if ((fileObject = new File(fileName = this.ctx.lookupStringProperty("file.name"))).exists()) {
                if (this.appendMode == AppendMode.NEW) {
                    throw new IOException("File '" + fileObject.getAbsolutePath() + "' already exist. Can't create.");
                }
                fileStatus = FileState.MODIFIED;
            } else {
                this.ctx.logDebug("File '" + fileObject.getAbsolutePath() + "' does not exist. Will be created.");
                fileStatus = FileState.CREATED;
            }
            file = new RandomAccessFile(fileObject, "rw");
            FileChannel fileChannel = file.getChannel();
            fileLock = fileChannel.lock();
            this.ctx.logDebug("File '" + fileObject.getAbsolutePath() + "' opened for writing.");
            if (file.length() > 0L) {
                if (this.appendMode == AppendMode.REPLACE) {
                    file.setLength(0L);
                    this.ctx.logDebug("File '" + fileObject.getAbsolutePath() + "' truncated.");
                } else {
                    file.seek(file.length());
                }
            }
            if (this.eventPayload) {
                if (!(object instanceof ImmutableEventDatagram)) throw new ServiceFrameworkException(6108, "Incomming object is not Event, but Event Payload property is true.");
                this.writeEventPayload((ImmutableEventDatagram)object, file);
            } else {
                byte[] data = this.getWriteData(object);
                if (data != null) {
                    file.write(data);
                    file.getFD().sync();
                }
            }
        }
        catch (Exception error) {
            this.ctx.logError("Unable to write incoming content into the file. " + error.getMessage());
            Trace.logException((Object)((Object)this), (Throwable)error, (boolean)true);
            throw new ServiceFrameworkException(6108, error.getMessage());
        }
        finally {
            try {
                if (fileLock != null) {
                    fileLock.release();
                }
                if (file != null) {
                    file.close();
                }
            }
            catch (Exception error) {
                this.ctx.logError("Unable to release the file. " + error.getMessage());
                Trace.logException((Object)((Object)this), (Throwable)error, (boolean)true);
                throw new ServiceFrameworkException(6108, error.getMessage());
            }
        }
        try {
            this.ctx.logInfo("Incoming data succesfully written to '" + fileObject.getAbsolutePath() + "' file.");
            FileEvent resultFileEvent = (FileEvent)this.ctx.createResponseEvent("writeToFile");
            resultFileEvent.init(fileObject, fileStatus);
            return resultFileEvent;
        }
        catch (Exception error) {
            this.ctx.logError("Unable to create result FileEvent. " + error.getMessage());
            Trace.logException((Object)((Object)this), (Throwable)error, (boolean)true);
            throw new ServiceFrameworkException(6108, error.getMessage());
        }
    }

    private void writeEventPayload(ImmutableEventDatagram event, RandomAccessFile file) throws ServiceFrameworkException, IOException, SerializerException, SecurityViolationException, SDOException {
        if (event instanceof AcknowledgementEvent) {
            this.writeEventData(((AcknowledgementEvent)event).getData(), file);
        } else if (event instanceof AuditEvent) {
            this.writeEventData(((AuditEvent)event).getAuditData(), file);
        } else if (event instanceof BytesEvent) {
            this.writeEventBytes(((BytesEvent)event).getBytes(), file);
        } else if (event instanceof DataEvent) {
            this.writeEventData(((DataEvent)event).getData(), file);
        } else if (event instanceof DeltaEvent) {
            this.writeDeltaEvent((DeltaEvent)event, file);
        } else if (event instanceof ExceptionEvent) {
            this.writeEventData(((ExceptionEvent)event).getErrorMessage(), file);
        } else if (event instanceof FileEvent) {
            this.writeEventBytes(((FileEvent)event).getFileData(), file);
        } else if (event instanceof MapEvent) {
            this.writeMapEvent((MapEvent)event, file);
        } else if (event instanceof OpaqueEvent) {
            this.writeEventData(((OpaqueEvent)event).getData(), file);
        } else if (event instanceof StreamStateEvent) {
            this.writeEventData(((StreamStateEvent)event).getStateMessage(), file);
        } else if (event instanceof TextEvent) {
            this.writeEventData(((TextEvent)event).getText(), file);
        } else if (event instanceof XMLEvent) {
            this.writeXMLEvent((XMLEvent)event, file);
        } else if (event instanceof XMPPEvent) {
            this.writeEventData(((XMPPEvent)event).getData(), file);
        } else if (event instanceof RowEvent) {
            this.writeRowEvent((RowEvent)event, file);
        } else if (event instanceof RowArrayEvent) {
            this.writeRowArrayEvent((RowArrayEvent)event, file);
        } else if (event instanceof RowChangeEvent) {
            this.writeRowChangeEvent((RowChangeEvent)event, file);
        } else if (event instanceof RowSetEvent) {
            this.writeRowSetEvent((RowSetEvent)event, file);
        } else {
            throw new ServiceFrameworkException(6108, "Unknown event type. Unable to write it payload.");
        }
    }

    private void writeEventData(Object eventData, RandomAccessFile file) throws SerializerException, IOException, ServiceFrameworkException {
        byte[] data = this.getWriteData(eventData);
        file.write(data);
        file.getFD().sync();
    }

    private void writeEventBytes(byte[] bytes, RandomAccessFile file) throws SerializerException, IOException {
        byte[] data = this.getWriteData(bytes);
        file.write(data);
        file.getFD().sync();
    }

    private void writeDeltaEvent(DeltaEvent event, RandomAccessFile file) throws IOException, SecurityViolationException, SDOException, SerializerException, ServiceFrameworkException {
        Object afterData;
        Object beforeData = event.getBeforeImage();
        if (beforeData != null) {
            file.write((beforeHeader + lineSepar).getBytes());
            this.writeEventData(beforeData, file);
        }
        if ((afterData = event.getAfterImage()) != null) {
            file.write((afterHeader + lineSepar).getBytes());
            this.writeEventData(afterData, file);
        }
        if (beforeData != null || afterData != null) {
            file.write(lineSepar.getBytes());
            file.getFD().sync();
        }
    }

    private void writeMapEvent(MapEvent event, RandomAccessFile file) throws IOException, SerializerException, SecurityViolationException, SDOException, ServiceFrameworkException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Set keys = event.getMapNames();
        for (String key : keys) {
            map.put(key, event.getObject(key));
        }
        this.writeEventData(map, file);
    }

    private void writeXMLEvent(XMLEvent event, RandomAccessFile file) throws IOException, SecurityViolationException {
        if (this.isDefaultCharset()) {
            file.write((event.getXML() + lineSepar + lineSepar).getBytes());
        } else {
            file.write((event.getXML() + lineSepar + lineSepar).getBytes(this.charset));
        }
        file.getFD().sync();
    }

    private void writeRowEvent(RowEvent event, RandomAccessFile file) throws IOException, SerializerException, SecurityViolationException, ServiceFrameworkException {
        Row row = event.getRow();
        if (row != null) {
            if (this.outputFormat == OutputFormat.SPECIFIC) {
                RowSetPrinter printer = new RowSetPrinter();
                printer.setPrintStream(this.getPrintStream(file));
                printer.print(row);
                file.write(lineSepar.getBytes());
                file.getFD().sync();
            } else {
                this.writeEventData(row, file);
            }
        }
    }

    private void writeRowSetEvent(RowSetEvent event, RandomAccessFile file) throws IOException, SerializerException, SecurityViolationException, ServiceFrameworkException {
        RowSet rowSet = event.getRowSet();
        if (rowSet != null) {
            if (this.outputFormat == OutputFormat.SPECIFIC) {
                RowSetPrinter printer = new RowSetPrinter();
                printer.setPrintStream(this.getPrintStream(file));
                printer.print(rowSet);
                file.write(lineSepar.getBytes());
                file.getFD().sync();
            } else {
                this.writeEventData(rowSet, file);
            }
        }
    }

    private void writeRowChangeEvent(RowChangeEvent event, RandomAccessFile file) throws IOException, SerializerException, SecurityViolationException, ServiceFrameworkException {
        Row rowAfter;
        PrintStream printStream = this.getPrintStream(file);
        Row rowBefore = event.getBeforeImage();
        if (rowBefore != null) {
            if (this.outputFormat == OutputFormat.SPECIFIC) {
                printStream.println(beforeHeader);
                RowSetPrinter printer = new RowSetPrinter();
                printer.setPrintStream(printStream);
                printer.print(rowBefore);
            } else {
                file.write((beforeHeader + lineSepar).getBytes());
                this.writeEventData(rowBefore, file);
            }
        }
        if ((rowAfter = event.getAfterImage()) != null) {
            if (this.outputFormat == OutputFormat.SPECIFIC) {
                printStream.println(afterHeader);
                RowSetPrinter printer = new RowSetPrinter();
                printer.setPrintStream(printStream);
                printer.print(rowAfter);
            } else {
                file.write((afterHeader + lineSepar).getBytes());
                this.writeEventData(rowAfter, file);
            }
        }
        if (rowBefore != null || rowAfter != null) {
            file.write(lineSepar.getBytes());
            file.getFD().sync();
        }
    }

    private void writeRowArrayEvent(RowArrayEvent event, RandomAccessFile file) throws IOException, SerializerException, SecurityViolationException, ServiceFrameworkException {
        RowArray rowArray = event.getRowArray();
        if (rowArray != null) {
            if (this.outputFormat == OutputFormat.SPECIFIC) {
                RowSetPrinter printer = new RowSetPrinter();
                printer.setPrintStream(this.getPrintStream(file));
                printer.print(rowArray);
                file.write(lineSepar.getBytes());
                file.getFD().sync();
            } else {
                this.writeEventData(rowArray, file);
            }
        }
    }

    private byte[] getWriteData(byte[] bytes) throws SerializerException {
        byte[] data = null;
        switch (this.outputFormat) {
            case XML: {
                data = this.addLineSeparator(this.serializer.serialize((Object)bytes).getBytes());
                break;
            }
            case JSON: {
                data = this.serializer.serialize((Object)bytes).getBytes();
                break;
            }
            case SPECIFIC: {
                data = this.addLineSeparator(bytes);
            }
        }
        return data;
    }

    private byte[] getWriteData(Object object) throws SerializerException, ServiceFrameworkException {
        byte[] data = null;
        switch (this.outputFormat) {
            case XML: {
                data = this.addLineSeparator(this.serializer.serialize(object).getBytes());
                break;
            }
            case JSON: {
                data = this.serializer.serialize(object).getBytes();
                break;
            }
            case SPECIFIC: {
                data = this.customSerializer.toByteArray(object);
            }
        }
        return data;
    }

    private PrintStream getPrintStream(RandomAccessFile file) throws IOException {
        PrintStream printStream = null;
        printStream = this.isDefaultCharset() ? new PrintStream(new FileOutputStream(file.getFD())) : new PrintStream((OutputStream)new FileOutputStream(file.getFD()), false, this.charset);
        return printStream;
    }

    private boolean isDefaultCharset() {
        return this.charset == null || this.charset.isEmpty() || this.charset.equalsIgnoreCase("default");
    }

    private byte[] addLineSeparator(byte[] array) {
        byte[] resultArr = new byte[array.length + doubleLineSeparBytes.length];
        System.arraycopy(array, 0, resultArr, 0, array.length);
        System.arraycopy(doubleLineSeparBytes, 0, resultArr, array.length, doubleLineSeparBytes.length);
        return resultArr;
    }

    public int getMinorBuild() {
        return Version.getBuild();
    }

    public int getMajorVersion() {
        return Version.getMajorVersion();
    }

    public int getMinorVersion() {
        return Version.getMinorVersion();
    }

    public String getVersion() {
        return Version.getVersionString();
    }

    public static ServiceConfigurationObject generateSco() throws Exception {
        RuntimeContext.getInstance();
        ServiceConfigurationObject sco = ServiceConfigurationFactory.createServiceConfiguration((FabricComponent)RuntimeContext.getInstance(), (String)"prototype", (String)"FileWriter", (boolean)false);
        sco.setServiceClassName(FileWriter.class.getName());
        sco.setServiceDescription("Creates a file from inbound event(s).");
        sco.setServiceDisplayName("File Writer");
        sco.setInvokeMode(InvokeMode.ASYNC);
        SemanticType eventSemType = RuntimeContext.getInstance().getSemanticTypeCache().lookupSemanticType("event");
        EventHandler handler = new EventHandler((AbstractServiceConfigurationObject)sco, "writeToFile", "FileWritingHandler");
        handler.bindRequestObject("event.to.write", eventSemType);
        handler.bindResponseObject("event.file.written", eventSemType);
        sco.addEventHandler(handler);
        ServiceConfigurationProperty prop = sco.createProperty("event.payload", ServicePropertyType.BOOLEAN, null);
        prop.setLabel("Event Payload Only");
        prop.setDescription("Specifies whether an event payload should be writen.");
        prop.setValue((Object)false);
        sco.addProperty(prop);
        prop = sco.createProperty("charset", ServicePropertyType.STRING, null);
        prop.setLabel("Charset");
        prop.setDescription("Charset.");
        prop.setValue("");
        sco.addProperty(prop);
        prop = sco.createProperty("custom.serializer", ServicePropertyType.STRING, null);
        prop.setLabel("Custom Serializer");
        prop.setDescription("Custom Serializer.");
        prop.setValue("");
        sco.addProperty(prop);
        prop = sco.createProperty("append.mode", ServicePropertyType.ENUMERATION, null);
        prop.setLabel("Append Mode");
        prop.setDescription("Specifies the file append mode.");
        prop.setRange(String.valueOf((Object)AppendMode.APPEND) + "," + String.valueOf((Object)AppendMode.NEW) + "," + String.valueOf((Object)AppendMode.REPLACE));
        prop.setValue(AppendMode.NEW.name());
        sco.addProperty(prop);
        prop = sco.createProperty("output.format", ServicePropertyType.ENUMERATION, null);
        prop.setLabel("Output Format");
        prop.setDescription("Specifies the file output format. ");
        prop.setRange(String.valueOf((Object)OutputFormat.JSON) + "," + String.valueOf((Object)OutputFormat.XML) + "," + String.valueOf((Object)OutputFormat.SPECIFIC));
        prop.setValue(OutputFormat.SPECIFIC.name());
        sco.addProperty(prop);
        prop = sco.createProperty("file.name", ServicePropertyType.STRING, null);
        prop.setLabel("Output File Name");
        prop.setDescription("Specifies name of the file to be written.");
        prop.setValue("");
        sco.addProperty(prop);
        return sco;
    }
}

