/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.evfsd.evSource;

import com.streamscape.Trace;
import com.streamscape.lib.evfs.DirectoryMonitor;
import com.streamscape.lib.evfs.FileSortStrategy;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationFactory;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationObject;
import com.streamscape.sdo.utils.SDOUtils;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.service.AbstractService;
import com.streamscape.service.evfsd.evSource.Version;
import com.streamscape.service.osf.config.ServiceConfigurationException;
import com.streamscape.service.osf.config.ServiceConfigurationProperty;
import com.streamscape.service.osf.config.ServicePropertyType;
import com.streamscape.service.osf.enums.InvokeMode;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class EVFSDaemon
extends AbstractService {
    public static String SERVICE_NAME = "prototype";
    public static final String SERVICE_TYPE = "EVFSDaemon";
    private ScheduledExecutorService monitorExecutorService;
    private Map<String, DirectoryMonitor> monitors = new HashMap<String, DirectoryMonitor>();

    protected void doInit() {
        Trace.logDebug((Object)((Object)this), (String)"Start to initialize EVFSDaemon...");
        try {
            Long threadNumber = this.ctx.lookupNumericProperty("worker.threads");
            this.monitorExecutorService = Executors.newScheduledThreadPool(threadNumber.intValue());
            Trace.logDebug((Object)((Object)this), (String)("Number of threads: " + threadNumber));
            String tempDir = this.ctx.lookupStringProperty("txlog.dir");
            System.setProperty("EVFSDaemon.txlog.dir", tempDir);
            Trace.logDebug((Object)((Object)this), (String)("Temporary directory is set to '" + tempDir + "'"));
            List list = this.ctx.lookupListProperty("monitors");
            Trace.logDebug((Object)((Object)this), (String)"Start to create directory monitors...");
            for (ServiceConfigurationProperty monitorSCO : list) {
                Hashtable table = (Hashtable)monitorSCO.getValue();
                String monitorName = table.get("monitor.name") != null ? ((ServiceConfigurationProperty)table.get("monitor.name")).getValue().toString() : "";
                String dirToWatch = ((ServiceConfigurationProperty)table.get("monitor.dir")).getValue().toString();
                Integer delay = ((Long)((ServiceConfigurationProperty)table.get("monitor.interval")).getValue()).intValue();
                boolean recursiveScan = (Boolean)((ServiceConfigurationProperty)table.get("recursive.scan")).getValue();
                boolean existingAsCreated = false;
                try {
                    existingAsCreated = (Boolean)((ServiceConfigurationProperty)table.get("existing.as.created")).getValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                FileSortStrategy sortStrategy = FileSortStrategy.valueOf((String)((ServiceConfigurationProperty)table.get("sort.strategy")).getValue().toString());
                DirectoryMonitor monitor = new DirectoryMonitor(monitorName, dirToWatch, recursiveScan, sortStrategy, existingAsCreated, this.ctx);
                ServiceConfigurationProperty sendSnapshotElement = (ServiceConfigurationProperty)table.get("monitor.send.snapshots");
                if (sendSnapshotElement != null) {
                    Boolean isSendSnapshot = Boolean.parseBoolean(sendSnapshotElement.getValue().toString());
                    monitor.setSendSnapshots(isSendSnapshot.booleanValue());
                    if (isSendSnapshot.booleanValue()) {
                        monitor.setSnapshotEventId((String)((ServiceConfigurationProperty)table.get("monitor.send.snapshots.eventid")).getValue());
                    }
                }
                this.monitors.put(monitor.getMonitorName(), monitor);
                this.monitorExecutorService.scheduleWithFixedDelay((Runnable)monitor, 0L, delay.intValue(), TimeUnit.MILLISECONDS);
                Trace.logDebug((Object)((Object)this), (String)("Directory monitor '" + monitorName + "' looking for '" + dirToWatch + "' has been created"));
            }
            Trace.logDebug((Object)((Object)this), (String)"All monitors have been created");
        }
        catch (ServiceConfigurationException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        Trace.logDebug((Object)((Object)this), (String)"Initialization has been successfully finished.");
    }

    public void destroy() {
        Trace.logDebug((Object)((Object)this), (String)"Destroying EVFSDaemon...");
        this.monitorExecutorService.shutdown();
        Trace.logDebug((Object)((Object)this), (String)"EVFSDaemon destroyed");
    }

    public void resume() {
        Trace.logDebug((Object)((Object)this), (String)"Resuming EVFSDaemon...");
        for (DirectoryMonitor monitor : this.monitors.values()) {
            monitor.start();
        }
        Trace.logDebug((Object)((Object)this), (String)"EVFSDaemon resumed");
    }

    public void start() {
        Trace.logDebug((Object)((Object)this), (String)"Starting EVFSDaemon...");
        for (DirectoryMonitor monitor : this.monitors.values()) {
            monitor.start();
        }
        Trace.logDebug((Object)((Object)this), (String)"EVFSDaemon started");
    }

    public void suspend() {
        Trace.logDebug((Object)((Object)this), (String)"Suspending EVFSDaemon...");
        for (DirectoryMonitor monitor : this.monitors.values()) {
            monitor.suspend();
        }
        Trace.logDebug((Object)((Object)this), (String)"EVFSDaemon suspended");
    }

    public void stop() {
        Trace.logDebug((Object)((Object)this), (String)"Stoping EVFSDaemon...");
        for (DirectoryMonitor monitor : this.monitors.values()) {
            monitor.suspend();
        }
        Trace.logDebug((Object)((Object)this), (String)"EVFSDaemon stopped");
    }

    public int getMajorVersion() {
        return Version.getMajorVersion();
    }

    public int getMinorVersion() {
        return Version.getMinorVersion();
    }

    public int getMinorBuild() {
        return Version.getBuild();
    }

    public String getVersion() {
        return Version.getVersionString();
    }

    public static ServiceConfigurationObject generateSco() throws Exception {
        ServiceConfigurationObject sco = ServiceConfigurationFactory.createServiceConfiguration((FabricComponent)RuntimeContext.getInstance(), (String)"prototype", (String)SERVICE_TYPE, (boolean)false);
        sco.setServiceClassName(EVFSDaemon.class.getName());
        sco.setServiceDescription("Polls the specified file system directories and checks for any changes.");
        sco.setServiceDisplayName("EVFileSystem Daemon");
        sco.setInvokeMode(InvokeMode.ASYNC);
        ServiceConfigurationProperty prop = sco.createProperty("worker.threads", ServicePropertyType.NUMERIC, null);
        prop.setLabel("Worker Threads");
        prop.setDescription("Specifies number of threads for monitors execution.");
        prop.setValue((Object)5);
        sco.addProperty(prop);
        prop = sco.createProperty("txlog.dir", ServicePropertyType.STRING, null);
        prop.setLabel("Dynamic SQL Mode");
        prop.setDescription("Specifies directory name for file transactions log.");
        prop.setValue("txlog");
        sco.addProperty(prop);
        ServiceConfigurationProperty monitors = sco.createProperty("monitors", ServicePropertyType.LIST, null);
        monitors.setLabel("Monitors");
        monitors.setDescription("Contains list of all monitors.");
        sco.addProperty(monitors);
        ServiceConfigurationProperty monitor = sco.createProperty("monitor", ServicePropertyType.TABLE, null);
        monitor.setLabel("Monitor");
        monitor.setDescription("Contains configuration of a monitor.");
        ((List)monitors.getValue()).add(monitor);
        Hashtable monitorConfig = (Hashtable)monitor.getValue();
        prop = sco.createProperty("monitor.name", ServicePropertyType.STRING, null);
        prop.setLabel("Monitor Name");
        prop.setDescription("Specifies name of the monitor.");
        prop.setValue("TestMonitor");
        monitorConfig.put(prop.getName(), prop);
        prop = sco.createProperty("monitor.dir", ServicePropertyType.STRING, null);
        prop.setLabel("Monitor Directory");
        prop.setDescription("Specifies directory which monitor should look for changes in.");
        prop.setValue("");
        monitorConfig.put(prop.getName(), prop);
        prop = sco.createProperty("monitor.interval", ServicePropertyType.NUMERIC, null);
        prop.setLabel("Monitor Period");
        prop.setDescription("Specifies the period of time between taking a snapshots for changes analysis.");
        prop.setValue((Object)1000);
        monitorConfig.put(prop.getName(), prop);
        prop = sco.createProperty("monitor.send.snapshots", ServicePropertyType.BOOLEAN, null);
        prop.setLabel("Send Snapshot");
        prop.setDescription("Specifies whether monitor need to send snaphots.");
        prop.setValue((Object)false);
        monitorConfig.put(prop.getName(), prop);
        prop = sco.createProperty("monitor.send.snapshots.eventid", ServicePropertyType.STRING, null);
        prop.setLabel("Snaphot EventId");
        prop.setDescription("Specifies event id for publishing directory snapshot information.");
        prop.setValue("event.snapshot");
        monitorConfig.put(prop.getName(), prop);
        prop = sco.createProperty("recursive.scan", ServicePropertyType.BOOLEAN, null);
        prop.setLabel("Recursive Scan");
        prop.setDescription("Specifies wheather subdirectories need to be included into the scan.");
        prop.setValue((Object)false);
        monitorConfig.put(prop.getName(), prop);
        prop = sco.createProperty("sort.strategy", ServicePropertyType.ENUMERATION, null);
        prop.setLabel("Sort Strategy");
        prop.setDescription("Specifies the sort strategy for files in the snapshot.");
        prop.setRange(String.valueOf(FileSortStrategy.SERVER_DEFAULT) + "," + String.valueOf(FileSortStrategy.MODIFICATION_TIME));
        prop.setValue(FileSortStrategy.SERVER_DEFAULT.name());
        monitorConfig.put(prop.getName(), prop);
        prop = sco.createProperty("existing.as.created", ServicePropertyType.BOOLEAN, null);
        prop.setLabel("Existing Files Publish");
        prop.setDescription("Specifies wheather files existing in the directory at the moment of service start need to be published with CREATED state.");
        prop.setValue((Object)true);
        monitorConfig.put(prop.getName(), prop);
        sco.addActionableEvent("event.file.StateChange");
        sco.addActionableEvent("event.file.Content");
        sco.addActionableEvent("event.snapshot");
        return sco;
    }

    static {
        try {
            SDOUtils.addEventPrototype((String)"BytesEvent", (String)"event.file.Content");
        }
        catch (Exception error) {
            Trace.logError(EVFSDaemon.class, (String)"Unable to register default event prototypes.");
        }
    }
}

