/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.error.evSink;

import com.streamscape.repository.object.ReferenceContext;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.obj.SemanticObjectReferenceStore;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationFactory;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationObject;
import com.streamscape.sdo.excp.ServiceFrameworkException;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.service.AbstractService;
import com.streamscape.service.converter.ConverterPlugin;
import com.streamscape.service.converter.ConverterPluginException;
import com.streamscape.service.error.evSink.Version;
import com.streamscape.service.osf.config.AbstractServiceConfigurationObject;
import com.streamscape.service.osf.config.ObjectPropertyValue;
import com.streamscape.service.osf.config.ServiceConfigurationProperty;
import com.streamscape.service.osf.config.ServicePropertyType;
import com.streamscape.service.osf.enums.InvokeMode;
import com.streamscape.service.osf.evh.EventHandler;

public class ErrorHandlerService
extends AbstractService {
    private ConverterPlugin plugin = null;

    public void destroy() {
    }

    public String getVersion() {
        return Version.getVersionString();
    }

    public void doInit() {
        this.ctx.logInfo("Service initializing...");
        try {
            ObjectPropertyValue convPluginValue = this.ctx.lookupObjectProperty("plugin");
            SemanticObjectReferenceStore.beginXact((FabricComponent)this.ctx);
            this.plugin = (ConverterPlugin)((Object)SemanticObjectReferenceStore.loadObject((ObjectPropertyValue)convPluginValue));
            SemanticObjectReferenceStore.commitXact();
            this.plugin.init(this.ctx);
            this.ctx.logInfo("Service initialized.");
        }
        catch (Exception error) {
            this.ctx.logError("Unable to initialize service. " + error.getMessage());
            throw new RuntimeException(error);
        }
    }

    public Object handle(Object source) {
        try {
            Object result = this.plugin.invoke(source);
            this.ctx.logDebug("Incoming request has been successfully handled.");
            return result;
        }
        catch (ConverterPluginException error) {
            this.ctx.logError("Unable to convert input data. " + error.getMessage());
        }
        catch (Exception error) {
            error.printStackTrace();
        }
        return null;
    }

    public void start() throws ServiceFrameworkException {
        super.start();
        this.plugin.start();
    }

    public void stop() throws ServiceFrameworkException {
        this.plugin.stop();
        super.stop();
    }

    public int getMinorBuild() {
        return Version.getBuild();
    }

    public int getMajorVersion() {
        return Version.getMajorVersion();
    }

    public int getMinorVersion() {
        return Version.getMinorVersion();
    }

    public static ServiceConfigurationObject generateSco() throws Exception {
        RuntimeContext.getInstance();
        ServiceConfigurationObject sco = ServiceConfigurationFactory.createServiceConfiguration((FabricComponent)RuntimeContext.getInstance(), (String)"prototype", (String)"ErrorHandler", (boolean)false);
        sco.setServiceClassName(ErrorHandlerService.class.getName());
        sco.setServiceDescription("Performs conversion of failure messages/objects to some readable format.");
        sco.setServiceDisplayName("Error Handler");
        sco.setInvokeMode(InvokeMode.ASYNC);
        ReferenceContext ref = new ReferenceContext(new ReferenceContext(null, null), "/handler");
        SemanticType objSemType = RuntimeContext.getInstance().getSemanticTypeCache().lookupSemanticType("object");
        EventHandler handler = new EventHandler((AbstractServiceConfigurationObject)sco, "handle", "ErrorHandler");
        handler.bindRequestObject("event.failure.object", objSemType);
        handler.bindResponseObject("event.conversion.result", objSemType);
        sco.addEventHandler(handler);
        ServiceConfigurationProperty prop = sco.createProperty("plugin", ServicePropertyType.OBJECT, null);
        prop.setLabel("Error Handler Plugin");
        prop.setDescription("Specifies error handler plugin object which performs conversion.");
        prop.setValue((Object)new ObjectPropertyValue("handler", "ConverterPlugin", ref));
        sco.addProperty(prop);
        sco.addException("exception.omf.SemanticMapper");
        return sco;
    }
}

