/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.dbms.evSource.mod;

import com.streamscape.Trace;
import com.streamscape.omf.xml.XSerializer;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.obj.SemanticObjectReferenceStore;
import com.streamscape.sdo.excp.DatabaseSQLException;
import com.streamscape.sdo.excp.SQLQueryParseException;
import com.streamscape.sdo.excp.SQLQueryValidationException;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sdo.sql.SQLQuery;
import com.streamscape.sdo.sql.SQLQueryBatch;
import com.streamscape.sdo.sql.SQLQueryFactory;
import com.streamscape.sdo.sql.SQLQueryMapper;
import com.streamscape.sef.FabricComponent;
import com.streamscape.service.dbms.evSource.mod.IDatabaseEventSource;
import com.streamscape.service.osf.config.ConfigurationObject;
import com.streamscape.service.osf.config.ObjectPropertyValue;
import com.streamscape.service.osf.config.ServiceConfigurationException;
import com.streamscape.service.osf.jdbc.DatabaseConnection;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;

public class SQLEventSource
implements IDatabaseEventSource {
    private transient DatabaseConnection connection = null;
    private transient SQLQueryBatch startUpSQL = null;
    private transient SQLQueryBatch shutDownSQL = null;
    private transient SQLQuery getKeyQuery = null;
    private transient SQLQuery acknowledgeQuery = null;
    private transient SQLQuery getNextRowSetQuery = null;
    private transient int queryTimeout = 0;
    private transient SQLQueryMapper getNextQueryMapper = null;
    private transient SQLQueryMapper acknowledgeQueryMapper = null;
    private transient boolean useMultiRowAck = false;
    private transient boolean useMultiRowStream = false;
    protected XSerializer serializer = null;
    private String description = "The module allows for arbitrary SQL to act a database Event Source.";
    private String vendorString = "SQL Query Change Capture v2.1";

    @Override
    public void acknowledge(RowSet result) throws DatabaseSQLException {
        if (this.acknowledgeQuery == null) {
            return;
        }
        try {
            List results;
            Trace.logDebug(SQLEventSource.class, (String)"Executing RowSet Acknowledge Query...");
            SQLQuery temp = this.acknowledgeQuery;
            if (result != null && (results = this.acknowledgeQueryMapper.map(result)).size() > 0) {
                temp = (SQLQuery)results.get(0);
            }
            if (Trace.isDebugEnabled(SQLEventSource.class)) {
                Trace.logDebug(SQLEventSource.class, (String)("Acknowledge Query: " + SQLQueryFactory.renderQuery((SQLQuery)temp)));
            }
            try {
                this.printRowSetsToDebug(SQLQueryFactory.execute((SQLQuery)temp, (int)this.queryTimeout, (Connection)this.connection), "Acknowledge Query");
            }
            catch (Exception exception) {
                Trace.logError((Object)this, (String)("Failed query: " + SQLQueryFactory.renderQuery((SQLQuery)temp)));
                throw this.wrapException(exception);
            }
            Trace.logDebug(SQLEventSource.class, (String)"RowSet Acknowledge Query executed.");
        }
        catch (SQLQueryParseException | SQLQueryValidationException exception) {
            throw this.wrapException(exception);
        }
    }

    @Override
    public RowSet getNextRowSet(RowSet rowSetIds) throws DatabaseSQLException {
        RowSet result = null;
        try {
            SQLQuery temp = this.getNextRowSetQuery;
            if (rowSetIds != null) {
                List results = this.getNextQueryMapper.map(rowSetIds);
                if (results.size() == 0) {
                    return null;
                }
                temp = (SQLQuery)results.get(0);
            }
            if (Trace.isDebugEnabled(SQLEventSource.class)) {
                Trace.logDebug(SQLEventSource.class, (String)("RowSet Retrieval Query: " + SQLQueryFactory.renderQuery((SQLQuery)temp)));
            }
            try {
                List rowSets = SQLQueryFactory.execute((SQLQuery)temp, (int)this.queryTimeout, (Connection)this.connection);
                this.printRowSetsToDebug(rowSets, "RowSet Retrieval Query");
                if (rowSets.size() > 1) {
                    Trace.logError((Object)this, (String)"Multiple row sets detected during [Row Set retrieval] operation.");
                } else if (rowSets.size() == 1) {
                    result = (RowSet)rowSets.get(0);
                }
            }
            catch (Exception exception) {
                Trace.logError((Object)this, (String)("Failed query: " + SQLQueryFactory.renderQuery((SQLQuery)temp)));
                throw this.wrapException(exception);
            }
        }
        catch (SQLQueryParseException | SQLQueryValidationException exception) {
            throw this.wrapException(exception);
        }
        return result;
    }

    @Override
    public RowSet getNextKey() throws DatabaseSQLException {
        if (this.getKeyQuery == null) {
            return null;
        }
        RowSet result = null;
        try {
            Trace.logDebug(SQLEventSource.class, (String)"Executing Key Retrieval Query...");
            if (Trace.isDebugEnabled(SQLEventSource.class)) {
                Trace.logDebug(SQLEventSource.class, (String)("Key Retrieval Query: " + SQLQueryFactory.renderQuery((SQLQuery)this.getKeyQuery)));
            }
            try {
                List rowSets = SQLQueryFactory.execute((SQLQuery)this.getKeyQuery, (int)this.queryTimeout, (Connection)this.connection);
                this.printRowSetsToDebug(rowSets, "Key Retrieval Query");
                if (rowSets.size() > 1) {
                    Trace.logError(SQLEventSource.class, (String)"Multiple row sets detected during [Key retrieval] operation.");
                } else if (rowSets.size() == 1) {
                    result = (RowSet)rowSets.get(0);
                }
            }
            catch (Exception exception) {
                Trace.logError((Object)this, (String)("Failed query: " + SQLQueryFactory.renderQuery((SQLQuery)this.getKeyQuery)));
                throw this.wrapException(exception);
            }
            Trace.logDebug(SQLEventSource.class, (String)"Key Retrieval Query executed.");
        }
        catch (SQLQueryParseException | SQLQueryValidationException exception) {
            throw this.wrapException(exception);
        }
        return result;
    }

    private void printRowSetsToDebug(List<RowSet> rowSets, String message) {
        if (Trace.isDebugEnabled(SQLEventSource.class)) {
            int i = 0;
            for (RowSet rowSet : rowSets) {
                try {
                    Trace.logDebug(SQLEventSource.class, (String)(message + " execution result (" + ++i + "): \n" + this.serializer.serialize((Object)rowSet)));
                }
                catch (Exception ex) {
                    Trace.logException(SQLEventSource.class, (Throwable)ex, (boolean)true);
                }
            }
        }
    }

    @Override
    public void execStartUpScript() throws DatabaseSQLException, ServiceConfigurationException {
        block4: {
            try {
                if (this.startUpSQL == null) break block4;
                try {
                    Statement stat = this.connection.createStatement();
                    SQLQueryFactory.execute((SQLQueryBatch)this.startUpSQL, (int)this.queryTimeout, (Connection)this.connection);
                    stat.close();
                }
                catch (Exception error) {
                    throw this.wrapException(error);
                }
            }
            catch (Exception error) {
                Trace.logException(SQLEventSource.class, (Throwable)error, (boolean)true);
            }
        }
    }

    @Override
    public void execShutDownScript() throws DatabaseSQLException, ServiceConfigurationException {
        block4: {
            try {
                if (this.shutDownSQL == null) break block4;
                try {
                    Statement stat = this.connection.createStatement();
                    SQLQueryFactory.execute((SQLQueryBatch)this.shutDownSQL, (int)this.queryTimeout, (Connection)this.connection);
                    stat.close();
                }
                catch (Exception error) {
                    throw this.wrapException(error);
                }
            }
            catch (Exception error) {
                Trace.logException(SQLEventSource.class, (Throwable)error, (boolean)true);
            }
        }
    }

    @Override
    public void init(DatabaseConnection connection, int queryTimeout, ConfigurationObject sco) throws DatabaseSQLException {
        RuntimeContext runtimeCtx = RuntimeContext.getInstance();
        this.connection = connection;
        this.queryTimeout = queryTimeout;
        try {
            try {
                ObjectPropertyValue startupSQL = (ObjectPropertyValue)sco.getServiceConfigurationProperties().getProperty("startup.sql").getValue();
                SemanticObjectReferenceStore.beginXact((FabricComponent)runtimeCtx);
                this.startUpSQL = (SQLQueryBatch)SemanticObjectReferenceStore.loadObject((ObjectPropertyValue)startupSQL);
                SemanticObjectReferenceStore.commitXact();
            }
            catch (Exception error) {
                Trace.logError((Object)this, (String)error.getMessage());
            }
            try {
                ObjectPropertyValue shutdownSQL = (ObjectPropertyValue)sco.getServiceConfigurationProperties().getProperty("shutdown.sql").getValue();
                SemanticObjectReferenceStore.beginXact((FabricComponent)runtimeCtx);
                this.shutDownSQL = (SQLQueryBatch)SemanticObjectReferenceStore.loadObject((ObjectPropertyValue)shutdownSQL);
                SemanticObjectReferenceStore.commitXact();
            }
            catch (Exception error) {
                Trace.logError((Object)this, (String)error.getMessage());
            }
            try {
                ObjectPropertyValue getNextKeySQL = (ObjectPropertyValue)sco.getServiceConfigurationProperties().getProperty("next.key.sql").getValue();
                SemanticObjectReferenceStore.beginXact((FabricComponent)runtimeCtx);
                this.getKeyQuery = (SQLQuery)SemanticObjectReferenceStore.loadObject((ObjectPropertyValue)getNextKeySQL);
                SemanticObjectReferenceStore.commitXact();
            }
            catch (Exception error) {
                Trace.logError((Object)this, (String)error.getMessage());
            }
            ObjectPropertyValue getNextSQL = (ObjectPropertyValue)sco.getServiceConfigurationProperties().getProperty("next.rowset.sql").getValue();
            SemanticObjectReferenceStore.beginXact((FabricComponent)runtimeCtx);
            this.getNextRowSetQuery = (SQLQuery)SemanticObjectReferenceStore.loadObject((ObjectPropertyValue)getNextSQL);
            SemanticObjectReferenceStore.commitXact();
            this.getNextQueryMapper = new SQLQueryMapper(this.getNextRowSetQuery, 1);
            try {
                ObjectPropertyValue acknowledgeSQL = (ObjectPropertyValue)sco.getServiceConfigurationProperties().getProperty("acknowledge.sql").getValue();
                SemanticObjectReferenceStore.beginXact((FabricComponent)runtimeCtx);
                this.acknowledgeQuery = (SQLQuery)SemanticObjectReferenceStore.loadObject((ObjectPropertyValue)acknowledgeSQL);
                SemanticObjectReferenceStore.commitXact();
                this.acknowledgeQueryMapper = new SQLQueryMapper(this.acknowledgeQuery, 1);
            }
            catch (Exception error) {
                Trace.logError((Object)this, (String)error.getMessage());
            }
            this.serializer = RuntimeContext.getInstance().getXSerializerFactory().createSerializer("SQLEventSourceSerializer");
        }
        catch (Exception error) {
            throw this.wrapException(error);
        }
    }

    private DatabaseSQLException wrapException(Throwable error) {
        DatabaseSQLException databaseSQLException = null;
        databaseSQLException = error instanceof DatabaseSQLException ? (DatabaseSQLException)error : (error instanceof SQLException ? new DatabaseSQLException((SQLException)error) : new DatabaseSQLException(1024, error.getMessage(), error));
        databaseSQLException.setConnectionName(this.connection.getName());
        this.connection.raiseException(databaseSQLException);
        return databaseSQLException;
    }

    @Override
    public boolean supportsAcknowledgeQuery() {
        return true;
    }

    @Override
    public boolean supportsGetNextKeyQuery() {
        return false;
    }

    @Override
    public boolean supportsGetNextRowSetQuery() {
        return true;
    }

    @Override
    public boolean supportsSessionInitQuery() {
        return true;
    }

    @Override
    public boolean supportsStartupQuery() {
        return false;
    }

    @Override
    public boolean supportsShutdownQuery() {
        return false;
    }

    @Override
    public boolean supportsMutiRowResult() {
        return false;
    }

    @Override
    public boolean supportsMultiRowResultStreaming() {
        return false;
    }

    @Override
    public void setMultiRowResultStreaming(boolean stream) {
    }

    @Override
    public boolean isMultiRowResultStreaming() {
        return this.useMultiRowStream;
    }

    @Override
    public boolean supportsMutiRowAcknowledge() {
        return false;
    }

    @Override
    public void setMultiRowAcknowledge(boolean group) {
    }

    @Override
    public boolean isMutiRowAcknowledge() {
        return this.useMultiRowAck;
    }

    @Override
    public void runSetup() throws ServiceConfigurationException, DatabaseSQLException {
        throw new ServiceConfigurationException("Unsupported Capability.");
    }

    @Override
    public boolean supportsAdminSetup() {
        return false;
    }

    @Override
    public void runReset() throws ServiceConfigurationException, DatabaseSQLException {
        throw new ServiceConfigurationException("Unsupported Capability.");
    }

    @Override
    public boolean supportsAdminReset() {
        return false;
    }

    @Override
    public void runRemove() throws ServiceConfigurationException, DatabaseSQLException {
        throw new ServiceConfigurationException("Unsupported Capability.");
    }

    @Override
    public boolean supportsAdminRemove() {
        return false;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getVendorString() {
        return this.vendorString;
    }
}

