/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.converter.plugins;

import com.streamscape.omf.mapper.ConverterException;
import com.streamscape.omf.mapper.ConverterPlugin;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.ExceptionEventDatagram;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sdo.event.MailEvent;
import com.streamscape.sdo.mf.admin.DatagramFactoryException;
import com.streamscape.sef.exchange.FabricAddress;
import com.streamscape.sef.moderator.ComponentReference;
import com.streamscape.sef.moderator.Moderator;

public class GeneralErrorToEmailConverter
implements ConverterPlugin<ImmutableEventDatagram, MailEvent> {
    public int getVersion() {
        return 1;
    }

    public String getDescription() {
        return "Converts any exception event datagrams into human readable e-mail with HTML content.";
    }

    public MailEvent convert(ImmutableEventDatagram source) throws ConverterException {
        try {
            MailEvent mailEvent = (MailEvent)EventDatagramFactory.getInstance().newEventInstance("MailEvent");
            mailEvent.setContentType("text/html");
            StringBuffer body = new StringBuffer();
            body.append("<html><body>");
            body.append("<center><h2 style=\"font-family: arial, sans-serif;\">Error Details</h2></center>");
            body.append("<center><table border=\"0\" style=\"background-color:#C0C0C0;color:black;font-size: 10pt;font-family: arial, sans-serif;\"><tbody>");
            body.append("<tr>");
            body.append("<td style=\"background-color:#808080;color:white\"><p><b>Timestamp</b></p></td>");
            body.append("<td style=\"background-color:#C0C0C0;color:black\"><p>" + String.valueOf(source.getTimestamp()) + "</p></td>");
            body.append("</tr>");
            Moderator moderator = RuntimeContext.getInstance().getModerator();
            FabricAddress sourceAddress = new FabricAddress(source.getEventSource());
            ComponentReference component = moderator.lookupComponent(sourceAddress);
            String sourceName = null;
            sourceName = component != null ? component.getName() : (moderator.lookupFabricNode(sourceAddress) != null ? moderator.lookupFabricNode(sourceAddress).getName() : "Unknown");
            if (sourceName != null) {
                body.append("<tr>");
                body.append("<td style=\"background-color:#808080;color:white\"><p><b>Component Name</b></p></td>");
                body.append("<td style=\"background-color:#C0C0C0;color:black\"><p>" + sourceName + "</p></td>");
                body.append("</tr>");
            }
            if (source instanceof ExceptionEventDatagram && ((ExceptionEventDatagram)source).getCorrelationId() != null) {
                body.append("<tr>");
                body.append("<td style=\"background-color:#808080;color:white\"><p><b>Process Correlation ID</b></p></td>");
                body.append("<td style=\"background-color:#C0C0C0;color:black\"><p>" + ((ExceptionEventDatagram)source).getCorrelationId() + "</p></td>");
                body.append("</tr>");
            }
            if (source instanceof ExceptionEventDatagram && ((ExceptionEventDatagram)source).getCorrelationId() != null) {
                body.append("<tr>");
                body.append("<td style=\"background-color:#808080;color:white\"><p><b>Exception Name</b></p></td>");
                body.append("<td style=\"background-color:#C0C0C0;color:black\"><p>" + source.getClass().getSimpleName() + "</p></td>");
                body.append("</tr>");
            }
            if (source instanceof ExceptionEventDatagram && ((ExceptionEventDatagram)source).getErrorCodeAsString().length() > 0) {
                body.append("<tr>");
                body.append("<td style=\"background-color:#808080;color:white\"><p><b>Error Code</b></p></td>");
                body.append("<td style=\"background-color:#C0C0C0;color:black\"><p>" + ((ExceptionEventDatagram)source).getErrorCodeAsString() + "</p></td>");
                body.append("</tr>");
            }
            if (source instanceof ExceptionEventDatagram) {
                Object indention = "";
                boolean linked = false;
                Throwable throwable = (Throwable)source;
                while (throwable != null && throwable instanceof Exception && (!linked || throwable != source)) {
                    Exception error = (Exception)throwable;
                    body.append("<tr>");
                    body.append("<td style=\"background-color:#808080;color:white\"><p><b>" + (String)indention + "Error Message" + (linked ? " (linked)" : "") + "</b></p></td>");
                    body.append("<td style=\"background-color:#C0C0C0;color:black\"><p>" + error.getMessage() + "</p></td>");
                    body.append("</tr>");
                    throwable = error.getCause();
                    indention = (String)indention + "&nbsp;&nbsp;&nbsp;";
                    linked = true;
                }
            }
            body.append("</tbody></table></center>");
            body.append("</body></html>");
            mailEvent.setBody(body.toString());
            return mailEvent;
        }
        catch (DatagramFactoryException error) {
            throw new ConverterException(5036, error.getMessage());
        }
        catch (Exception error) {
            throw new ConverterException(3000, error.getMessage());
        }
    }
}

