/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.converter;

import com.streamscape.service.converter.RecordFieldNode;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Hashtable;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class DelimitedStringFDParser
extends DefaultHandler {
    private Hashtable FieldNodes = new Hashtable();
    private InputSource inputSource;
    private XMLReader parser;
    private ByteArrayInputStream XMLStream;
    private boolean inFieldElement = false;
    private boolean inTypeElement = false;
    private RecordFieldNode fNode;
    private boolean debug = false;
    private int elementNo = 0;

    public DelimitedStringFDParser(String sourceXML, boolean ddebug) throws FactoryConfigurationError, ParserConfigurationException, SAXException, IOException {
        this.debug = ddebug;
        this.parser = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
        this.XMLStream = new ByteArrayInputStream(sourceXML.getBytes());
        this.parser.setContentHandler(this);
        this.parser.setErrorHandler(this);
        this.inputSource = new InputSource(this.XMLStream);
    }

    public Hashtable invoke() throws SAXException, IOException {
        if (this.debug) {
            System.out.println("*** SAX Parser invoke..");
        }
        this.parser.parse(this.inputSource);
        return this.FieldNodes;
    }

    @Override
    public void startElement(String uri, String name, String qName, Attributes atts) {
        if (qName.equalsIgnoreCase("FILETYPE")) {
            this.inTypeElement = true;
        }
        if (qName.equalsIgnoreCase("FIELD_NAME")) {
            this.inFieldElement = true;
            this.fNode = new RecordFieldNode();
            if (atts.getLength() > 0) {
                for (int i = 0; i < atts.getLength(); ++i) {
                    if (atts.getQName(i).equalsIgnoreCase("DATATYPE")) {
                        this.fNode.DATATYPE = atts.getValue(i).toString();
                    }
                    if (!atts.getQName(i).equalsIgnoreCase("DEFAULT")) continue;
                    this.fNode.DEFAULT = atts.getValue(i).toString();
                }
            }
        }
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        if (qName.equalsIgnoreCase("FIELD_NAME")) {
            this.inFieldElement = false;
        }
        if (qName.equalsIgnoreCase("FILETYPE")) {
            this.inTypeElement = false;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.inTypeElement) {
            this.FieldNodes.put("FILETYPE", new String(ch, start, length));
        }
        if (this.debug && this.inTypeElement) {
            System.out.println("*** FILETYPE: " + String.valueOf(this.FieldNodes.get("FILETYPE")));
        }
        if (this.inFieldElement) {
            ++this.elementNo;
            this.fNode.FIELD_NAME = new String(ch, start, length);
            this.FieldNodes.put(new Integer(this.elementNo), this.fNode);
            if (this.debug) {
                RecordFieldNode f = (RecordFieldNode)this.FieldNodes.get(new Integer(this.elementNo));
                System.out.print("*** FIELD_NAME=" + f.FIELD_NAME + ", Element " + this.elementNo);
                System.out.print(", DATATYPE=" + f.DATATYPE);
                System.out.print(", DEFAULT=" + f.DEFAULT + "\n");
            }
        }
    }
}

