/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.ftp.client;

import com.streamscape.lib.ftp.client.FTPControlSocket;
import com.streamscape.lib.ftp.client.FTPEventListener;
import com.streamscape.lib.ftp.client.FTPException;
import com.streamscape.lib.ftp.client.FTPSessionEvent;
import com.streamscape.lib.ftp.enums.FTPOperation;
import com.streamscape.lib.ftp.enums.FTPSessionState;
import com.streamscape.lib.ftp.enums.FTPTransferType;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

public class FTPTransport {
    protected FTPControlSocket control = null;
    protected Socket data = null;
    protected boolean isRunning = true;
    protected FTPTransferType transferType = null;
    protected FTPEventListener listener = null;

    public FTPTransport(String remoteHost) throws IOException, FTPException {
        this.control = new FTPControlSocket(remoteHost);
    }

    public FTPTransport(String remoteHost, int controlPort) throws IOException, FTPException {
        this.control = new FTPControlSocket(remoteHost, controlPort);
    }

    public FTPTransport(InetAddress remoteAddr) throws IOException, FTPException {
        this.control = new FTPControlSocket(remoteAddr);
    }

    public FTPTransport(InetAddress remoteAddr, int controlPort) throws IOException, FTPException {
        this.control = new FTPControlSocket(remoteAddr, controlPort);
    }

    public void login(String user, String password) throws IOException, FTPException {
        String response = this.control.sendCommand("USER " + user);
        this.control.validateReply(response, "331");
        response = this.control.sendCommand("PASS " + password);
        this.control.validateReply(response, "230");
    }

    public void user(String user) throws IOException, FTPException {
        String reply = this.control.sendCommand("USER " + user);
        String[] validCodes = new String[]{"230", "331"};
        this.control.validateReply(reply, validCodes);
    }

    public void password(String password) throws IOException, FTPException {
        String reply = this.control.sendCommand("PASS " + password);
        String[] validCodes = new String[]{"230", "202"};
        this.control.validateReply(reply, validCodes);
    }

    public void initSOCKS(String port, String host) {
        Properties props = System.getProperties();
        props.put("socksProxyPort", port);
        props.put("socksProxyHost", host);
        System.setProperties(props);
    }

    String getRemoteHostName() {
        return this.control.getRemoteHostName();
    }

    public List<String> quote(String command, String[] validCodes, boolean socketData) throws IOException, FTPException {
        ArrayList<String> List2 = new ArrayList<String>();
        boolean isBinary = false;
        if (this.transferType.equals(FTPTransferType.BINARY)) {
            isBinary = true;
            this.setType(FTPTransferType.ASCII);
        }
        if (socketData) {
            int count;
            this.data = this.control.createDataSocket();
            InputStreamReader in = new InputStreamReader(this.data.getInputStream());
            BufferedReader bIn = new BufferedReader(in);
            String reply = this.control.sendCommand(command);
            if (validCodes != null) {
                this.control.validateReply(reply, validCodes);
            }
            int chunksize = 4096;
            char[] chunk = new char[chunksize];
            char[] resultBuf = new char[chunksize];
            char[] temp = null;
            int bufsize = 0;
            while ((count = bIn.read(chunk, 0, chunksize)) >= 0) {
                temp = new char[bufsize + count];
                System.arraycopy(resultBuf, 0, temp, 0, bufsize);
                System.arraycopy(chunk, 0, temp, bufsize, count);
                resultBuf = temp;
                bufsize += count;
            }
            try {
                bIn.close();
                this.data.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            reply = this.control.readReply();
            if (validCodes != null) {
                this.control.validateReply(reply, validCodes);
            }
            String result = null;
            if (resultBuf.length > 0) {
                result = new String(resultBuf);
            }
            StringTokenizer st = new StringTokenizer(result, "\n\r");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                List2.add(token);
            }
        } else {
            String reply = this.control.sendCommand(command);
            if (validCodes != null) {
                this.control.validateReply(reply, validCodes);
            }
            StringTokenizer st = new StringTokenizer(reply, "\n\r");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                List2.add(token);
            }
        }
        if (isBinary) {
            this.setType(FTPTransferType.BINARY);
        }
        return List2;
    }

    public void put(String localPath, String remoteFile, int bufSize) throws IOException, FTPException {
        this.put(localPath, remoteFile, false, bufSize);
    }

    public void put(String localPath, String remoteFile, boolean append, int bufSize) throws IOException, FTPException {
        this.data = this.control.createDataSocket();
        DataOutputStream out = new DataOutputStream(this.data.getOutputStream());
        String cmd = append ? "APPE " : "STOR ";
        String reply = this.control.sendCommand(cmd + remoteFile);
        String[] validCodes1 = new String[]{"125", "150"};
        this.control.validateReply(reply, validCodes1);
        FileInputStream input = new FileInputStream(localPath);
        byte[] buf = new byte[bufSize];
        int count = 0;
        while ((count = input.read(buf)) > 0) {
            FTPSessionEvent e;
            if (this.isRunning) {
                out.write(buf, 0, count);
                if (this.listener == null) continue;
                e = new FTPSessionEvent(FTPSessionState.BUFFER_SEND, FTPOperation.PUT, remoteFile, "Session transferred " + bufSize + " bytes.");
                this.listener.onEvent(e);
                continue;
            }
            e = new FTPSessionEvent(FTPSessionState.CANCEL, FTPOperation.PUT, remoteFile, "Session transfer canceled.");
            this.listener.onEvent(e);
            break;
        }
        input.close();
        out.flush();
        out.close();
        try {
            this.data.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        String[] validCodes2 = new String[]{"226", "250", "550", "426"};
        reply = this.control.readReply();
        this.control.validateReply(reply, validCodes2);
    }

    public void put(byte[] bytes, String remoteFile, int bufSize) throws IOException, FTPException {
        this.put(bytes, remoteFile, false, bufSize);
    }

    public void put(byte[] bytes, String remoteFile, boolean append, int bufSize) throws IOException, FTPException {
        this.data = this.control.createDataSocket();
        DataOutputStream out = new DataOutputStream(this.data.getOutputStream());
        String cmd = append ? "APPE " : "STOR ";
        String reply = this.control.sendCommand(cmd + remoteFile);
        String[] validCodes1 = new String[]{"125", "150"};
        this.control.validateReply(reply, validCodes1);
        ByteArrayInputStream input = new ByteArrayInputStream(bytes);
        byte[] buf = new byte[bufSize];
        int count = 0;
        while ((count = input.read(buf)) > 0) {
            FTPSessionEvent e;
            if (this.isRunning) {
                out.write(buf, 0, count);
                if (this.listener == null) continue;
                e = new FTPSessionEvent(FTPSessionState.BUFFER_SEND, FTPOperation.PUT_BYTES, remoteFile, "Session transferred " + bufSize + " bytes.");
                this.listener.onEvent(e);
                continue;
            }
            e = new FTPSessionEvent(FTPSessionState.CANCEL, FTPOperation.PUT_BYTES, remoteFile, "Session transfer canceled.");
            this.listener.onEvent(e);
            break;
        }
        out.flush();
        out.close();
        try {
            this.data.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        String[] validCodes2 = new String[]{"226", "250", "550", "426"};
        reply = this.control.readReply();
        this.control.validateReply(reply, validCodes2);
    }

    public void get(String localPath, String remoteFile, int bufSize) throws IOException, FTPException {
        int count;
        this.data = this.control.createDataSocket();
        DataInputStream in = new DataInputStream(this.data.getInputStream());
        BufferedInputStream bIn = new BufferedInputStream(in);
        String reply = this.control.sendCommand("RETR " + remoteFile);
        String[] validCodes1 = new String[]{"125", "150"};
        this.control.validateReply(reply, validCodes1);
        byte[] chunk = new byte[bufSize];
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(localPath, false));
        while ((count = bIn.read(chunk, 0, bufSize)) >= 0 && this.isRunning) {
            out.write(chunk, 0, count);
        }
        out.close();
        try {
            bIn.close();
            this.data.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String[] validCodes2 = new String[]{"226", "250", "550", "426"};
        reply = this.control.readReply();
        this.control.validateReply(reply, validCodes2);
    }

    public byte[] get(String remoteFile, int bufSize) throws IOException, FTPException {
        int count;
        this.data = this.control.createDataSocket();
        DataInputStream in = new DataInputStream(this.data.getInputStream());
        BufferedInputStream bIn = new BufferedInputStream(in);
        String reply = this.control.sendCommand("RETR " + remoteFile);
        String[] validCodes1 = new String[]{"125", "150"};
        this.control.validateReply(reply, validCodes1);
        byte[] chunk = new byte[bufSize];
        byte[] resultBuf = new byte[bufSize];
        byte[] temp = null;
        int bufsize = 0;
        while ((count = bIn.read(chunk, 0, bufSize)) >= 0 && this.isRunning) {
            temp = new byte[bufsize + count];
            System.arraycopy(resultBuf, 0, temp, 0, bufsize);
            System.arraycopy(chunk, 0, temp, bufsize, count);
            resultBuf = temp;
            bufsize += count;
        }
        try {
            bIn.close();
            this.data.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String[] validCodes2 = new String[]{"226", "250", "550", "426"};
        reply = this.control.readReply();
        this.control.validateReply(reply, validCodes2);
        return resultBuf;
    }

    public boolean site(String command) throws IOException, FTPException {
        String reply = this.control.sendCommand("SITE " + command);
        String[] validCodes = new String[]{"200", "202", "502"};
        this.control.validateReply(reply, validCodes);
        return reply.substring(0, 3).equals("200");
    }

    public List<String> list(String mask) throws IOException, FTPException {
        return this.list(mask, false);
    }

    public List<String> list(String mask, boolean full) throws IOException, FTPException {
        int count;
        ArrayList<String> List2 = new ArrayList<String>();
        boolean isBinary = false;
        if (this.transferType.equals(FTPTransferType.BINARY)) {
            isBinary = true;
            this.setType(FTPTransferType.ASCII);
        }
        this.data = this.control.createDataSocket();
        InputStreamReader in = new InputStreamReader(this.data.getInputStream());
        BufferedReader bIn = new BufferedReader(in);
        String command = full ? "LIST " : "NLST ";
        String reply = this.control.sendCommand(command + mask);
        if (reply != null && reply.startsWith("450")) {
            return List2;
        }
        String[] validCodes1 = new String[]{"125", "150"};
        this.control.validateReply(reply, validCodes1);
        int chunksize = 4096;
        char[] chunk = new char[chunksize];
        char[] resultBuf = new char[chunksize];
        char[] temp = null;
        int bufsize = 0;
        while ((count = bIn.read(chunk, 0, chunksize)) >= 0) {
            temp = new char[bufsize + count];
            System.arraycopy(resultBuf, 0, temp, 0, bufsize);
            System.arraycopy(chunk, 0, temp, bufsize, count);
            resultBuf = temp;
            bufsize += count;
        }
        try {
            bIn.close();
            this.data.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String[] validCodes2 = new String[]{"226", "250"};
        reply = this.control.readReply();
        this.control.validateReply(reply, validCodes2);
        if (isBinary) {
            this.setType(FTPTransferType.BINARY);
        }
        String result = "";
        if (bufsize > 0) {
            result = new String(resultBuf);
        }
        StringTokenizer st = new StringTokenizer(result, "\n\r");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            List2.add(token);
        }
        return List2;
    }

    public List<String> remoteCommands() throws IOException, FTPException {
        ArrayList<String> Commands = new ArrayList<String>();
        String SysType = this.system();
        if (this.transferType.equals(FTPTransferType.BINARY)) {
            this.setType(FTPTransferType.ASCII);
        }
        String reply = this.control.sendCommand("HELP");
        this.control.validateReply(reply, "214");
        StringTokenizer st = new StringTokenizer(reply, "\n\r");
        Commands.add(SysType);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if ("214".equals(token.substring(0, 3)) && !SysType.startsWith("MVS")) continue;
            Commands.add(token);
        }
        return Commands;
    }

    public void debugResponses(boolean on) {
        this.control.debugResponses(on);
    }

    public FTPTransferType getType() {
        return this.transferType;
    }

    public void setType(FTPTransferType type) throws IOException, FTPException {
        String typeStr = FTPTransferType.ASCII_CHAR;
        if (type.equals(FTPTransferType.BINARY)) {
            typeStr = FTPTransferType.BINARY_CHAR;
        }
        String reply = this.control.sendCommand("TYPE " + typeStr);
        this.control.validateReply(reply, "200");
        this.transferType = type;
    }

    public void delete(String remoteFile) throws IOException, FTPException {
        String reply = this.control.sendCommand("DELE " + remoteFile);
        this.control.validateReply(reply, "250");
    }

    public void rename(String from, String to) throws IOException, FTPException {
        String reply = this.control.sendCommand("RNFR " + from);
        this.control.validateReply(reply, "350");
        reply = this.control.sendCommand("RNTO " + to);
        this.control.validateReply(reply, "250");
    }

    public void rmdir(String dir) throws IOException, FTPException {
        String reply = this.control.sendCommand("RMD " + dir);
        this.control.validateReply(reply, "250");
    }

    public void mkdir(String dir) throws IOException, FTPException {
        String reply = this.control.sendCommand("MKD " + dir);
        this.control.validateReply(reply, "257");
    }

    public void chdir(String dir) throws IOException, FTPException {
        String reply = this.control.sendCommand("CWD " + dir);
        this.control.validateReply(reply, "250");
    }

    public String pwd() throws IOException, FTPException {
        String reply = this.control.sendCommand("PWD");
        this.control.validateReply(reply, "257");
        return reply;
    }

    public String system() throws IOException, FTPException {
        String reply = this.control.sendCommand("SYST");
        try {
            this.control.validateReply(reply, "215");
        }
        catch (FTPException fe) {
            this.control.validateReply(reply, "500");
            return new String("Unknown FTP server (UNIX(r) System V Release 4.0)");
        }
        return reply.substring(4);
    }

    public void quit() throws IOException, FTPException {
        String reply = this.control.sendCommand("QUIT\r\n");
        String[] validCodes = new String[]{"221"};
        this.control.validateReply(reply, validCodes);
        this.control.logout();
        this.control = null;
    }

    public void cancel() throws IOException, FTPException {
        this.isRunning = false;
    }

    public String sysType() throws IOException, FTPException {
        String reply = this.control.sendCommand("SYST");
        String type = reply.substring(4);
        try {
            this.control.validateReply(reply, "215");
        }
        catch (FTPException fe) {
            this.control.validateReply(reply, "500");
            return new String("UUNIX");
        }
        if (type.startsWith("Windows_NT")) {
            return "Windows_NT";
        }
        if (type.startsWith("MVS")) {
            return "MVS_OS390";
        }
        if (type.startsWith("UNIX")) {
            return "UNIX";
        }
        return "UNKNOWN";
    }
}

