// author Fred Toussi (fredt@users dot sourceforge.net) version 1.9.0

/*lob_schema_definition*/
CREATE SCHEMA SYS_LOBS AUTHORIZATION Admins
 CREATE LOGGED TABLE BLOCKS(BLOCK_ADDR int, BLOCK_COUNT int NOT NULL, TX_ID long NOT NULL,
   CONSTRAINT BLOCKS_PK PRIMARY KEY(BLOCK_ADDR))
 CREATE INDEX BLOCKS_IDX1 ON BLOCKS(BLOCK_COUNT)
 CREATE INDEX BLOCKS_IDX2 ON BLOCKS(TX_ID)
 CREATE LOGGED TABLE LOBS(BLOCK_ADDR int NOT NULL, BLOCK_COUNT int NOT NULL, BLOCK_OFFSET int, LOB_ID long,
   CONSTRAINT LOBS_PK PRIMARY KEY(LOB_ID, BLOCK_OFFSET),
   CONSTRAINT LOBS_UQ1 UNIQUE(LOB_ID, BLOCK_ADDR),  CONSTRAINT LOBS_UQ2 UNIQUE(BLOCK_ADDR) )
 CREATE INDEX LOBS_IDX1 ON LOBS(LOB_ID, BLOCK_COUNT)
 CREATE LOGGED TABLE LOB_IDS(LOB_ID long, LOB_LENGTH long NOT NULL, LOB_USAGE_COUNT int DEFAULT 0, LOB_TYPE smallint NOT NULL,
   CONSTRAINT LOB_IDS_PK PRIMARY KEY(LOB_ID))
 CREATE INDEX LOBS_IDX2 ON LOB_IDS(LOB_USAGE_COUNT)
 CREATE SEQUENCE LOB_ID AS long START WITH 1

 CREATE PROCEDURE CONVERT_BLOCK(B_ADDR int, B_COUNT int, B_OFFSET int, L_ID long)
  BEGIN TRANSACTION
  DELETE FROM BLOCKS WHERE BLOCK_ADDR = B_ADDR;
  INSERT INTO LOBS VALUES(B_ADDR, B_COUNT, B_OFFSET, L_ID);
 END

 CREATE PROCEDURE DELETE_LOB(L_ID long, TX_ID long)
  BEGIN TRANSACTION
  INSERT INTO BLOCKS (SELECT BLOCK_ADDR,BLOCK_COUNT,TX_ID FROM LOBS WHERE LOB_ID = L_ID);
  DELETE FROM LOBS WHERE LOB_ID = L_ID;
  DELETE FROM LOB_IDS WHERE LOB_ID = L_ID;
 END

 CREATE PROCEDURE DELETE_UNUSED()
  BEGIN TRANSACTION
  INSERT INTO BLOCKS (SELECT BLOCK_ADDR,BLOCK_COUNT,0 FROM LOBS WHERE LOB_ID
   IN (SELECT LOB_ID FROM LOB_IDS WHERE LOB_USAGE_COUNT < 1));
  DELETE FROM LOBS WHERE LOB_ID
   IN (SELECT LOB_ID FROM LOB_IDS WHERE LOB_USAGE_COUNT < 1);
  DELETE FROM LOB_IDS WHERE LOB_USAGE_COUNT < 1;
 END

 CREATE PROCEDURE DELETE_BLOCKS(L_ID long, B_OFFSET int, B_LIMIT int, TX_ID long)
  BEGIN TRANSACTION

  INSERT INTO BLOCKS (SELECT BLOCK_ADDR,BLOCK_COUNT,TX_ID FROM LOBS
   WHERE LOB_ID = L_ID AND BLOCK_OFFSET >= B_OFFSET AND BLOCK_OFFSET < B_LIMIT);
  DELETE FROM LOBS
   WHERE LOB_ID = L_ID AND BLOCK_OFFSET >= B_OFFSET AND BLOCK_OFFSET < B_LIMIT;

 END

 CREATE PROCEDURE CREATE_EMPTY_BLOCK(INOUT B_ADDR int, IN B_COUNT int)
  BEGIN TRANSACTION
  DECLARE TEMP_COUNT int DEFAULT NULL;
  DECLARE TEMP_ADDR int DEFAULT NULL;
  SET (TEMP_ADDR, TEMP_COUNT) = (SELECT BLOCK_ADDR, BLOCK_COUNT FROM BLOCKS WHERE BLOCK_COUNT > B_COUNT AND TX_ID = 0 FETCH 1 ROW ONLY);

  IF (TEMP_ADDR IS NULL)
   THROW EXCEPTION SQLSTATE '45000';

  UPDATE BLOCKS SET BLOCK_COUNT = B_COUNT WHERE BLOCK_ADDR = TEMP_ADDR;
  INSERT INTO BLOCKS VALUES (TEMP_ADDR + B_COUNT, TEMP_COUNT - B_COUNT, 0);
  SET B_ADDR = TEMP_ADDR;
END

 CREATE PROCEDURE DIVIDE_BLOCK(B_OFFSET int, L_ID long)
  BEGIN TRANSACTION
  DECLARE BL_ADDR int DEFAULT NULL;
  DECLARE BL_COUNT int DEFAULT NULL;
  DECLARE BL_OFFSET int DEFAULT NULL;

  SET (BL_ADDR, BL_COUNT, BL_OFFSET) = (SELECT BLOCK_ADDR, BLOCK_COUNT, BLOCK_OFFSET FROM LOBS WHERE LOB_ID = L_ID AND B_OFFSET > BLOCK_OFFSET AND B_OFFSET < BLOCK_OFFSET + BLOCK_COUNT);

   IF (BL_ADDR IS NULL)
    THROW EXCEPTION SQLSTATE '45000';
   
  DELETE FROM LOBS WHERE BLOCK_ADDR = BL_ADDR;
  INSERT INTO LOBS VALUES (BL_ADDR, B_OFFSET - BL_OFFSET, BL_OFFSET, L_ID);
  INSERT INTO LOBS VALUES (BL_ADDR + B_OFFSET - BL_OFFSET, BL_OFFSET + BL_COUNT - B_OFFSET, B_OFFSET, L_ID);

 END  

 CREATE PROCEDURE ALLOC_BLOCKS (IN B_COUNT int, IN B_OFFSET int, IN L_ID long)
  BEGIN TRANSACTION

  DECLARE LOB_ADDR int DEFAULT NULL;
  DECLARE REMAINING_COUNT int DEFAULT 0;
  DECLARE BL_ADDR int DEFAULT NULL;
  DECLARE TEMP_COUNT int DEFAULT 0;
  DECLARE BL_OFFSET int DEFAULT 0;

  SET REMAINING_COUNT = B_COUNT;
  SET BL_OFFSET = B_OFFSET;

  MAIN_LOOP: LOOP

   SET BL_ADDR = (SELECT BLOCK_ADDR FROM BLOCKS WHERE BLOCK_COUNT = REMAINING_COUNT AND TX_ID = 0 FETCH 1 ROW ONLY);

   IF (BL_ADDR IS NOT NULL)
   {
    CALL CONVERT_BLOCK (BL_ADDR, REMAINING_COUNT, BL_OFFSET, L_ID);

    IF (LOB_ADDR IS NULL)
     SET LOB_ADDR = BL_ADDR;
    
    LEAVE MAIN_LOOP;
   }

   SET (BL_ADDR, TEMP_COUNT) = (SELECT BLOCK_ADDR, BLOCK_COUNT FROM BLOCKS WHERE BLOCK_COUNT < REMAINING_COUNT AND TX_ID = 0 FETCH 1 ROW ONLY);

   IF (BL_ADDR IS NOT NULL)
   {
    CALL CONVERT_BLOCK (BL_ADDR, TEMP_COUNT, BL_OFFSET, L_ID);

    IF (LOB_ADDR IS NULL)
      SET LOB_ADDR = BL_ADDR;
   
    SET REMAINING_COUNT = REMAINING_COUNT - TEMP_COUNT;
    SET BL_OFFSET = BL_OFFSET + TEMP_COUNT;
    SET BL_ADDR = NULL;
    SET TEMP_COUNT = 0;
   }
   ELSE
   {
    CALL CREATE_EMPTY_BLOCK (BL_ADDR, REMAINING_COUNT);
    CALL CONVERT_BLOCK (BL_ADDR, REMAINING_COUNT, BL_OFFSET, L_ID);

    IF (LOB_ADDR IS NULL)
     SET LOB_ADDR = BL_ADDR;

    LEAVE MAIN_LOOP;    
   }

  END LOOP MAIN_LOOP;  
 END

CREATE PROCEDURE CREATE_LOB(LOB_ID long, LOB_LENGTH long, LOB_USAGE_COUNT int, LOB_TYPE smallint)
  BEGIN TRANSACTION
   INSERT INTO SYS_LOBS.LOB_IDS VALUES(LOB_ID, LOB_LENGTH, LOB_USAGE_COUNT, LOB_TYPE);
 END

;

/*get_lob_query*/
SELECT * FROM LOBS WHERE LOB_ID = ?;
/*get_lob_part_statement*/
SELECT * FROM LOBS WHERE LOB_ID = ? ORDER BY BLOCK_OFFSET OFFSET ? FETCH ? ROWS ONLY;


