CREATE SCHEMA SYS_FLOBS AUTHORIZATION Admins
 
 CREATE LOGGED TABLE FLOB_IDS
 (
   FLOB_ID long, 
   FLOB_FILENAME string NOT NULL, 
   FLOB_CHARSET string DEFAULT NULL, 
   FLOB_IS_LINKED boolean DEFAULT false, 
   FLOB_USAGE_COUNT int DEFAULT 0, 
   LOCATION_ID long not NULL,
   FLOB_IS_MANAGED boolean not NULL,
   FLOB_IS_VALID boolean not NULL,
   CONSTRAINT FLOB_IDS_PK PRIMARY KEY(FLOB_ID),
   CONSTRAINT FLOB_IDS_LOCATION_ID_FILENAME UNIQUE(LOCATION_ID, FLOB_FILENAME)
 )
--
 CREATE INDEX FLOB_IDS_FLOBS_USAGE_COUNT_IDX ON FLOB_IDS(FLOB_USAGE_COUNT)
--
 CREATE SEQUENCE FLOB_ID AS long START WITH 1
--

 CREATE LOGGED TABLE FLOB_LOCATIONS
 (
   LOCATION_ID long GENERATED BY DEFAULT AS IDENTITY, 
   LOCATION_PATH string not null, 
   CONSTRAINT FLOB_LOCATIONS_PK PRIMARY KEY(LOCATION_ID),
   CONSTRAINT FLOB_LOCATIONS_LOCATION_PATH_IDX UNIQUE(LOCATION_PATH)
 )
--

-- drop function GET_OR_CREATE_FLOB_LOCATION
--
 create function GET_OR_CREATE_FLOB_LOCATION(path string) returns long as
 {
   int n = 0;
   while(true)
   {
      long id = (select LOCATION_ID from FLOB_LOCATIONS where LOCATION_PATH = path);
      if (id != null)
         return id;

      try
      {
         insert into FLOB_LOCATIONS values (null, path);
         return identity();
      }
      catch(e)
      {
         if (n == 10)
            throw e;
      }
         
      n++;
   }
 }
--
 
-- drop function GET_OR_CREATE_FLOB_ID
--
 create function GET_OR_CREATE_FLOB_ID(filename string, flobCharset string, boolean isLinked, boolean isManaged, locationId long) returns long as
 {
   int n = 0;
   while(true)
   {
      update FLOB_IDS set FLOB_USAGE_COUNT = FLOB_USAGE_COUNT + 1, FLOB_CHARSET = flobCharset where LOCATION_ID = locationId and FLOB_FILENAME = filename;
      int c = select DIAGNOSTICS(ROW_COUNT);
      if (c == 1)
         return (select FLOB_ID from FLOB_IDS where LOCATION_ID = locationId and FLOB_FILENAME = filename);
         
      //int flobId = (select FLOB_ID from FLOB_IDS where LOCATION_ID = locationId and FLOB_FILENAME = filename);
      //if (flobId != null)
      //   return flobId;
      
      int flobId = (VALUES NEXT VALUE FOR SYS_FLOBS.FLOB_ID);
      try
      {
         insert into FLOB_IDS values(flobId, filename, flobCharset, isLinked, 1, locationId, isManaged, true);
         return flobId;
      }
      catch(e)
      {
         if (n == 10)
            throw e;
      }
         
      n++;
   }
 }
--

 CREATE PROCEDURE DELETE_ALL_FLOBS()
  BEGIN TRANSACTION
   delete from FLOB_IDS;
   delete from FLOB_LOCATIONS;
 END
--
 CREATE function CREATE_FLOB(flobId long, filename string, charset string, boolean isLinked, boolean isManaged, usageCount int, locationId long) returns long as
 {
   INSERT INTO SYS_FLOBS.FLOB_IDS VALUES(flobId,filename,charset,isLinked,usageCount,locationId, isManaged, true);
   return 0;
 }
--

