package com.streamscape.sample.ws.events.servlet;

import org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeResponse;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;
import org.eclipse.jetty.websocket.servlet.WebSocketServlet;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;

/**
 * <p>Title: Java Samples</p>
 *
 * <p>Description: Sample web socket servlet that instantiate web socket for raise/consumer events.
 *
 * <p>Copyright: Copyright (c) 2015</p>
 *
 * <p>Company: StreamScape Technologies</p>
 *
 * @author Nikita Kutuzov
 * @version 3.5
 */
 public class EventsWebSocketServlet extends WebSocketServlet
 {
    public void configure(WebSocketServletFactory factory)
    {
       factory.setCreator(new EventsWebSocketCreator());
       factory.getPolicy().setIdleTimeout(10000);

       //       // catch ping messages, no need because browser doesn't support pings
       //       org.eclipse.jetty.websocket.server.WebSocketServerFactory impl = (WebSocketServerFactory) factory;
       //       impl.getEventDriverFactory().clearImplementations();
       //       impl.getEventDriverFactory().addImplementation(new JettyAnnotatedImpl(){
       //          public EventDriver create(Object websocket, WebSocketPolicy policy)
       //          {
       //             EventDriver eventDriver = super.create(websocket, policy);
       //             return new EventDriverWrapper(eventDriver)
       //             {
       //                public void onPing(ByteBuffer buffer)
       //                {
       //                   Trace.logError(this, "Ping message recieved!");
       //                }
       //             };
       //          }
       //       });
       //       
       //       impl.addSessionFactory(new WebSocketSessionFactory(impl){
       //          public boolean supports(EventDriver websocket)
       //          {
       //              return super.supports(websocket) || (websocket instanceof EventDriverWrapper);
       //          }
       //       });
    }
    
    public static class EventsWebSocketCreator implements WebSocketCreator
    {
       public Object createWebSocket(ServletUpgradeRequest req, ServletUpgradeResponse resp)
       {
          return new EventsWebSocket();
       }
    }
 }
