function SecurityAccessor(url, userName, password)
{
    this.authenticationHelper = new AuthenticationHelper(userName, password);
    this.url = url;
    this.httpRequest = newHttpRequest(this.url, 60000);
    this.xSessionToken = null;
    
    function _invokeWithAuthentication(callback, uri)
    {
        var accessor = this;
        this.authenticationHelper.reset();
        
        var sendCallback = function(returned, id, statusCode)
        {
            if (AuthenticationHelper.isWwwAuthenticationAnswer(returned))
            {
                if (accessor.authenticationHelper.setWwwAuthentication(returned))
                {
                    accessor.httpRequest.get(sendCallback, accessor.authenticationHelper.addAuthInfo(uri));
                }
                else
                {
                    callback(null, 401);
                }
            }
            else
              callback(returned, statusCode);
        }
        
        this.httpRequest.get(sendCallback, this.authenticationHelper.addAuthInfo(uri));
    }

    this._invokeWithAuthentication = _invokeWithAuthentication;
}

SecurityAccessor.prototype = 
{
    authorize : function(callback)
    {
        var accessor = this;
        
        var authorizeCallback = function(response, statusCode)
        {
           accessor.xSessionToken = response; 
           if (callback != null)
              callback(response, statusCode);
        }
        
        this._invokeWithAuthentication(authorizeCallback, "/security/authorize");
        
        return this.xSessionToken;
    },
    
    unauthorize : function(callback, token)
    {
        var unauthorizeCallback = function(response, statusCode)
        {
           if (callback != null)
              callback(response, statusCode);
        }
        
        if (token == null)
            token = this.xSessionToken;
        
        this.httpRequest.setHeader("x-session-token", token);

        this._invokeWithAuthentication(unauthorizeCallback, "/security/unauthorize");
    },
    
    getXSessionToken : function ()
    {
        return this.xSessionToken;
    }
    
}