package oauthsample;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.methods.GetMethod;

 @WebServlet(name="/UseTokenServlet", urlPatterns={"/usetoken"})
 public class UseTokenServlet  extends HttpServlet 
 {
	 private static final long serialVersionUID = 1L;

	 public UseTokenServlet() 
	 {
		 super();
	 }

	 protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException 
	 {
		 String acceptorurl = request.getParameter("acceptorurl");
		 String token = request.getParameter("token");
		 String client_id = request.getParameter("client_id");

		 ServletOutputStream answer = response.getOutputStream();
		 
		 answer.println("<html>");
		 answer.println("<title>Using access token page</title>");
		 answer.println("<form method=\"POST\" action=\"usetoken\">");
		 answer.println("Please enter REST url:<br>");
		 answer.println("<input type=\"text\" name=\"resturi\" value=\"/exchange/inquire\"/><br>");
		 answer.println("<br>REST call will be performed using HTTP GET request with the foolowing header: <br><br>");
		 answer.println("Authorization: Bearer " + token);
		 answer.println("<br><br>Press button below to send REST request<br><br>");
		 answer.println("<input type=\"submit\" value=\"Send\">");
		 answer.println("<input type=\"hidden\" name=\"acceptorurl\" value=\"" + acceptorurl + "\"/>");
		 answer.println("<input type=\"hidden\" name=\"token\" value=\"" + token + "\"/>");
		 answer.println("<input type=\"hidden\" name=\"client_id\" value=\"" + client_id + "\"/>");
		 answer.println("</form>");
		 
		 String query =  "token=" + token;
		 query += "&client_id=" + client_id;
		 query += "&acceptorurl=" + acceptorurl;

		 answer.println("<br><a href=\"/OAuthSample/index.html\">Go to the first page</a>");

		 answer.println("</html>");
		 
		 
	 }
	 protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException 
	 {
		 String acceptorurl = request.getParameter("acceptorurl");
		 String token = request.getParameter("token");
		 String client_id = request.getParameter("client_id");
		 String resturi =  request.getParameter("resturi");
		 
		 HttpClient client = new HttpClient();
		 GetMethod method = new GetMethod(acceptorurl + resturi);
		 method.addRequestHeader("Authorization", "Bearer " + token);

		 ServletOutputStream answer = response.getOutputStream();
		 
		 try
		 {
			 client.executeMethod(method);
			 String responseBody = method.getResponseBodyAsString();

			 String query =  "token=" + token;
			 query += "&client_id=" + client_id;
			 query += "&acceptorurl=" + acceptorurl;

			 if (method.getStatusCode() == 401)
			 {
				 answer.println("<html>");
				 answer.println("Authorization failed: <br><br>WWW-Authenticate header: " + method.getResponseHeader("WWW-Authenticate"));
				 answer.println("<br><br><a href=\"/OAuthSample/usetoken?" + query +"\">Use token again</a>");
				 answer.println("<br><a href=\"/OAuthSample/revoketoken?" + query +"\">Revoke token</a>");
				 answer.println("<br><br><a href=\"/OAuthSample/index.html\">Go to the first page</a>");
				 answer.println("</html>");
			 }
			 else
			 {
				 answer.println("<html>");
				 answer.println("REST call is successfull<br><br>");
				 
				 answer.println("result: <br>" + responseBody);
				 answer.println("<br>StatusCode: " + method.getStatusCode());

				 answer.println("<br><br><a href=\"/OAuthSample/usetoken?" + query +"\">Use token again</a>");
				 answer.println("<br><a href=\"/OAuthSample/revoketoken?" + query +"\">Revoke token</a>");
				 answer.println("<br><br><a href=\"/OAuthSample/index.html\">Go to the first page</a>");
				 answer.println("</html>");
			 }
		 } 
		 catch (HttpException he) 
		 {

			 response.getOutputStream().println("Http error connecting to '" + acceptorurl + "'");
			 response.getOutputStream().println(he.getMessage());
			 response.setStatus(method.getStatusCode());
		 } 
		 catch (IOException ioe)
		 {

			 response.getOutputStream().println("Unable to connect to '" + acceptorurl + "'");
			 response.setStatus(method.getStatusCode());
		 }		 
	 }
 }
