package oauthsample;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.methods.PostMethod;

 @WebServlet(name="/RevokeTokenServlet", urlPatterns={"/revoketoken"})
 public class RevokeTokenServlet extends HttpServlet 
 {
	 private static final long serialVersionUID = 1L;

	 public RevokeTokenServlet() 
	 {
		 super();
	 }

	 protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException 
	 {
		 String url = request.getParameter("acceptorurl");
		 String query = "/security/oauth2/revoke";
		 query += "?client_id=" + request.getParameter("client_id");
		 query += "&token=" + request.getParameter("token");

		 ServletOutputStream answer = response.getOutputStream();

		 answer.println("<html>");
		 answer.println("The following URL will be used to revoke access_token:<br>");
		 answer.println(url+query + "<br><br>");

		 HttpClient client = new HttpClient();
		 PostMethod method = new PostMethod(url+query);
		 try
		 {
			 client.executeMethod(method);
			 String responseBody = method.getResponseBodyAsString();

			 if (method.getStatusCode() != 200)
			 {
				 answer.println("Access token revoke failed: <br><br>" + responseBody);
				 answer.println("<br><a href=\"/OAuthSample/index.html\">Go to the first page</a>");
			 }
			 else
			 {
				 answer.println("Access token successfully revoked");

				 query =  "token=" + request.getParameter("token");
				 query += "&client_id=" + request.getParameter("client_id");
				 query += "&acceptorurl=" + request.getParameter("acceptorurl");;

				 answer.println("<br><br><a href=\"/OAuthSample/revoketoken?" + query + "\">Revoke token again</a>");
				 answer.println("<br><a href=\"/OAuthSample/usetoken?" + query +"\">Use revoked token</a>");
		         
				 answer.println("<br><a href=\"/OAuthSample/index.html\">Go to the first page</a>");
			 }
			 answer.println("</html>");
		 } 
		 catch (HttpException he) 
		 {

			 response.getOutputStream().println("Http error connecting to '" + url + "'");
			 response.getOutputStream().println(he.getMessage());
			 response.setStatus(method.getStatusCode());
		 } 
		 catch (IOException ioe)
		 {

			 response.getOutputStream().println("Unable to connect to '" + url + "'");
			 response.setStatus(method.getStatusCode());
		 }		 
	 }

	 protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException 
	 {
	 }

 }
