package oauthsample;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

 @WebServlet(name="/DisplayAuthorizePageServlet" , urlPatterns={"/displayauthorizepage"})
 public class DisplayAuthorizePageServlet extends HttpServlet 
 {
	 private static final long serialVersionUID = 1L;

	 public DisplayAuthorizePageServlet() 
	 {
		 super();
	 }

	 protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException 
	 {
		 doPost(request, response);
	 }

	 protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException 
	 {
		 if (request.getParameter("flow").equals("webserver"))
		 {
			 int showtokenrequestpage = request.getParameter("showtokenrequestpage") != null ? 1 : 0;

			 String url = request.getParameter("acceptorurl");
			 url += "/security/oauth2/authorize";
			 url += "?response_type=code";
			 url += "&client_id=restclient";
			 url += "&redirect_uri=" + request.getRequestURL().toString() + "/code/cb";
			 url += "&state=" + request.getParameter("acceptorurl") + "," + showtokenrequestpage;
			 url += "&scope=somescope";
			 url += "&display=page";

			 response.sendRedirect(url);
		 }
		 else
		 {
			 String url = request.getParameter("acceptorurl");
			 url += "/security/oauth2/authorize";
			 url += "?response_type=token";
			 url += "&client_id=restclient";
			 url += "&redirect_uri=" + request.getRequestURL().toString() + "/token/cb";
			 url += "&state=" + request.getParameter("acceptorurl");
			 url += "&scope=somescope";
			 url += "&display=page";

			 response.sendRedirect(url);
		 }
	 }
 }
