package oauthsample;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

 @WebServlet(name="/CodeCallbackServlet", urlPatterns={"/displayauthorizepage/code/cb"})
 public class CodeCallbackServlet extends HttpServlet 
 {
	 private static final long serialVersionUID = 1L;

	 public CodeCallbackServlet() 
	 {
		 super();
	 }

	 protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException 
	 {
		 ServletOutputStream answer = response.getOutputStream();
		 if (request.getParameter("error") != null)
		 {
			 answer.println("<html>");
			 answer.println("Authentication request failed<br>");
			 answer.println("<br>error: " + request.getParameter("error"));
			 if (request.getParameter("error_description") != null)
				 answer.println("<br>error_description: " + request.getParameter("error_description"));
			 
			 answer.println("<br><br><a href=\"/OAuthSample/webserverflow.html\">Try again</a>");
			 answer.println("<br><a href=\"/OAuthSample/index.html\">Go to the first page</a>");
			 answer.println("</html>");
		 }
		 else if (request.getParameter("code") != null)
		 {
			 String state = request.getParameter("state");
			 boolean showtokenrequestpage = state.endsWith(",1") ? true : false;
			 String acceptorUrl = state.substring(0, state.length() - 2);
			 
			 String requestTokenUrl = acceptorUrl + "/security/oauth2/token/";
			 requestTokenUrl += "?grant_type=authorization_code";
			 requestTokenUrl += "&client_id=restclient";
			 requestTokenUrl += "&redirect_uri=" + request.getRequestURL().toString();
			 requestTokenUrl += "&code=" + request.getParameter("code");

			 String getandusetokneurl = "/OAuthSample/getandusetoken";
			 getandusetokneurl += "?code=" + request.getParameter("code");
			 getandusetokneurl += "&client_id=restclient";
			 getandusetokneurl += "&redirect_uri=" + request.getRequestURL().toString();
			 getandusetokneurl += "&acceptorurl=" + acceptorUrl;
			 
			 if (!showtokenrequestpage)
			 {
				 response.sendRedirect(getandusetokneurl);
				 return;
			 }
			 
			 answer.println("<html>");
			 answer.println("Authentication successfull<br>");
			 answer.println("<br>received code: " + request.getParameter("code"));

			 answer.println("<br><br>Now you can get token with the following URL:<br> ");
			 answer.println("<a href=\"" + requestTokenUrl + "\">" + requestTokenUrl + "</a>");
			 
			 answer.println("<br><br>or <br><br><a href=\"" + getandusetokneurl + "\">Get and use token on server side</a>");
			 
			 answer.println("</html>");
		 }
	 }

	 protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException 
	 {
		 //response.getOutputStream().println("post");
	 }

 }
