function alertExceptionHandler(exception)
{
    if ((exception != null) && (exception.detailMessage != null))
        alert(exception.detailMessage);
    else
        alert("Exception: " + exception);
}

function showNodeName(fabricNode)
{
    var node = document.getElementById('node');
    node.innerHTML = fabricNode.node.name;

    var url = document.getElementById('url');
    var domain = document.getElementById('domain');
    if ((url.value == null) || (url.value.length == 0))
    {
        domain.selectedIndex = 0;

        var port = window.location.port;
        if ((port == null) || (port.length == 0))
            port = '80';
        url.value = window.location.hostname + ':' + port;
    }
    else
    {
        domain.selectedIndex = 1;
    }
}

fabricConnection = null;

function connect()
{
    var url = document.getElementById('url').value;
    var login = document.getElementById('login').value;
    var password = document.getElementById('password').value;
    fabricConnection = new HTTPFabricConnection(login, password, alertExceptionHandler, url);
    fabricConnection.open();
    fabricConnection.getModerator().getFabricNode(showNodeName);

    var factory = fabricConnection.getEventDatagramFactory();
    factory.createEvent('event.test', processEvent);

    var connectButton = document.getElementById('connect');
    if (connectButton != null)
        connectButton.disabled = true;

    var eventIdField = document.getElementById('eventId');
    if (eventIdField != null)
        eventIdField.disabled = false;

    var sendButton = document.getElementById('send');
    if (sendButton != null)
        sendButton.disabled = false;

    var recvButton = document.getElementById('recv');
    if (recvButton != null)
        recvButton.disabled = false;

    var textButton = document.getElementById('text');
    if (textButton != null)
        textButton.disabled = false;

    var subsButton = document.getElementById('subscribe');
    if (subsButton != null)
        subsButton.disabled = false;
}

var eventObject = null;

var testObject = 
{
    '@type' : 'TestData',
    firstname    : 'neeve',
    lastname     : 'tech',
    id           : '1',
    title        : 'best'
};

var testXml = '<?xml version="1.0"?>\n<TestXml>\n <name>Neeve</name>\n <surname>Tech</surname>\n <success>true</success>\n</TestXml>';

var eventCaches = {};

function processEventId()
{
    var id = document.getElementById('eventId').value;
    var factory = fabricConnection.getEventDatagramFactory();
    factory.createEvent(id, processEvent);
}

function processEvent(createdEvent)
{
    eventObject = createdEvent;
}

function raise() 
{
    var format = document.getElementById('format');
    if (format.selectedIndex == 0)
        eventObject.setData(testObject);
    else
        eventObject.setData(testXml);

    var eventId = eventObject.getEventId();
    fabricConnection.bindProducerFor(eventId);
    if (eventCaches[eventId] == null)
    {
        eventCaches[eventId] = true;
        fabricConnection.addEventCache(eventId, 5, 'LRE_DISCARD');
    }
    fabricConnection.raiseEvent(eventObject, 'INHERITED', 0);

    var console = document.getElementById('console');
    console.value = 'Event ' + eventId + ' raised';
}

function raiseText() 
{
    eventObject.setData(document.getElementById('txt').value);
    fabricConnection.bindProducerFor(eventObject.getEventId());
    fabricConnection.raiseEvent(eventObject, 'INHERITED', 0);

    var console = document.getElementById('console');
    console.value = 'Event ' + eventObject.getEventId() + ' raised';
}

function show()
{
    var console = document.getElementById('console');
    var format = document.getElementById('format');
    var str = '';
    if (format.selectedIndex == 0)
    {
        str = Utilities.encode(testObject);
        str = str.replace(/,/g, ',\n  ');
        str = str.replace(/{/g, '{\n  ');
        str = str.replace(/}/g, '\n}');
    }
    else
    {
        str = testXml;
    }
    console.value = str;
}

function recvCallback(receivedEvent)
{
    var console = document.getElementById('console');
    if ((receivedEvent == null) || (receivedEvent.data == null))
    {
        console.value = 'No events available';
        return;
    }
    var str = '';
    if (typeof (receivedEvent.data) != "string")
    {
        str = Utilities.encode(receivedEvent.data);
        str = str.replace(/,/g, ',\n  ');
        str = str.replace(/{/g, '{\n  ');
        str = str.replace(/}/g, '\n}');
    }
    else
    {
        str = receivedEvent.data;
    }
    console.value = str;
}

receiver = null;
function recv()
{
    var eventId = document.getElementById('eventId').value;
    if (receiver == null)
    {
        receiver = fabricConnection.createEventReceiver(
            'TestReceiver', eventId, null, 'INHERITED', false);
        receiver.open();
    }
    receiver.receiveNoWait(recvCallback);
}

function onMessage(receivedEvent)
{
    var console = document.getElementById('console');
    if ((receivedEvent == null) || (receivedEvent.data == null))
        return;

    var str = '';
    if (typeof (receivedEvent.data) != "string")
    {
        str = Utilities.encode(receivedEvent.data);
        str = str.replace(/,/g, ',\n  ');
        str = str.replace(/{/g, '{\n  ');
        str = str.replace(/}/g, '\n}');
    }
    else
    {
        str = receivedEvent.data;
    }

    console.value = console.value + str + '\n---------------------------------------\n';
}

function subscribe()
{
    var eventId = document.getElementById('eventId').value;
    var name = 'Consumer_' + eventId;
    if (fabricConnection.getEventAsyncConsumer(name) == null)
    {
        var listener = new EventListener(onMessage);
        var consumer = fabricConnection.createEventAsyncConsumer(
            name, listener, eventId, null, 'INHERITED', false);
        consumer.start();
    }
    else
    {
        alert('Already subscribed to ' + eventId);
    }
}

