package simple;

import com.streamscape.Trace;
import com.streamscape.cli.ClientContext;
import com.streamscape.cli.tlp.FabricConnection;
import com.streamscape.cli.tlp.FabricConnectionFactory;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.event.DataEvent;
import com.streamscape.sef.FabricEventListener;
import com.streamscape.sef.enums.EventScope;

/**
 * <p>Title: Java Samples</p>
 *
 * <p>Description: This <i>ClientConsumer</i> sample connects to the node and consumes events.
 * Another <i>ClientProducer</i> sample raises event.  
 * See READ.ME to know how run and use this sample. 
 *  
 * <p>Copyright: Copyright (c) 2015</p>
 *
 * <p>Company: StreamScape Technologies</p>
 *
 * @author Nikita Kutuzov
 * @version 3.4
 */
 public class ClientConsumer    
 {
    static ClientContext    context;
    static FabricConnection connection;
    
    static final String     dataEventId       = "event.data.employee.sample";
    
    static String nodeAddress = "tlp://localhost:5000";
    static String username    = "user1";
    static String password    = "123";
    
    public static void main(String[] args)
    {
       try
       {
          parseArguments(args);
          
          // Enables some traces.
          Trace.enable("com.streamscape.cli.*", Trace.Level.INFO);
          Trace.enable("events.*",              Trace.Level.ERROR);
          
          // Initializes the Client Context.
          context = ClientContext.getInstance();
          
          // connecting to the node
          System.out.print("Connecting to the node at " + nodeAddress + " using credentials " + username + "/" + password + "...");
          connection = new FabricConnectionFactory(nodeAddress).createConnection(username, password);
          connection.setName("ClientConnectionForConsume");
          connection.open();
          System.out.println(" Connected.");
          
          // import event prototype, semantic type will be imported as well
          connection.importEventPrototype(dataEventId);

          // create consumer
          System.out.println(" Listening for events with id [" + dataEventId + "] ...");
          connection.createEventConsumer("SimpleDataEventConsumer", new SimpleDataEventConsumer(), dataEventId, null, EventScope.GLOBAL, true);
       }
       catch (Exception exception)
       {
          exception.printStackTrace();
          System.exit(1);
       }
    }
    
    static class SimpleDataEventConsumer implements FabricEventListener
    {
       public void onEvent(ImmutableEventDatagram event)
       {
          System.out.println("  Data event [" + event.getEventId() + "] received.");
          try
          {
             Object data = ((DataEvent)event).getData();
             if (data != null)
             {
                System.out.println("    data : (" + data.getClass().getMethod("getId").invoke(data) + "," +
                                                  data.getClass().getMethod("getName").invoke(data) + ")");
             }
             else
                System.out.println("    data : null.");
              
          }
          catch (Exception e)
          {
             e.printStackTrace();
          }
       }
    }
    
    private static void parseArguments(String []args) throws Exception
    {
       for (int i = 0; i < args.length; i++)
       {
          String name = args[i++];
          if (i >= args.length)
             throw new Exception("Missing value for argument " + name + ".");
          String value = args[i];
          if (name.equals("-a"))
             nodeAddress = value;
          else if (name.equals("-u"))
             username = value;
          else if (name.equals("-p"))
             password = value;
          else
             throw new Exception("Unknown argument " + name + " specified.");
       }
    }
    
 }
