package service.accessor;

import com.streamscape.Trace;
import com.streamscape.omf.xml.XSerializer;
import com.streamscape.omf.xml.XSerializerFactory;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationFactory;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationObject;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sdo.event.TextEvent;
import com.streamscape.sdo.mf.admin.DatagramPrototypeFactory;
import com.streamscape.sef.ConfigurationProperty;
import com.streamscape.sef.FabricComponentProperties;
import com.streamscape.sef.enums.ComponentState;
import com.streamscape.sef.network.tlp.acceptor.TLPAcceptor;
import com.streamscape.sef.service.ServiceDescriptor;
import com.streamscape.sef.service.ServiceManager;
import com.streamscape.sef.utils.Utils;
import com.streamscape.service.osf.enums.InvokeMode;
import com.streamscape.service.osf.evh.EventHandler;

import java.io.File;
import java.io.FileOutputStream;

/**
 * <p>Title: Java Samples</p>
 *
 * <p>Description: Second node of the 'service/accessor' sample.
 *
 * <p>This <code>Sample.Node2</code> node contains a second version of the <code>SampleService.Default</code> service.
 *
 * <p>Copyright: Copyright (c) 2014</p>
 *
 * <p>Company: StreamScape Technologies</p>
 *
 * @author Mikhail Filichev
 * @version 3.4
 */
 public class Node2
 {
    private static RuntimeContext context;

    private static final String REQUEST_EVENT_ID = "event.request";
    private static final String REPLY_EVENT_ID   = "event.reply";

    public static void main(String[] args)
    {
       try
       {
          // This auxiliary method is required only for automatic creation of TLP acceptor with non-default port (to avoid a manual change).
          prepareRepository();

          // Enables some traces.
          Trace.enable("*",                         Trace.Level.ERROR);
          Trace.enable("com.streamscape.runtime.*", Trace.Level.INFO);

          // Sets a startup directory of the Runtime.
          System.setProperty(RuntimeContext.STARTUP_DIR, "Sample.Node2");
          // Sets a path to the directory containing a deployment descriptor archive (stdeploy.jar).
          System.setProperty(RuntimeContext.DEPLOYMENT, "Sample.Node2");
          // Sets a path to the to file containing discovery rules for the Fabric.
          System.setProperty(RuntimeContext.DISCOVERY_FABRIC_DIRECTORY, System.getProperty(RuntimeContext.STARTUP_DIR) + "/../DirectoryTable.xdo");

          // Initializes the Runtime Context.
          context = RuntimeContext.getInstance();

          System.out.println("Add event prototypes...\n");
          addPrototypes();

          System.out.println("Setup service...\n");
          setUpSampleService(); // It is just an auxiliary method.
       }
       catch (Exception exception)
       {
          exception.printStackTrace();
          System.exit(1);
       }
    }

    private static void addPrototypes() throws Exception
    {
       DatagramPrototypeFactory prototypeFactory = context.getDatagramPrototypeFactory();
       if (!prototypeFactory.existsPrototype(REQUEST_EVENT_ID))
       {
          TextEvent prototype = (TextEvent)EventDatagramFactory.getInstance().newEventInstance("TextEvent");
          prototype.setEventStringProperty("version", "");
          prototypeFactory.addEventPrototype(REQUEST_EVENT_ID, prototype);
       }
       if (!prototypeFactory.existsPrototype(REPLY_EVENT_ID))
          prototypeFactory.addEventPrototype("TextEvent", REPLY_EVENT_ID);
    }

    private static final String SERVICE_TYPE      = "SampleService";
    private static final String SERVICE_NAME      = "Default";
    private static final String SERVICE_FULL_NAME = SERVICE_TYPE + "." + SERVICE_NAME;

    private static void setUpSampleService() throws Exception
    {
       ServiceManager serviceManager = context.getServiceManager();

       if (!serviceManager.isServiceRegistered(SERVICE_FULL_NAME))
       {
          ServiceConfigurationObject sco = ServiceConfigurationFactory.createServiceConfiguration(context, SERVICE_NAME, SERVICE_TYPE, false);

          sco.setServiceClassName(Service2.class.getName());
          sco.setInvokeMode(InvokeMode.ASYNC);

          ConfigurationProperty property = sco.createAdvancedProperty(FabricComponentProperties.TLP_EVENT_SCOPE, "", "");
          property.setTextValue("global");
          sco.addAdvancedProperty(property);

          EventHandler handler = new EventHandler(sco, "onRequest", "RequestHandler");
          handler.bindRequestObject (REQUEST_EVENT_ID, "string");
          handler.bindResponseObject(REPLY_EVENT_ID,   "string");
          handler.setRequestSelector("version = '2.0'");
          sco.addEventHandler(handler);

          ServiceConfigurationFactory.saveConfigurationObject(sco);

          ServiceDescriptor service = new ServiceDescriptor(SERVICE_TYPE, SERVICE_NAME);
          serviceManager.registerService(service);
          serviceManager.runServiceAs(SERVICE_FULL_NAME, "user1", "123");
       }

       if (serviceManager.getServiceState(SERVICE_FULL_NAME) != ComponentState.STARTED)
          serviceManager.startService(SERVICE_FULL_NAME);
    }

    private static void prepareRepository() throws Exception
    {
       File nodeDir = new File("Sample.Node2");
       XSerializer serializer = XSerializerFactory.getInstance().getDefaultSerializer();

       createAcceptor(nodeDir, serializer);

       XSerializerFactory.getInstance().destroy();
    }

    private static void createAcceptor(File nodeDir, XSerializer serializer) throws Exception
    {
       TLPAcceptor acceptor = new TLPAcceptor("Default");
       acceptor.setURL("tlp://127.0.0.1:5001");

       byte[] bytes = serializer.serialize(acceptor).getBytes();
       FileOutputStream stream = new FileOutputStream(new File(Utils.createDirectory(new File(nodeDir, ".tfcache/objects/sys/network/acceptors/tlp")),
                                                               "TLPAcceptor.Default.xdo"));
       stream.write(bytes);
       stream.close();
    }
 }
