package jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sdo.rowset.RowSetFactory;
import com.streamscape.sdo.rowset.RowSetPrinter;

/**
 * <p>Title: Java Samples</p>
 *
 * <p>Description: JDBC Driver sample.
 * 
 * <p>This sample shows how to use reconnection parameters.
 * 
 * <p>Copyright: Copyright (c) 2014</p>
 *
 * <p>Company: StreamScape Technologies</p>
 *
 * @author Nikita Kutuzov
 * @version 3.4
 */
 public class JDBCDriverSample
 {
    public static void main(String[] args) throws Exception
    {
       try
       {
          System.out.println("Assume you have two nodes joined to sysplex:");
          System.out.println("   TestNode1 tlp://localhost:5501");
          System.out.println("   TestNode2 tlp://localhost:5502");
          System.out.println("Dataspace TSPACE.TEST_DATASPACE with event scope GLOBAL is created on node TestNode1.\n");
          System.out.println("We will connect to dataspace TSPACE.TEST_DATASPACE thu node TestNode2");
          System.out.println("execute some queries, restart TestNode1 and execute queries again.\n");

          System.out.println("Please start nodes TestNode1,TestNode2, create TSPACE.TEST_DATASPACE on node TestNode1 and make sure that nodes joined to sysplex. Press enter.");
          System.out.println("Command to create dataspace: 'create dataspace TEST_DATASPACE type TSPACE event scope GLOBAL'");
          System.out.println("Press enter.");
          System.in.read();

          String url = "jdbc:streamscape:dataspace://localhost:5502/TSPACE.TEST_DATASPACE;reconnectAttempts=-1;reconnectInterval=1;nodeName=TestNode1";
          System.out.println("Connecting to TSPACE.TEST_DATASPACE with url");
          System.out.println("   " + url);
          
          Class.forName("com.streamscape.ds.jdbc.JDBCDriver");
          Connection jdbcConnection = DriverManager.getConnection(url, "Admin", "Admin");
          
          System.out.println("  OK\n");

          executeQuery(jdbcConnection, "drop table test_table if exists");
          executeQuery(jdbcConnection, "create table test_table (i int)");
          executeQuery(jdbcConnection, "insert into test_table values(1)");
          executeQuery(jdbcConnection, "select * from test_table");
          
          System.out.println("\nPlease stop node TestNode2 and press enter");
          System.in.read();
          executeQuery(jdbcConnection, "select * from test_table");

          System.out.println("\nPlease start node TestNode2 and make sure that nodes joined to sysplex and press enter");
          System.in.read();
          executeQuery(jdbcConnection, "select * from test_table");
          
          System.out.println("\nPlease stop node TestNode1 and press enter");
          System.in.read();
          executeQuery(jdbcConnection, "select * from test_table");
          
          jdbcConnection.close();
       }
       catch (Exception e)
       {
          System.out.println("Error: " + e.getMessage());
       }
    }
    
    private static void executeQuery(Connection jdbcConnection, String query) throws SQLException
    {
       System.out.print("Executing query: " + query);
       Statement statement = null;
       try
       {
          statement = jdbcConnection.createStatement();
          if (statement.execute(query))
          {
             System.out.println();
             ResultSet resultSet = statement.getResultSet();
             RowSet rowSet = new RowSetFactory().createRowSet(resultSet);
             new RowSetPrinter().print(rowSet);
          }
          else
             System.out.println("  OK");
       } 
       catch (SQLException e)
       {
          System.out.println("\n Error: " + e.getMessage());
          
       }
       finally
       {
          if (statement != null)
             statement.close();
       }
    }
 }
