<?xml version="1.0"?>
<ServiceConfiguration>
  <serviceType>WebServiceRequest</serviceType>
  <serviceName>prototype</serviceName>
  <serviceDisplayName>Web Service Request</serviceDisplayName>
  <serviceDesc>Allows to invoke Web Service using provided SOAP envelop body.</serviceDesc>
  <serviceClass>com.streamscape.service.ws.evSink.WebServiceInvoker</serviceClass>
  <eimPlugin></eimPlugin>
  <validatorClass>com.streamscape.service.ui.validators.DefaultValidator</validatorClass>
  <invokeMode>ASYNC</invokeMode>
  <daemonService>false</daemonService>
  <interruptable>false</interruptable>
  <propertiesRegistry>
    <propertiesTable>
      <entry>
        <string>web.service.url</string>
        <Property>
          <propertyName>web.service.url</propertyName>
          <labelName>Web Service URL</labelName>
          <propertyDescription>Specifies URL where Web Service is located.</propertyDescription>
          <propertyGroup>main.group</propertyGroup>
          <dataType>STRING</dataType>
          <isRequired>false</isRequired>
          <rangeList></rangeList>
          <propertyValue SemanticType="string"></propertyValue>
          <isExportable>true</isExportable>
        </Property>
      </entry>
      <entry>
        <string>soap.version.2.0</string>
        <Property>
          <propertyName>soap.version.2.0</propertyName>
          <labelName>SOAP 2.0</labelName>
          <propertyDescription>Specifies which version of SOAP protocol should be used 2.0 or 1.1.</propertyDescription>
          <propertyGroup>main.group</propertyGroup>
          <dataType>BOOLEAN</dataType>
          <isRequired>false</isRequired>
          <rangeList></rangeList>
          <propertyValue SemanticType="boolean">true</propertyValue>
          <isExportable>true</isExportable>
        </Property>
      </entry>
      <entry>
        <string>plain.passwd.auth</string>
        <Property>
          <propertyName>plain.passwd.auth</propertyName>
          <labelName>Plain Password Authentication</labelName>
          <propertyDescription>Specifies whether web service requires plain password authentication.</propertyDescription>
          <propertyGroup>main.group</propertyGroup>
          <dataType>BOOLEAN</dataType>
          <isRequired>false</isRequired>
          <rangeList></rangeList>
          <propertyValue SemanticType="boolean">false</propertyValue>
          <isExportable>true</isExportable>
        </Property>
      </entry>
      <entry>
        <string>web.service.user</string>
        <Property>
          <propertyName>web.service.user</propertyName>
          <labelName>Web Service User</labelName>
          <propertyDescription>Specifies username for plain password authorization.</propertyDescription>
          <propertyGroup>main.group</propertyGroup>
          <dataType>STRING</dataType>
          <isRequired>false</isRequired>
          <rangeList></rangeList>
          <propertyValue SemanticType="string"></propertyValue>
          <isExportable>true</isExportable>
        </Property>
      </entry>
      <entry>
        <string>web.service.passwd</string>
        <Property>
          <propertyName>web.service.passwd</propertyName>
          <labelName>Web Service Password</labelName>
          <propertyDescription>Specifies password for plain password authorization.</propertyDescription>
          <propertyGroup>main.group</propertyGroup>
          <dataType>PASSWORD</dataType>
          <isRequired>false</isRequired>
          <rangeList></rangeList>
          <propertyValue SemanticType="Value.PASSWORD">
            <passwordProperty>UGFzc3dvcmQgZ29lcyBoZXJl</passwordProperty>
          </propertyValue>
          <isExportable>true</isExportable>
        </Property>
      </entry>
    </propertiesTable>
    <propertyGroups>
      <string>main.group</string>
    </propertyGroups>
  </propertiesRegistry>
  <advancedPropertiesRegistry>
    <advancedPropertiesTable>
      <entry>
        <string>tlpSessionFlushDelay</string>
        <Property.ADVANCED>
          <name>tlpSessionFlushDelay</name>
          <value SemanticType="long">2</value>
          <label>Session Flush Delay</label>
          <description>Specifies in milliseconds the session&apos;s event flush delay. Defaults to 2 milliseconds.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>tlpLinkSolicitAllow</string>
        <Property.ADVANCED>
          <name>tlpLinkSolicitAllow</name>
          <value SemanticType="boolean">false</value>
          <label>Allow Dynamic Link Soliciting</label>
          <description>When enabled, allows components to dynamically register links when solicited.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>enableServiceStats</string>
        <Property.ADVANCED>
          <name>enableServiceStats</name>
          <value SemanticType="boolean">false</value>
          <label>Enable Service Stats</label>
          <description>Enables statistics collecting for service, such as method execution time.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>tlpSessionExchangeMode</string>
        <Property.ADVANCED>
          <name>tlpSessionExchangeMode</name>
          <value SemanticType="string">optimistic</value>
          <label>Session Exchange Mode</label>
          <description>The datagram exchange mode of a session (&apos;optimistic&apos;, &apos;adaptive&apos;, &apos;sync&apos;, &apos;sequenced&apos;).</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>producerMfLeaseInterval</string>
        <Property.ADVANCED>
          <name>producerMfLeaseInterval</name>
          <value SemanticType="long">360000</value>
          <label>Producer Lease Interval</label>
          <description>For event producers, the interval at which the moderator statistics lease is renewed (defaults to 1 hour).</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>consumerAsyncQueueMaxDepth</string>
        <Property.ADVANCED>
          <name>consumerAsyncQueueMaxDepth</name>
          <value SemanticType="long">10000</value>
          <label>Async Event Queue Depth</label>
          <description>For async listeners, the depth of the event delivery queue (defaults to 10000).</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>daemonServiceMaxWorkTime</string>
        <Property.ADVANCED>
          <name>daemonServiceMaxWorkTime</name>
          <value SemanticType="long">3600</value>
          <label>Daemon Service Max Work Time</label>
          <description>This timeout in seconds is used by Service Watcher thread to check if the service is alive and doesn&apos;t hang.
Default max work time is 3600 seconds(60 minutes). Max time for one service iterations is a sum of passive iteration
interval and max work time.Check is performed every 30 seconds. [advisory.service.blocked] advisory is sent every 5 minutes.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>consumerAsyncSpinWait</string>
        <Property.ADVANCED>
          <name>consumerAsyncSpinWait</name>
          <value SemanticType="long">3</value>
          <label>Async Event Delivery Interval</label>
          <description>For async listeners, the milliseconds a delivery thread waits between scheduled spins.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>serviceStopTimeout</string>
        <Property.ADVANCED>
          <name>serviceStopTimeout</name>
          <value SemanticType="long">15</value>
          <label>Service Stop Timeout</label>
          <description>Specifies the wait time (in seconds) for completion of pending operations during service stopping. Non-positive value means that service will not wait for completion of pending operations. Default is 15 seconds.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>tlpForceConnection</string>
        <Property.ADVANCED>
          <name>tlpForceConnection</name>
          <value SemanticType="boolean">false</value>
          <label>Force New Connection</label>
          <description>When true, this component will form a new socket connection to it&apos;s peer.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>exceptionSuppressStacktrace</string>
        <Property.ADVANCED>
          <name>exceptionSuppressStacktrace</name>
          <value SemanticType="boolean">true</value>
          <label>Suppress Exception Stack Trace</label>
          <description>Removes stack trace from exceptions thrown by Service methods invoked via Accessor (defaults to false).</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>servicePoolSize</string>
        <Property.ADVANCED>
          <name>servicePoolSize</name>
          <value SemanticType="long">1</value>
          <label>Service Pool Size</label>
          <description>Specifies service pool size in the service component.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>consumerAsyncDeliveryMode</string>
        <Property.ADVANCED>
          <name>consumerAsyncDeliveryMode</name>
          <value SemanticType="string">async</value>
          <label>Async Event Delivery Mode</label>
          <description>For async listeners, the mode of event delivery (&apos;async&apos; or &apos;async_paced&apos;).</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>consumerAsyncQueueFlowcontrol</string>
        <Property.ADVANCED>
          <name>consumerAsyncQueueFlowcontrol</name>
          <value SemanticType="string">exception</value>
          <label>Async Flow Control Mode</label>
          <description>For async listeners, the flow control mode (&apos;notify&apos; or &apos;exception&apos;).</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>tlpEventScope</string>
        <Property.ADVANCED>
          <name>tlpEventScope</name>
          <value SemanticType="string">observable</value>
          <label>Component Event Scope</label>
          <description>The visibility scope of events for this component (&apos;local&apos;, &apos;observable&apos;, &apos;global&apos;, &apos;clustered&apos;).</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>tlpLinkMaxSessions</string>
        <Property.ADVANCED>
          <name>tlpLinkMaxSessions</name>
          <value SemanticType="long">20</value>
          <label>Maximum Link Sessions</label>
          <description>Sets the number of concurrent link sessions this component may have.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>componentRefNamespace</string>
        <Property.ADVANCED>
          <name>componentRefNamespace</name>
          <value SemanticType="string">/service</value>
          <label>Reference Context Namespace</label>
          <description>Specifies a Namespace (ie. /service/db) in the repository where the component may store supporting objects.</description>
        </Property.ADVANCED>
      </entry>
    </advancedPropertiesTable>
  </advancedPropertiesRegistry>
  <metricsRegistry>
    <metricsTable/>
  </metricsRegistry>
  <advisoriesRegistry>
    <stateAdvisoriesTable/>
    <advisoriesTable>
      <string>advisory.component.StateChange</string>
    </advisoriesTable>
  </advisoriesRegistry>
  <actionableEventsRegistry>
    <actionableEventsTable>
      <string>event.soap.reply</string>
    </actionableEventsTable>
  </actionableEventsRegistry>
  <eventHandlersRegistry>
    <handlersTable>
      <entry>
        <string>WebServiceInvokeHandler</string>
        <Handler.EVENT>
          <methodName>invokeWebService</methodName>
          <handlerName>WebServiceInvokeHandler</handlerName>
          <requestEventId>event.soap.request</requestEventId>
          <requestSemanticType>XMLEvent</requestSemanticType>
          <responseEventId>event.soap.reply</responseEventId>
          <responseSemanticType>XMLEvent</responseSemanticType>
          <invokeMode>ASYNC</invokeMode>
          <timeout>0</timeout>
        </Handler.EVENT>
      </entry>
    </handlersTable>
  </eventHandlersRegistry>
  <exceptionsRegistry>
    <exceptionsTable>
      <string>exception.service.Framework</string>
      <string>exception.ws.SoapRequest</string>
      <string>exception.ws.SoapFault</string>
    </exceptionsTable>
  </exceptionsRegistry>
  <configTimeStamp>1535704533339</configTimeStamp>
  <eventTriggersRegistry>
    <triggers/>
  </eventTriggersRegistry>
</ServiceConfiguration>