<?xml version="1.0"?>
<ServiceConfiguration>
  <serviceType>EventCorrelator</serviceType>
  <serviceName>prototype</serviceName>
  <serviceDisplayName>Event Correlation Service</serviceDisplayName>
  <serviceDesc>Performs event correlation.</serviceDesc>
  <serviceClass>com.streamscape.service.correlator.evSink.EventCorrelator</serviceClass>
  <eimPlugin></eimPlugin>
  <validatorClass>com.streamscape.service.ui.validators.DefaultValidator</validatorClass>
  <invokeMode>DIRECT</invokeMode>
  <daemonService>false</daemonService>
  <interruptable>true</interruptable>
  <propertiesRegistry>
    <propertiesTable>
      <entry>
        <string>exceptions</string>
        <Property>
          <propertyName>exceptions</propertyName>
          <labelName>Exceptions List</labelName>
          <propertyDescription>Specifies list of exceptions which can cancel current correlation.</propertyDescription>
          <propertyGroup>main.group</propertyGroup>
          <dataType>LIST</dataType>
          <isRequired>false</isRequired>
          <rangeList></rangeList>
          <propertyValue SemanticType="list">
            <Property>
              <propertyName>exception</propertyName>
              <labelName></labelName>
              <propertyDescription></propertyDescription>
              <propertyGroup>main.group</propertyGroup>
              <dataType>STRING</dataType>
              <isRequired>false</isRequired>
              <rangeList></rangeList>
              <propertyValue SemanticType="string">exception.test1</propertyValue>
              <isExportable>true</isExportable>
            </Property>
          </propertyValue>
          <isExportable>true</isExportable>
        </Property>
      </entry>
      <entry>
        <string>events</string>
        <Property>
          <propertyName>events</propertyName>
          <labelName>Event List</labelName>
          <propertyDescription>Specifies list of event IDs which need to be matched (with optional selector).</propertyDescription>
          <propertyGroup>main.group</propertyGroup>
          <dataType>LIST</dataType>
          <isRequired>false</isRequired>
          <rangeList></rangeList>
          <propertyValue SemanticType="list">
            <Property>
              <propertyName>event</propertyName>
              <labelName></labelName>
              <propertyDescription></propertyDescription>
              <propertyGroup>main.group</propertyGroup>
              <dataType>STRING</dataType>
              <isRequired>false</isRequired>
              <rangeList></rangeList>
              <propertyValue SemanticType="string">event.test1</propertyValue>
              <isExportable>true</isExportable>
            </Property>
            <Property>
              <propertyName>event</propertyName>
              <labelName></labelName>
              <propertyDescription></propertyDescription>
              <propertyGroup>main.group</propertyGroup>
              <dataType>STRING</dataType>
              <isRequired>false</isRequired>
              <rangeList></rangeList>
              <propertyValue SemanticType="string">event.test2</propertyValue>
              <isExportable>true</isExportable>
            </Property>
            <Property>
              <propertyName>event</propertyName>
              <labelName></labelName>
              <propertyDescription></propertyDescription>
              <propertyGroup>main.group</propertyGroup>
              <dataType>STRING</dataType>
              <isRequired>false</isRequired>
              <rangeList></rangeList>
              <propertyValue SemanticType="string">event.test3</propertyValue>
              <isExportable>true</isExportable>
            </Property>
          </propertyValue>
          <isExportable>true</isExportable>
        </Property>
      </entry>
      <entry>
        <string>matching.strategy</string>
        <Property>
          <propertyName>matching.strategy</propertyName>
          <labelName>Matching Strategy</labelName>
          <propertyDescription>Specifies the strategy for event matching.</propertyDescription>
          <propertyGroup>main.group</propertyGroup>
          <dataType>ENUMERATION</dataType>
          <isRequired>false</isRequired>
          <rangeList>INFINITE_WAIT,REPEATING_TIMER,TRIGGERED_TIMER</rangeList>
          <propertyValue SemanticType="string">TRIGGERED_TIMER</propertyValue>
          <isExportable>true</isExportable>
        </Property>
      </entry>
      <entry>
        <string>matching.rules</string>
        <Property>
          <propertyName>matching.rules</propertyName>
          <labelName>Matching Rule List</labelName>
          <propertyDescription>Specifies list matching rules which need to be applied for correlating events.</propertyDescription>
          <propertyGroup>main.group</propertyGroup>
          <dataType>LIST</dataType>
          <isRequired>false</isRequired>
          <rangeList></rangeList>
          <propertyValue SemanticType="list">
            <Property>
              <propertyName>matching.rule</propertyName>
              <labelName></labelName>
              <propertyDescription></propertyDescription>
              <propertyGroup>main.group</propertyGroup>
              <dataType>STRING</dataType>
              <isRequired>false</isRequired>
              <rangeList></rangeList>
              <propertyValue SemanticType="string">match on property (StringProperty)</propertyValue>
              <isExportable>true</isExportable>
            </Property>
            <Property>
              <propertyName>matching.rule</propertyName>
              <labelName></labelName>
              <propertyDescription></propertyDescription>
              <propertyGroup>main.group</propertyGroup>
              <dataType>STRING</dataType>
              <isRequired>false</isRequired>
              <rangeList></rangeList>
              <propertyValue SemanticType="string">match on property (StringProperty == &apos;TestValue&apos;)</propertyValue>
              <isExportable>true</isExportable>
            </Property>
            <Property>
              <propertyName>matching.rule</propertyName>
              <labelName></labelName>
              <propertyDescription></propertyDescription>
              <propertyGroup>main.group</propertyGroup>
              <dataType>STRING</dataType>
              <isRequired>false</isRequired>
              <rangeList></rangeList>
              <propertyValue SemanticType="string">match on property (LongProperty == 123)</propertyValue>
              <isExportable>true</isExportable>
            </Property>
            <Property>
              <propertyName>matching.rule</propertyName>
              <labelName></labelName>
              <propertyDescription></propertyDescription>
              <propertyGroup>main.group</propertyGroup>
              <dataType>STRING</dataType>
              <isRequired>false</isRequired>
              <rangeList></rangeList>
              <propertyValue SemanticType="string">match on (event.test1.LongProperty == 123)</propertyValue>
              <isExportable>true</isExportable>
            </Property>
            <Property>
              <propertyName>matching.rule</propertyName>
              <labelName></labelName>
              <propertyDescription></propertyDescription>
              <propertyGroup>main.group</propertyGroup>
              <dataType>STRING</dataType>
              <isRequired>false</isRequired>
              <rangeList></rangeList>
              <propertyValue SemanticType="string">match on (event.test1.FloatProperty == event.test3.FloatProperty)</propertyValue>
              <isExportable>true</isExportable>
            </Property>
          </propertyValue>
          <isExportable>true</isExportable>
        </Property>
      </entry>
      <entry>
        <string>timeout</string>
        <Property>
          <propertyName>timeout</propertyName>
          <labelName>Matching Interval</labelName>
          <propertyDescription>Specifies an interval in millis within all events should come in.</propertyDescription>
          <propertyGroup>main.group</propertyGroup>
          <dataType>NUMERIC</dataType>
          <isRequired>false</isRequired>
          <rangeList></rangeList>
          <propertyValue SemanticType="long">1000</propertyValue>
          <isExportable>true</isExportable>
        </Property>
      </entry>
    </propertiesTable>
    <propertyGroups>
      <string>main.group</string>
    </propertyGroups>
  </propertiesRegistry>
  <advancedPropertiesRegistry>
    <advancedPropertiesTable>
      <entry>
        <string>tlpSessionFlushDelay</string>
        <Property.ADVANCED>
          <name>tlpSessionFlushDelay</name>
          <value SemanticType="long">2</value>
          <label>Session Flush Delay</label>
          <description>Specifies in milliseconds the session&apos;s event flush delay. Defaults to 2 milliseconds.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>tlpLinkSolicitAllow</string>
        <Property.ADVANCED>
          <name>tlpLinkSolicitAllow</name>
          <value SemanticType="boolean">false</value>
          <label>Allow Dynamic Link Soliciting</label>
          <description>When enabled, allows components to dynamically register links when solicited.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>enableServiceStats</string>
        <Property.ADVANCED>
          <name>enableServiceStats</name>
          <value SemanticType="boolean">false</value>
          <label>Enable Service Stats</label>
          <description>Enables statistics collecting for service, such as method execution time.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>tlpSessionExchangeMode</string>
        <Property.ADVANCED>
          <name>tlpSessionExchangeMode</name>
          <value SemanticType="string">optimistic</value>
          <label>Session Exchange Mode</label>
          <description>The datagram exchange mode of a session (&apos;optimistic&apos;, &apos;adaptive&apos;, &apos;sync&apos;, &apos;sequenced&apos;).</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>producerMfLeaseInterval</string>
        <Property.ADVANCED>
          <name>producerMfLeaseInterval</name>
          <value SemanticType="long">360000</value>
          <label>Producer Lease Interval</label>
          <description>For event producers, the interval at which the moderator statistics lease is renewed (defaults to 1 hour).</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>daemonServiceMaxWorkTime</string>
        <Property.ADVANCED>
          <name>daemonServiceMaxWorkTime</name>
          <value SemanticType="long">3600</value>
          <label>Daemon Service Max Work Time</label>
          <description>This timeout in seconds is used by Service Watcher thread to check if the service is alive and doesn&apos;t hang.
Default max work time is 3600 seconds(60 minutes). Max time for one service iterations is a sum of passive iteration
interval and max work time.Check is performed every 30 seconds. [advisory.service.blocked] advisory is sent every 5 minutes.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>serviceStopTimeout</string>
        <Property.ADVANCED>
          <name>serviceStopTimeout</name>
          <value SemanticType="long">15</value>
          <label>Service Stop Timeout</label>
          <description>Specifies the wait time (in seconds) for completion of pending operations during service stopping. Non-positive value means that service will not wait for completion of pending operations. Default is 15 seconds.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>tlpForceConnection</string>
        <Property.ADVANCED>
          <name>tlpForceConnection</name>
          <value SemanticType="boolean">false</value>
          <label>Force New Connection</label>
          <description>When true, this component will form a new socket connection to it&apos;s peer.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>exceptionSuppressStacktrace</string>
        <Property.ADVANCED>
          <name>exceptionSuppressStacktrace</name>
          <value SemanticType="boolean">true</value>
          <label>Suppress Exception Stack Trace</label>
          <description>Removes stack trace from exceptions thrown by Service methods invoked via Accessor (defaults to false).</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>servicePoolSize</string>
        <Property.ADVANCED>
          <name>servicePoolSize</name>
          <value SemanticType="long">1</value>
          <label>Service Pool Size</label>
          <description>Specifies service pool size in the service component.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>tlpEventScope</string>
        <Property.ADVANCED>
          <name>tlpEventScope</name>
          <value SemanticType="string">observable</value>
          <label>Component Event Scope</label>
          <description>The visibility scope of events for this component (&apos;local&apos;, &apos;observable&apos;, &apos;global&apos;, &apos;clustered&apos;).</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>tlpLinkMaxSessions</string>
        <Property.ADVANCED>
          <name>tlpLinkMaxSessions</name>
          <value SemanticType="long">20</value>
          <label>Maximum Link Sessions</label>
          <description>Sets the number of concurrent link sessions this component may have.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>componentRefNamespace</string>
        <Property.ADVANCED>
          <name>componentRefNamespace</name>
          <value SemanticType="string">/service</value>
          <label>Reference Context Namespace</label>
          <description>Specifies a Namespace (ie. /service/db) in the repository where the component may store supporting objects.</description>
        </Property.ADVANCED>
      </entry>
    </advancedPropertiesTable>
  </advancedPropertiesRegistry>
  <metricsRegistry>
    <metricsTable/>
  </metricsRegistry>
  <advisoriesRegistry>
    <stateAdvisoriesTable>
      <entry>
        <string>Cancel</string>
        <ADVISORY>
          <advisoryName>Cancel</advisoryName>
          <advisoryType>WARNING</advisoryType>
          <advisoryDescription></advisoryDescription>
          <advisoryProperties/>
        </ADVISORY>
      </entry>
    </stateAdvisoriesTable>
    <advisoriesTable>
      <string>advisory.component.StateChange</string>
    </advisoriesTable>
  </advisoriesRegistry>
  <actionableEventsRegistry>
    <actionableEventsTable>
      <string>event.Correlator</string>
    </actionableEventsTable>
  </actionableEventsRegistry>
  <eventHandlersRegistry>
    <handlersTable/>
  </eventHandlersRegistry>
  <exceptionsRegistry>
    <exceptionsTable>
      <string>exception.service.Framework</string>
    </exceptionsTable>
  </exceptionsRegistry>
  <configTimeStamp>1535704533385</configTimeStamp>
  <eventTriggersRegistry>
    <triggers/>
  </eventTriggersRegistry>
</ServiceConfiguration>