from __future__ import absolute_import

from .http_fabric_exception import HTTPFabricException


class AccessibleObjectProxy(object):
    TOP_ACCESSOR_ID = 0
    SLDataspaceCallEventId = "e.sys.sl.DataspaceCall"

    def getId(self):
        raise Exception("Not implemented.")

    def setId(self, id):
        raise Exception("Not implemented.")

    def setAccessor(self, accessor):
        raise Exception("Not implemented.")

    def _slDataspaceCall(self, id, method, params):
        return {
            "@type": "SLDataspaceCall",
            "objectId": id,
            "method": method,
            "params": params
        }


class AbstractAccessibleObjectProxy(AccessibleObjectProxy):
    def __init__(self):
        self._oid = 0
        self._accessor = None

    def getId(self):
        return self._oid

    def setId(self, id):
        self._oid = id

    def setAccessor(self, accessor):
        self._accessor = accessor

    def invokeMethod(self, method, params):
        call = self._slDataspaceCall(self._oid, method, params)
        response = self.invokeRequest(self.SLDataspaceCallEventId, call)
        if not response.isOK:
            if response.exception != None:
                raise HTTPFabricException(response.exception)
            elif response.text:
                raise HTTPFabricException(response.text)
            else:
                raise HTTPFabricException("Error response received.")

    def invokeMethodWithReturn(self, method, params=[]):
        call = self._slDataspaceCall(self._oid, method, params)
        response = self.invokeRequest(self.SLDataspaceCallEventId, call)
        if not response.isOK:
            if response.exception != None:
                raise HTTPFabricException(response.exception.get('detailMessage', None), response.exception)
            elif response.text:
                raise HTTPFabricException(response.text)
            else:
                raise HTTPFabricException("Error response received.")
        else:
            result = response.object
            # try:
            #     if (result instanceof AccessibleObjectProxy)
            #         ((AccessibleObjectProxy)result).setAccessor(accessor);
            #     else if (result != null && result instanceof Object[])
            #         Object[] array = (Object[])result;
            #         for (Object o : array)
            #             if (o instanceof AccessibleObjectProxy)
            #                 ((AccessibleObjectProxy)o).setAccessor(accessor);
            # except Exception as ignored:
            #     pass

            return result

    def invokeRequest(self, eventId, wrapper):
        from .sl_response import SLResponse
        try:
            from .utils import Utils
            reply = self._accessor._raiseSystemRequest(Utils.createOpaqueEvent(eventId, wrapper), self._accessor.getRequestTimeout())
            if reply is None:
                return SLResponse(text="Received response is null.", isOK=False)
            reply = Utils.processServerAnswer(reply, "OpaqueEvent")
            reply = self._accessor._connection.getTypeFactory().readFromMap(reply.get("data"), "SLResponse")
            return reply
        except Exception as exception:
            return SLResponse(exception=exception)

    def __del__(self):
        try:
            if self._accessor:
                call = self._slDataspaceCall(AccessibleObjectProxy.TOP_ACCESSOR_ID, "eraseFromObjectCache", [self._oid])
                self.invokeRequest(self.SLDataspaceCallEventId, call)
        finally:
            self._accessor = None
            pass
