/*
 * Decompiled with CFR 0.152.
 */
package samples.evfs;

import com.streamscape.lib.evfs.DirectoryMonitor;
import com.streamscape.lib.evfs.FileSortStrategy;
import com.streamscape.lib.evfs.mf.admin.DirectoryMonitorFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class DirectoryMonitorDemo {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("HH:mm:ss.S");

    public static void main(String[] args) throws IOException, InterruptedException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        System.out.println("Welcome to Directory Monitor Demo.");
        System.out.println("Here you will be able start a directory monitor for a specific folder and watch what happens there.");
        System.out.println();
        System.out.print("Input the path for the directory to watch: ");
        String dir = reader.readLine();
        System.out.println();
        Long delay = 500L;
        boolean fail = true;
        while (fail) {
            try {
                System.out.print("Input the delay (in ms) between inspections of the directory: ");
                String delayStr = reader.readLine();
                delay = Long.parseLong(delayStr);
                fail = false;
            }
            catch (Exception delayStr) {}
        }
        System.out.println();
        DirectoryMonitor monitor = DirectoryMonitorFactory.createDirectoryMonitor((String)"Demo", (String)dir, (boolean)false, (FileSortStrategy)FileSortStrategy.SERVER_DEFAULT, (boolean)false);
        ScheduledExecutorService executorService = Executors.newScheduledThreadPool(1);
        executorService.scheduleAtFixedRate((Runnable)monitor, 0L, delay, TimeUnit.MILLISECONDS);
        System.out.println("Directory Monitor for directory '" + dir + "' has been started.");
        System.out.println("Create, copy to, delete or just modify files under this directory to see the notifications");
        System.out.println("Press <Enter> to finish...");
        while (System.in.available() == 0) {
            Thread.sleep(100L);
        }
        executorService.shutdown();
    }
}

