/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.ws.evSink;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationFactory;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationObject;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.ExceptionEventDatagram;
import com.streamscape.sdo.IAbstractExceptionEvent;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.enums.Severity;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sdo.event.XMLEvent;
import com.streamscape.sdo.excp.ServiceFrameworkException;
import com.streamscape.sdo.excp.SoapFaultException;
import com.streamscape.sdo.excp.SoapRequestException;
import com.streamscape.sdo.utils.SDOUtils;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.FabricRequestException;
import com.streamscape.sef.service.AbstractService;
import com.streamscape.service.osf.ServiceRuntimeException;
import com.streamscape.service.osf.config.AbstractServiceConfigurationObject;
import com.streamscape.service.osf.config.PasswordPropertyValue;
import com.streamscape.service.osf.config.ServiceConfigurationException;
import com.streamscape.service.osf.config.ServiceConfigurationProperty;
import com.streamscape.service.osf.config.ServicePropertyType;
import com.streamscape.service.osf.enums.InvokeMode;
import com.streamscape.service.osf.evh.EventHandler;
import com.streamscape.service.ws.evSink.Version;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WebServiceInvoker
extends AbstractService {
    private boolean isActive = false;
    private String username = "";
    private String password = "";
    private String url = "";
    private boolean isSoapVersion2_0 = false;
    private boolean plainPasswdAuth = false;
    private SOAPConnectionFactory factory;
    private static final String WSSE_NAMESPACE = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    private static final String SOAP_VERSION_PROPERTY_NAME = "javax.xml.soap.MessageFactory";
    private static final String SOAP_VERSION_1_1_IMPL = "com.sun.xml.internal.messaging.saaj.soap.ver1_1.SOAPMessageFactory1_1Impl";

    private SOAPMessage prepareRequest(String envelopeBody) {
        SOAPMessage result = null;
        try {
            if (!this.isSoapVersion2_0) {
                System.setProperty(SOAP_VERSION_PROPERTY_NAME, SOAP_VERSION_1_1_IMPL);
            }
            MessageFactory messageFactory = MessageFactory.newInstance();
            SOAPMessage request = messageFactory.createMessage();
            SOAPPart soapPart = request.getSOAPPart();
            SOAPEnvelope envelope = soapPart.getEnvelope();
            SOAPBody body = envelope.getBody();
            SOAPHeader header = envelope.getHeader();
            if (this.plainPasswdAuth) {
                SOAPElement securityElement = header.addChildElement(envelope.createName("Security", "wsse", WSSE_NAMESPACE));
                SOAPElement headerElement = securityElement.addChildElement(envelope.createName("UsernameToken", "wsse", WSSE_NAMESPACE));
                headerElement.addChildElement(envelope.createName("Username", "wsse", WSSE_NAMESPACE)).addTextNode(this.username);
                SOAPElement passwdElement = headerElement.addChildElement(envelope.createName("Password", "wsse", WSSE_NAMESPACE));
                passwdElement.addAttribute(envelope.createName("Type"), "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText");
                passwdElement.addTextNode(this.password);
            }
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(true);
            DocumentBuilder builder = dbFactory.newDocumentBuilder();
            StringReader reader = new StringReader(envelopeBody);
            Document document = builder.parse(new InputSource(reader));
            body.addDocument(document);
            request.saveChanges();
            result = request;
        }
        catch (SAXException error) {
            this.ctx.logError("SOAP request creation error. " + error.getMessage());
        }
        catch (ParserConfigurationException error) {
            this.ctx.logError("Input XML parsing error. Please verify its content. " + error.getMessage());
        }
        catch (IOException error) {
            this.ctx.logError("IO error. Can not build a reply message. " + error.getMessage());
        }
        catch (SOAPException error) {
            SoapRequestException exception = new SoapRequestException(5000, (Throwable)error);
            this.raiseException((IAbstractExceptionEvent)exception);
        }
        return result;
    }

    private String invoke(SOAPMessage request) {
        try {
            SOAPConnection conn = this.factory.createConnection();
            ByteArrayOutputStream soapReq = new ByteArrayOutputStream();
            request.writeTo((OutputStream)soapReq);
            String requestString = new String(soapReq.toByteArray());
            this.ctx.logDebug("SOAP Request\n------------\n" + requestString.replaceAll("><", ">\n<") + "\n------------\n");
            SOAPMessage reply = conn.call(request, (Object)this.url);
            ByteArrayOutputStream soapReply = new ByteArrayOutputStream();
            reply.writeTo((OutputStream)soapReply);
            String replyString = new String(soapReply.toByteArray());
            this.ctx.logDebug("SOAP Reply\n------------\n" + replyString.replaceAll("><", ">\n<") + "\n------------\n");
            if (!this.checkForFault(reply)) {
                this.ctx.logInfo("Web service at '" + this.url + "' has been successfully invoked.");
                return replyString;
            }
        }
        catch (SoapRequestException error) {
            this.raiseException((IAbstractExceptionEvent)error);
        }
        catch (SOAPException error) {
            this.raiseException((IAbstractExceptionEvent)new SoapRequestException(5000, (Throwable)error));
        }
        catch (Exception error) {
            this.raiseException((IAbstractExceptionEvent)new ServiceFrameworkException(6108, (Throwable)error));
        }
        return null;
    }

    private boolean checkForFault(SOAPMessage reply) throws SoapRequestException {
        try {
            Document replyDoc = reply.getSOAPBody().extractContentAsDocument();
            Node firstReplyNode = replyDoc.getFirstChild();
            if (firstReplyNode.getLocalName().equals("Fault") && firstReplyNode.getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/envelope/")) {
                NodeList list = firstReplyNode.getChildNodes();
                String faultCode = "";
                String faultString = "";
                for (int k = 0; k < list.getLength(); ++k) {
                    Node node = list.item(k);
                    if (node.getLocalName().equals("faultcode")) {
                        faultCode = node.getTextContent();
                        continue;
                    }
                    if (!node.getLocalName().equals("faultstring")) continue;
                    faultString = node.getTextContent();
                }
                SoapFaultException fault = new SoapFaultException(faultCode, faultString);
                fault.setSeverity(Severity.SEVERE);
                this.raiseException((IAbstractExceptionEvent)fault);
                return true;
            }
        }
        catch (SOAPException error) {
            throw new SoapRequestException(5000, (Throwable)error);
        }
        return false;
    }

    private String printXmlDocument(Document doc) throws TransformerException {
        TransformerFactory tfactory = TransformerFactory.newInstance();
        Transformer xform = tfactory.newTransformer();
        DOMSource src = new DOMSource(doc);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        xform.transform(src, result);
        return writer.toString();
    }

    public void destroy() {
    }

    public String getVersion() {
        return Version.getVersionString();
    }

    public void doInit() {
        try {
            this.ctx.logInfo("Service initializing...");
            this.factory = SOAPConnectionFactory.newInstance();
            this.username = this.ctx.lookupStringProperty("web.service.user");
            this.password = this.ctx.lookupPasswordProperty("web.service.passwd");
            this.url = this.ctx.lookupStringProperty("web.service.url");
            this.isSoapVersion2_0 = this.ctx.lookupBooleanProperty("soap.version.2.0");
            this.plainPasswdAuth = this.ctx.lookupBooleanProperty("plain.passwd.auth");
        }
        catch (ServiceConfigurationException error) {
            this.ctx.logError("Service initialization error: " + error.getMessage());
        }
        catch (RuntimeException error) {
            this.ctx.logError("Service initialization error: " + error.getMessage());
        }
        catch (SOAPException error) {
            this.raiseException((IAbstractExceptionEvent)new SoapRequestException(5000, (Throwable)error));
        }
        this.ctx.logInfo("Service initialized.");
    }

    public void start() throws ServiceFrameworkException {
        super.start();
        this.isActive = true;
    }

    public void stop() throws ServiceFrameworkException {
        this.isActive = false;
        super.stop();
    }

    public Object invokeWebService(Object e) {
        XMLEvent wsReplyEvent = null;
        String wsReply = null;
        if (!this.isActive) {
            throw new IllegalStateException("Service is not started.");
        }
        if (!(e instanceof XMLEvent)) {
            throw new ServiceRuntimeException("Web Service Call Error: Semantic Type mismatch. Expected XMLEvent, received '" + e.getClass().getName() + "'.");
        }
        try {
            String soapEnvelopeBody = ((XMLEvent)e).getXFragment();
            SOAPMessage requestMsg = this.prepareRequest(soapEnvelopeBody);
            if (requestMsg != null) {
                this.ctx.logDebug("Invoke Web Service..");
                wsReply = this.invoke(requestMsg);
                this.ctx.logDebug("Web Service invoked successfully.");
            }
            if (wsReply != null) {
                EventDatagramFactory datagramFactory = this.context.getEventDatagramFactory();
                wsReplyEvent = (XMLEvent)datagramFactory.createEvent("e.prototype.XMLEvent");
                wsReplyEvent.setXML(wsReply);
            }
        }
        catch (Exception ex) {
            FabricRequestException excp = new FabricRequestException((Throwable)ex);
            this.raiseException((IAbstractExceptionEvent)excp);
        }
        return wsReplyEvent;
    }

    private void raiseException(IAbstractExceptionEvent exception) {
        try {
            this.ctx.logError(exception.getMessage() != null ? exception.getMessage() : (exception.getErrorMessage() != null ? exception.getErrorMessage() : "Exception with an empty message has been thrown."));
            exception.setSeverity(Severity.SEVERE);
            this.ctx.raiseException((ExceptionEventDatagram)exception);
        }
        catch (Exception error) {
            System.out.println("Event dispatch error in raiseException(): " + exception.getMessage());
        }
    }

    public int getMinorBuild() {
        return Version.getBuild();
    }

    public int getMajorVersion() {
        return Version.getMajorVersion();
    }

    public int getMinorVersion() {
        return Version.getMinorVersion();
    }

    public static ServiceConfigurationObject generateSco() throws Exception {
        RuntimeContext.getInstance();
        SDOUtils.addEventPrototype((String)"XMLEvent", (String)"event.soap.request");
        SDOUtils.addEventPrototype((String)"XMLEvent", (String)"event.soap.reply");
        ServiceConfigurationObject sco = ServiceConfigurationFactory.createServiceConfiguration((FabricComponent)RuntimeContext.getInstance(), (String)"prototype", (String)"WebServiceRequest", (boolean)false);
        sco.setServiceClassName(WebServiceInvoker.class.getName());
        sco.setServiceDescription("Allows to invoke Web Service using provided SOAP envelop body.");
        sco.setServiceDisplayName("Web Service Request");
        sco.setInvokeMode(InvokeMode.ASYNC);
        EventHandler handler = new EventHandler((AbstractServiceConfigurationObject)sco, "invokeWebService", "WebServiceInvokeHandler");
        EventDatagram prototype = EventDatagramFactory.getInstance().createEvent("event.soap.request");
        handler.bindRequestEvent((ImmutableEventDatagram)prototype);
        prototype = EventDatagramFactory.getInstance().createEvent("event.soap.reply");
        handler.bindResponseEvent((ImmutableEventDatagram)prototype);
        sco.addEventHandler(handler);
        ServiceConfigurationProperty prop = sco.createProperty("plain.passwd.auth", ServicePropertyType.BOOLEAN, null);
        prop.setLabel("Plain Password Authentication");
        prop.setDescription("Specifies whether web service requires plain password authentication.");
        prop.setValue((Object)false);
        sco.addProperty(prop);
        prop = sco.createProperty("soap.version.2.0", ServicePropertyType.BOOLEAN, null);
        prop.setLabel("SOAP 2.0");
        prop.setDescription("Specifies which version of SOAP protocol should be used 2.0 or 1.1.");
        prop.setValue((Object)true);
        sco.addProperty(prop);
        prop = sco.createProperty("web.service.passwd", ServicePropertyType.PASSWORD, null);
        prop.setLabel("Web Service Password");
        prop.setDescription("Specifies password for plain password authorization.");
        prop.setValue((Object)new PasswordPropertyValue("Password goes here"));
        sco.addProperty(prop);
        prop = sco.createProperty("web.service.user", ServicePropertyType.STRING, null);
        prop.setLabel("Web Service User");
        prop.setDescription("Specifies username for plain password authorization.");
        prop.setValue("");
        sco.addProperty(prop);
        prop = sco.createProperty("web.service.url", ServicePropertyType.STRING, null);
        prop.setLabel("Web Service URL");
        prop.setDescription("Specifies URL where Web Service is located.");
        prop.setValue("");
        sco.addProperty(prop);
        sco.addException("exception.ws.SoapRequest");
        sco.addException("exception.ws.SoapFault");
        return sco;
    }
}

