/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.slang.evSink;

import com.streamscape.Trace;
import com.streamscape.cli.tlp.FabricConnection;
import com.streamscape.cli.tlp.FabricConnectionFactory;
import com.streamscape.lib.utils.SQLType;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationFactory;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationObject;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sdo.excp.ServiceFrameworkException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.service.AbstractService;
import com.streamscape.service.osf.config.ServiceConfigurationException;
import com.streamscape.service.osf.config.ServiceConfigurationProperty;
import com.streamscape.service.osf.config.ServicePropertyType;
import com.streamscape.service.osf.eim.EventIdentity;
import com.streamscape.service.osf.enums.InvokeMode;
import com.streamscape.service.slang.evSink.Version;
import com.streamscape.slex.slang.SLSession;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class SlangQueryService
extends AbstractService {
    protected SLSession slangSession = null;
    protected FabricConnection connection = null;
    protected EventDatagramFactory datagramFactory = null;
    protected EventIdentity eim = new EventIdentity();
    protected long timeout = 0L;

    public RowSet executeStaticScript(ImmutableEventDatagram event) throws ServiceFrameworkException, ServiceConfigurationException {
        ArrayList<String> operations = new ArrayList<String>();
        List ops = this.ctx.lookupListProperty("operations");
        for (ServiceConfigurationProperty op : ops) {
            operations.add(op.getValue().toString());
        }
        return this.executeScript(operations);
    }

    public RowSet executeScript(String script) throws ServiceFrameworkException, ServiceConfigurationException {
        ArrayList<String> operations = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(script);
        while (tokenizer.hasMoreTokens()) {
            String operation = tokenizer.nextToken().trim();
            operations.add(operation);
        }
        return this.executeScript(operations);
    }

    protected RowSet executeScript(List<String> ops) throws ServiceFrameworkException {
        RowSet rowSet = null;
        try {
            for (String operation : ops) {
                Trace.logDebug((Object)((Object)this), (String)("Executing '" + operation + "' slang operation..."));
                SLResponse slResponse = this.slangSession.slangRequest(operation, this.timeout);
                Trace.logDebug((Object)((Object)this), (String)("Operation executed " + (slResponse.isOK() ? "sucessfully." : "with failure.")));
                if (slResponse.getRowSet() != null) {
                    rowSet = slResponse.getRowSet();
                    continue;
                }
                RowMetaData meta = new RowMetaData();
                meta.addColumn("Response", SQLType.STRING);
                rowSet = new RowSet(meta);
                if (slResponse.getText() != null) {
                    rowSet.addToRowSet(new Object[]{slResponse.getText()});
                }
                if (slResponse.getException() != null) {
                    rowSet.addToRowSet(new Object[]{slResponse.getException().getMessage()});
                    continue;
                }
                if (slResponse.isOK()) {
                    rowSet.addToRowSet(new Object[]{"OK"});
                    continue;
                }
                rowSet.addToRowSet(new Object[]{"OK"});
            }
            return rowSet;
        }
        catch (Exception error) {
            Trace.logException((Object)((Object)this), (Throwable)error, (boolean)true);
            throw new ServiceFrameworkException(6000, error.getMessage());
        }
    }

    public void doInit() {
        try {
            this.datagramFactory = this.context.getEventDatagramFactory();
        }
        catch (RuntimeException error) {
            this.ctx.logError("Service instantiation error: " + error.getMessage());
        }
        try {
            this.connection = new FabricConnectionFactory().createConnection();
            this.connection.setName("SlangExecutorConnection");
            this.connection.open();
            this.slangSession = this.connection.createSLSession();
            this.timeout = this.ctx.lookupNumericProperty("timeout");
        }
        catch (Exception error) {
            this.reportAndRethrowError(error);
        }
    }

    public void resume() throws ServiceFrameworkException {
        super.resume();
    }

    public void suspend() throws ServiceFrameworkException {
        super.suspend();
    }

    public void start() throws ServiceFrameworkException {
        super.start();
    }

    public void stop() throws ServiceFrameworkException {
        super.stop();
    }

    private void reportAndRethrowError(Throwable error) {
        this.ctx.logError(error.getMessage());
        throw new RuntimeException(error);
    }

    public int getMinorBuild() {
        return Version.getBuild();
    }

    public int getMajorVersion() {
        return Version.getMajorVersion();
    }

    public int getMinorVersion() {
        return Version.getMinorVersion();
    }

    public String getVersion() {
        return Version.getVersionString();
    }

    public static ServiceConfigurationObject generateSco() throws Exception {
        RuntimeContext.getInstance();
        ServiceConfigurationObject sco = ServiceConfigurationFactory.createServiceConfiguration((FabricComponent)RuntimeContext.getInstance(), (String)"prototype", (String)"SlangQuery", (boolean)false);
        sco.setServiceClassName(SlangQueryService.class.getName());
        sco.setServiceDescription("Executes arbitrary slang operation(s).");
        sco.setServiceDisplayName("Slang Query Service");
        sco.setInvokeMode(InvokeMode.ASYNC);
        sco.setInterruptableService(false);
        ServiceConfigurationProperty prop = null;
        prop = sco.createProperty("timeout", ServicePropertyType.NUMERIC, null);
        prop.setLabel("Timeout");
        prop.setDescription("Specifies a timeout for one operation execution.");
        prop.setValue((Object)0L);
        sco.addProperty(prop);
        ArrayList<ServiceConfigurationProperty> operations = new ArrayList<ServiceConfigurationProperty>();
        prop = sco.createProperty("operations", ServicePropertyType.LIST, null);
        prop.setLabel("Operations");
        prop.setDescription("Specifies list of static slang operations to be executed.");
        prop.setValue(operations);
        sco.addProperty(prop);
        prop = sco.createProperty("operation", ServicePropertyType.STRING, null);
        prop.setValue("use TSPACE.TEST");
        operations.add(prop);
        prop = sco.createProperty("operation", ServicePropertyType.STRING, null);
        prop.setValue("create table TestTable (id int)");
        operations.add(prop);
        return sco;
    }
}

