/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.mail.sender;

import com.streamscape.Trace;
import com.streamscape.lib.utils.Utils;
import com.streamscape.omf.xml.XSerializer;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationFactory;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationObject;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.ExceptionEventDatagram;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.enums.Severity;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sdo.event.MailEvent;
import com.streamscape.sdo.excp.ClientException;
import com.streamscape.sdo.excp.ServiceFrameworkException;
import com.streamscape.sdo.utils.SDOUtils;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.service.AbstractService;
import com.streamscape.service.mail.sender.AttachmentFileDataSource;
import com.streamscape.service.mail.sender.MailEnvelope;
import com.streamscape.service.mail.sender.Version;
import com.streamscape.service.osf.config.AbstractServiceConfigurationObject;
import com.streamscape.service.osf.config.PasswordPropertyValue;
import com.streamscape.service.osf.config.ServiceConfigurationException;
import com.streamscape.service.osf.config.ServiceConfigurationProperty;
import com.streamscape.service.osf.config.ServicePropertyType;
import com.streamscape.service.osf.enums.InvokeMode;
import com.streamscape.service.osf.evh.EventHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.activation.CommandMap;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.MailcapCommandMap;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class MailSender
extends AbstractService {
    private static final int DEFAULT_CONNECTION_TIMEOUT = 30;
    private static final int DEFAULT_CONNECTION_ATTEMPTS = 1;
    private static final int DEFAULT_MAIL_SEND_TIMEOUT_SECONDS = 30;
    private static final int DEFAULT_MAIL_SEND_RETRIES = 3;
    private String host = "";
    private String port = "";
    private String username = "";
    private String password = "";
    private int connectionTimeout = 30;
    private int connectionAttempts = 1;
    private int mailSendTimeoutSeconds = 30;
    private int mailSendRetries = 3;
    private boolean startTlsRequired = false;
    private boolean sslRequired = false;
    private String subject = "";
    private InternetAddress replyToAddress;
    private InternetAddress[] recipientAddressList;
    private long deliveryDelay = 0L;
    private XSerializer serializer;
    private static final String RECIPIENT_LIST_DELIMITER = ";";

    public void destroy() {
    }

    public String getVersion() {
        return Version.getVersionString();
    }

    public void doInit() throws ServiceFrameworkException {
        try {
            String recipientList;
            this.ctx.logInfo("Service initializing...");
            this.host = this.ctx.lookupStringProperty("smtp.server.name");
            this.port = this.ctx.lookupStringProperty("smtp.server.port");
            if (this.ctx.existsProperty("smtp.server.user")) {
                this.username = this.ctx.lookupStringProperty("smtp.server.user");
            }
            if (this.ctx.existsProperty("smtp.server.passwd")) {
                this.password = this.ctx.lookupPasswordProperty("smtp.server.passwd");
            }
            if (this.ctx.existsProperty("smtp.connection.timeout")) {
                this.connectionTimeout = this.ctx.lookupNumericProperty("smtp.connection.timeout").intValue();
            }
            if (this.ctx.existsProperty("smtp.connection.attempts")) {
                this.connectionAttempts = this.ctx.lookupNumericProperty("smtp.connection.attempts").intValue();
                if (this.connectionAttempts <= 0) {
                    throw new ServiceConfigurationException("Value of property 'smtp.connection.attempts' must be positive.");
                }
            }
            if (this.ctx.existsProperty("start.tls.required")) {
                this.startTlsRequired = this.ctx.lookupBooleanProperty("start.tls.required");
            }
            if (this.ctx.existsProperty("ssl.required")) {
                this.sslRequired = this.ctx.lookupBooleanProperty("ssl.required");
            }
            this.replyToAddress = new InternetAddress(this.ctx.lookupStringProperty("reply.to.address"));
            if (this.ctx.existsProperty("message.subject")) {
                this.subject = this.ctx.lookupStringProperty("message.subject");
            }
            if (this.ctx.existsProperty("recipients.list") && (recipientList = this.ctx.lookupStringProperty("recipients.list")) != null) {
                StringTokenizer tokenizer = new StringTokenizer(recipientList, RECIPIENT_LIST_DELIMITER);
                ArrayList<InternetAddress> recipients = new ArrayList<InternetAddress>();
                while (tokenizer.hasMoreTokens()) {
                    recipients.add(new InternetAddress(tokenizer.nextToken()));
                }
                if (recipients.size() > 0) {
                    this.recipientAddressList = new InternetAddress[recipients.size()];
                    this.recipientAddressList = recipients.toArray(this.recipientAddressList);
                }
            }
            if (this.ctx.existsProperty("mail.delivery.delay")) {
                this.deliveryDelay = this.ctx.lookupNumericProperty("mail.delivery.delay");
            }
            if (this.ctx.existsProperty("mail.send.timeout.seconds")) {
                this.mailSendTimeoutSeconds = this.ctx.lookupNumericProperty("mail.send.timeout.seconds").intValue();
            }
            if (this.ctx.existsProperty("mail.send.retries")) {
                this.mailSendRetries = this.ctx.lookupNumericProperty("mail.send.retries").intValue();
            }
            this.ctx.logInfo("mail.send.timeout.seconds: " + this.mailSendTimeoutSeconds + " seconds");
            this.ctx.logInfo("mail.send.retries: " + this.mailSendRetries);
            if (RuntimeContext.getInstance().getDatagramPrototypeFactory().existsPrototype("exception.cli.Interface") && !this.ctx.getServiceConfiguration().existsException("exception.cli.Interface")) {
                this.ctx.getServiceConfiguration().addException("exception.cli.Interface");
            }
            this.serializer = this.context.getXSerializerFactory().getDefaultSerializer();
        }
        catch (AddressException error) {
            this.ctx.logError("Unable to resolve address: " + error.getMessage());
        }
        catch (ServiceConfigurationException error) {
            this.ctx.logError("Service initialization error: " + error.getMessage());
            throw new ServiceFrameworkException(6065, (Throwable)error);
        }
        catch (RuntimeException error) {
            this.ctx.logError("Service initialization error: " + error.getMessage());
        }
        this.ctx.logInfo("Service initialized.");
    }

    public void sendMail(Object event) throws Exception {
        this.doSendMail(event);
    }

    public void sendMailFromEvent(ImmutableEventDatagram event) throws Exception {
        if (!(event instanceof MailEvent)) {
            throw new ServiceFrameworkException(6108, "Unsupported event received. Ignored.");
        }
        this.doSendMail(event);
    }

    private void doSendMail(Object event) throws Exception {
        this.ctx.logDebug("Sending new mail...");
        if (this.deliveryDelay > 0L) {
            this.ctx.logDebug("Delay before sending: " + this.deliveryDelay + "ms.");
            Utils.sleep((long)this.deliveryDelay);
        }
        this.doSendMailWithRetries(event, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSendMailWithRetries(final Object event, int executedRetries) throws Exception {
        if (executedRetries >= this.mailSendRetries) {
            String error = "Max attempts " + executedRetries + "/" + this.mailSendRetries + " for mail send reached!";
            this.ctx.logError(error);
            ClientException e = new ClientException(1036, error, Severity.SEVERE);
            this.raiseClientException(e);
            return;
        }
        ++executedRetries;
        boolean needRetry = false;
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            class MailSenderCallable
            implements Callable<Object> {
                MailSenderCallable() {
                }

                @Override
                public Object call() throws Exception {
                    ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
                    try {
                        Thread.currentThread().setContextClassLoader(RuntimeContext.getInstance().getSystemClassLoaderChain());
                        boolean needAuthentication = MailSender.this.username != null && !MailSender.this.username.isEmpty();
                        Session session = MailSender.this.createSession(needAuthentication);
                        MailcapCommandMap mc = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
                        mc.addMailcap("text/html;; x-java-content-handler=com.sun.mail.handlers.text_html");
                        mc.addMailcap("text/xml;; x-java-content-handler=com.sun.mail.handlers.text_xml");
                        mc.addMailcap("text/plain;; x-java-content-handler=com.sun.mail.handlers.text_plain");
                        mc.addMailcap("multipart/*;; x-java-content-handler=com.sun.mail.handlers.multipart_mixed");
                        mc.addMailcap("message/rfc822;; x-java-content- handler=com.sun.mail.handlers.message_rfc822");
                        if (((MailEvent)event).getSubject().equals("s1")) {
                            Thread.sleep(100000L);
                        }
                        MimeMessage message = new MimeMessage(session);
                        if (event instanceof MailEvent) {
                            MailSender.this.fillMessageFromEvent((Message)message, (MailEvent)event);
                        } else {
                            MailSender.this.fillMessageFromObject((Message)message, event);
                        }
                        MailSender.this.sendMessage(session, (Message)message, needAuthentication);
                        MailSender.this.ctx.logDebug("Mail successfully sent to recipients: " + Arrays.stream(message.getAllRecipients()).map(String::valueOf).collect(Collectors.joining(", ", "", ".")));
                    }
                    catch (Exception exception) {
                        MailSender.this.ctx.logError(exception.getMessage());
                        throw new ServiceFrameworkException(6108, "Sending mail failed.", (Throwable)exception, Severity.SEVERE);
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(contextClassLoader);
                    }
                    return null;
                }
            }
            Future<Object> future = executor.submit(new MailSenderCallable());
            try {
                future.get(this.mailSendTimeoutSeconds, TimeUnit.SECONDS);
            }
            catch (ExecutionException exception) {
                throw (Exception)exception.getCause();
            }
            catch (InterruptedException exception) {
            }
            catch (TimeoutException exception) {
                try {
                    future.cancel(true);
                }
                catch (Exception e) {
                    Trace.logError((Object)((Object)this), (String)"Failed to cancel send task.");
                    Trace.logException((Object)((Object)this), (Throwable)e, (boolean)true);
                }
                String error = "Sending of mail is timed out. Timeout: " + this.mailSendTimeoutSeconds + " seconds. Retry: " + executedRetries + "/" + this.mailSendRetries + ".";
                this.ctx.logError(error);
                ClientException e = new ClientException(1036, error, Severity.SEVERE);
                this.raiseClientException(e);
                needRetry = true;
            }
        }
        finally {
            try {
                executor.shutdown();
                executor.shutdownNow();
            }
            catch (Throwable throwable) {
                Trace.logException((Object)((Object)this), (Throwable)throwable, (boolean)true);
            }
        }
        if (needRetry) {
            this.doSendMailWithRetries(event, executedRetries);
        }
    }

    private void raiseClientException(ClientException exception) {
        try {
            exception.setConnectionName("SMTP");
            this.ctx.raiseException((ExceptionEventDatagram)exception);
        }
        catch (Exception ex) {
            this.ctx.logError("Event dispatch exception: " + ex.getMessage() + " for SQL Error: " + exception.getErrorMessage());
        }
    }

    private Session createSession(boolean needAuthentication) {
        Properties properties = new Properties();
        properties.put("mail.transport.protocol", "smtp");
        properties.put("mail.smtp.host", this.host);
        properties.put("mail.smtp.port", this.port);
        properties.put("mail." + (this.sslRequired ? "smtps" : "smtp") + ".auth", Boolean.toString(needAuthentication));
        properties.put("mail.smtp.connectiontimeout", (Object)(this.connectionTimeout * 1000));
        if (this.startTlsRequired) {
            properties.put("mail.smtp.starttls.enable", "true");
        }
        if (this.sslRequired) {
            if (this.port.isEmpty()) {
                this.port = "465";
            }
            properties.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            properties.put("mail.smtp.socketFactory.port", "465");
        }
        return Session.getInstance((Properties)properties, (Authenticator)(needAuthentication ? new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(MailSender.this.username, MailSender.this.password);
            }
        } : null));
    }

    private void fillMessageFromObject(Message message, Object event) throws Exception {
        message.setFrom((Address)this.replyToAddress);
        message.setRecipients(Message.RecipientType.TO, (Address[])this.recipientAddressList);
        if (event instanceof MailEnvelope && ((MailEnvelope)((Object)event)).getSubject() != null) {
            message.setSubject(((MailEnvelope)((Object)event)).getSubject());
        } else {
            message.setSubject(this.subject);
        }
        this.setMessageContent(message, event);
        message.saveChanges();
    }

    private void fillMessageFromEvent(Message message, MailEvent event) throws Exception {
        int i;
        InternetAddress[] temp;
        message.setFrom((Address)this.replyToAddress);
        boolean needRecipients = true;
        if (event.getTo() != null && !event.getTo().isEmpty()) {
            temp = new InternetAddress[event.getTo().size()];
            for (i = 0; i < temp.length; ++i) {
                temp[i] = new InternetAddress((String)event.getTo().get(i));
            }
            message.setRecipients(Message.RecipientType.TO, (Address[])temp);
            needRecipients = false;
        }
        if (event.getCc() != null && !event.getCc().isEmpty()) {
            temp = new InternetAddress[event.getCc().size()];
            for (i = 0; i < temp.length; ++i) {
                temp[i] = new InternetAddress((String)event.getCc().get(i));
            }
            message.setRecipients(Message.RecipientType.CC, (Address[])temp);
            needRecipients = false;
        }
        if (needRecipients) {
            message.setRecipients(Message.RecipientType.TO, (Address[])this.recipientAddressList);
        }
        if (event.getSubject() != null) {
            message.setSubject(event.getSubject());
        } else {
            message.setSubject(this.subject);
        }
        if (event.getAttachmentsCount() != 0) {
            MimeMultipart multipart = new MimeMultipart("related");
            MimeBodyPart messagePart = new MimeBodyPart();
            this.setMessageContent((Part)messagePart, event.getBody(), event.getContentType());
            multipart.addBodyPart((BodyPart)messagePart);
            for (int i2 = 0; i2 < event.getAttachmentsCount(); ++i2) {
                MailEvent.MailAttachment attachment = event.getAttachment(i2);
                if (attachment == null) {
                    this.ctx.logError("Attachment is null, index: " + i2);
                    continue;
                }
                if (attachment.getName() == null) {
                    this.ctx.logError("Attachment name is null, index: " + i2);
                    continue;
                }
                if (attachment.getData() == null) {
                    this.ctx.logError("Attachment data is null, index: " + i2);
                    continue;
                }
                MimeBodyPart attachmentPart = new MimeBodyPart();
                attachmentPart.setDataHandler(new DataHandler((DataSource)new AttachmentFileDataSource(attachment.getName(), attachment.getData(), attachment.getMimeType())));
                attachmentPart.setFileName(attachment.getName());
                if (attachment.getContentId() != null) {
                    attachmentPart.setHeader("Content-ID", attachment.getContentId());
                }
                multipart.addBodyPart((BodyPart)attachmentPart);
            }
            message.setContent((Multipart)multipart);
        } else {
            this.setMessageContent((Part)message, event.getBody(), event.getContentType());
        }
        message.saveChanges();
    }

    private void setMessageContent(Message message, Object event) throws Exception {
        String body;
        String contentType = "text/plain";
        if (event instanceof MailEnvelope) {
            MailEnvelope envelope = (MailEnvelope)((Object)event);
            body = envelope.getBody();
            contentType = envelope.getContentType();
        } else {
            body = this.serializer.serialize(event);
        }
        message.setContent((Object)body, contentType);
    }

    private void setMessageContent(Part message, String body, String contentType) throws Exception {
        if (contentType == null) {
            contentType = "text/plain";
        }
        message.setContent((Object)body, contentType);
    }

    private void sendMessage(Session session, Message message, boolean needAuthentication) throws Exception {
        try (Transport transport = null;){
            transport = this.connect(session, needAuthentication);
            transport.sendMessage(message, message.getAllRecipients());
        }
    }

    private Transport connect(Session session, boolean needAuthentication) throws Exception {
        Transport transport = this.sslRequired ? session.getTransport("smtps") : session.getTransport();
        for (int i = 0; i < this.connectionAttempts; ++i) {
            this.ctx.logDebug("Connecting to SMTP server (attempt #" + (i + 1) + ")...");
            try {
                this.doConnect(transport, needAuthentication);
                break;
            }
            catch (Exception exception) {
                if (i == this.connectionAttempts - 1) {
                    throw exception;
                }
                this.ctx.logDebug(exception.toString());
                continue;
            }
        }
        if (!transport.isConnected()) {
            throw new ServiceFrameworkException(6108, "Connection to SMTP server failed.");
        }
        this.ctx.logDebug("Connection with SMTP server established.");
        return transport;
    }

    private void doConnect(Transport transport, boolean needAuthentication) throws Exception {
        try {
            if (needAuthentication) {
                transport.connect(this.host, this.username, this.password);
            } else {
                transport.connect();
            }
        }
        catch (Exception exception) {
            throw new ServiceFrameworkException(6108, "Connection to SMTP server failed.", (Throwable)exception);
        }
    }

    public int getMinorBuild() {
        return Version.getBuild();
    }

    public int getMajorVersion() {
        return Version.getMajorVersion();
    }

    public int getMinorVersion() {
        return Version.getMinorVersion();
    }

    public static ServiceConfigurationObject generateSco() throws Exception {
        RuntimeContext.getInstance();
        SDOUtils.addEventPrototype((String)"MailEvent", (String)"event.mail.prototype");
        ServiceConfigurationObject sco = ServiceConfigurationFactory.createServiceConfiguration((FabricComponent)RuntimeContext.getInstance(), (String)"prototype", (String)"MailSender", (boolean)false);
        sco.setServiceClassName(MailSender.class.getName());
        sco.setServiceDescription("Sends out e-mail with the content from incoming MailEvent.");
        sco.setServiceDisplayName("E-mail Sender");
        sco.setInvokeMode(InvokeMode.ASYNC);
        EventHandler handler = new EventHandler((AbstractServiceConfigurationObject)sco, "sendMailFromEvent", "SendMailHandler");
        EventDatagram prototype = EventDatagramFactory.getInstance().createEvent("event.mail.prototype");
        handler.bindRequestEvent((ImmutableEventDatagram)prototype);
        sco.addEventHandler(handler);
        ServiceConfigurationProperty property = sco.createProperty("smtp.server.name", ServicePropertyType.STRING, null);
        property.setLabel("SMTP Server Name");
        property.setDescription("Specifies STMP server name.");
        property.setValue("");
        property.setRequired(true);
        sco.addProperty(property);
        property = sco.createProperty("smtp.server.port", ServicePropertyType.STRING, null);
        property.setLabel("SMTP Server Port");
        property.setDescription("Specifies STMP server port number.");
        property.setValue("25");
        sco.addProperty(property);
        property = sco.createProperty("smtp.server.user", ServicePropertyType.STRING, null);
        property.setLabel("SMTP Server User");
        property.setDescription("Specifies STMP server user.");
        property.setValue("");
        sco.addProperty(property);
        property = sco.createProperty("smtp.server.passwd", ServicePropertyType.PASSWORD, null);
        property.setValue((Object)new PasswordPropertyValue("password goes here"));
        property.setLabel("SMTP Server Password");
        property.setDescription("Specifies password for SMTP server user.");
        sco.addProperty(property);
        property = sco.createProperty("smtp.connection.timeout", ServicePropertyType.NUMERIC, null);
        property.setLabel("SMTP Connection Timeout");
        property.setDescription("Timeout (in seconds) for connection to SMTP server. Non-positive value means system-dependent timeout.");
        property.setValue((Object)30);
        sco.addProperty(property);
        property = sco.createProperty("smtp.connection.attempts", ServicePropertyType.NUMERIC, null);
        property.setLabel("SMTP Connection Timeout");
        property.setDescription("Number of attempts for connection to SMTP server. Value must be positive.");
        property.setValue((Object)1);
        sco.addProperty(property);
        property = sco.createProperty("start.tls.required", ServicePropertyType.BOOLEAN, null);
        property.setLabel("Start TLS Required");
        property.setDescription("Specifies whether mail server uses TLS protocol.");
        property.setValue((Object)true);
        sco.addProperty(property);
        property = sco.createProperty("ssl.required", ServicePropertyType.BOOLEAN, null);
        property.setLabel("SSL Required");
        property.setDescription("Specifies whether mail server uses secure SMTPS protocol.");
        property.setValue((Object)false);
        sco.addProperty(property);
        property = sco.createProperty("reply.to.address", ServicePropertyType.STRING, null);
        property.setLabel("Reply TO");
        property.setDescription("Specifies ReplyTo address.");
        property.setValue("");
        property.setRequired(true);
        sco.addProperty(property);
        property = sco.createProperty("mail.send.timeout.seconds", ServicePropertyType.NUMERIC, null);
        property.setLabel("Mail Send Timeout");
        property.setDescription("Specified timeout in seconds for mail sending. Once timeout is expired mail sending thread is finished.");
        property.setValue((Object)30);
        property.setRequired(false);
        sco.addProperty(property);
        property = sco.createProperty("mail.send.retries", ServicePropertyType.NUMERIC, null);
        property.setLabel("Mail Send Retries");
        property.setDescription("Specified number of retries for attempts finished with timeout.");
        property.setValue((Object)3);
        property.setRequired(false);
        sco.addProperty(property);
        return sco;
    }
}

