/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.mail.reader;

import com.streamscape.Trace;
import com.streamscape.cli.ds.DataspaceAccessor;
import com.streamscape.cli.ds.DataspaceType;
import com.streamscape.lib.utils.Utils;
import com.streamscape.repository.IllegalStateException;
import com.streamscape.repository.RepositoryException;
import com.streamscape.repository.cli.RepositoryAccessorException;
import com.streamscape.repository.object.ReferenceContext;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.ExceptionEventDatagram;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.SecurityViolationException;
import com.streamscape.sdo.enums.Severity;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sdo.event.MailEvent;
import com.streamscape.sdo.excp.ClientException;
import com.streamscape.sdo.excp.ServiceFrameworkException;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sdo.utils.MailIndex;
import com.streamscape.sef.accessor.FabricComponentAccessorException;
import com.streamscape.sef.dataspace.DataspaceComponentException;
import com.streamscape.sef.dataspace.DataspaceManager;
import com.streamscape.sef.dataspace.DataspaceManagerException;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.moderator.DomainConstraintReference;
import com.streamscape.sef.moderator.Moderator;
import com.streamscape.sef.service.AbstractDaemonService;
import com.streamscape.sef.service.dsl.UserDefinedServiceDSLProviderAnnotation;
import com.streamscape.service.mail.reader.FullFetchByUIDCommand;
import com.streamscape.service.mail.reader.MailDescriptor;
import com.streamscape.service.mail.reader.MailReaderDSLProvider;
import com.streamscape.service.mail.reader.MailReaderUtils;
import com.streamscape.service.mail.reader.ProcessedMessage;
import com.streamscape.service.mail.reader.Version;
import com.streamscape.service.mail.tools.EmailSignature;
import com.streamscape.service.mail.tools.EmailSplitter;
import com.streamscape.service.osf.config.ObjectPropertyValue;
import com.streamscape.service.osf.config.ServiceConfigurationException;
import com.streamscape.slex.file.SLFileSessionContext;
import com.sun.mail.imap.IMAPFolder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.activation.CommandMap;
import javax.activation.MailcapCommandMap;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.FetchProfile;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.InternetAddress;
import javax.naming.NamingException;

@UserDefinedServiceDSLProviderAnnotation(clazz=MailReaderDSLProvider.class)
public class MailReader
extends AbstractDaemonService {
    private static final int DEFAULT_CONNECTION_TIMEOUT = 30;
    private String host = "";
    private String port = "";
    private String username = "";
    private String password = "";
    private boolean startTlsRequired = false;
    private boolean sslRequired = false;
    private int connectionTimeout = 30;
    private int reconnectInterval = 15;
    private int pollingInterval = 10;
    private String newMailEvenId = "";
    private boolean recoveryEnabled = false;
    private MailBoxRecoveryType recoveryType = MailBoxRecoveryType.MESSAGE;
    private long recoveryDepth = 3L;
    private boolean recovery = true;
    private Thread recoveryThread = null;
    private boolean interruptRecoveryThread = false;
    private Session emailSession;
    private Store emailStore;
    private IMAPFolder imapEmailFolder;
    private long lastUID = 0L;
    private DataspaceAccessor sdsAccessor = null;
    private String sdsCollectionName = "MAIL_READER";
    private MailIndex mailIndex = null;
    private DataspaceAccessor archiveAccessor = null;
    private boolean archiveEnabled = false;
    private long recoveryFetchSize = 100L;
    private long recoveryStep = 10000L;
    private String dataspaceName;
    private boolean lastMessageOnly = true;
    private boolean excludeSignature = true;
    private DomainConstraintReference blackListDomain = null;

    protected void doInit() throws ServiceFrameworkException {
        try {
            this.ctx.logInfo("Service initializing...");
            this.host = this.ctx.lookupStringProperty("smtp.server.name");
            this.port = this.ctx.lookupStringProperty("smtp.server.port");
            this.username = this.ctx.lookupStringProperty("smtp.server.user");
            this.password = this.ctx.lookupPasswordProperty("smtp.server.passwd");
            this.newMailEvenId = this.ctx.lookupStringProperty("new.mail.eventid");
            if (this.ctx.existsProperty("mail.polling.interval")) {
                this.pollingInterval = this.ctx.lookupNumericProperty("mail.polling.interval").intValue();
            }
            if (this.ctx.existsProperty("smtp.connection.timeout")) {
                this.connectionTimeout = this.ctx.lookupNumericProperty("smtp.connection.timeout").intValue();
            }
            if (this.ctx.existsProperty("start.tls.required")) {
                this.startTlsRequired = this.ctx.lookupBooleanProperty("start.tls.required");
            }
            if (this.ctx.existsProperty("ssl.required")) {
                this.sslRequired = this.ctx.lookupBooleanProperty("ssl.required");
            }
            if (this.ctx.existsProperty("startup.recovery.enabled")) {
                this.recoveryEnabled = this.ctx.lookupBooleanProperty("startup.recovery.enabled");
            }
            if (this.ctx.existsProperty("startup.recovery.type")) {
                if (this.ctx.lookupStringProperty("startup.recovery.type").equalsIgnoreCase("MESSAGE")) {
                    this.recoveryType = MailBoxRecoveryType.MESSAGE;
                }
                if (this.ctx.lookupStringProperty("startup.recovery.type").equalsIgnoreCase("TIME")) {
                    this.recoveryType = MailBoxRecoveryType.TIME;
                }
                if (this.ctx.lookupStringProperty("startup.recovery.type").equalsIgnoreCase("LAST_MESSAGE")) {
                    this.recoveryType = MailBoxRecoveryType.LAST_MESSAGE;
                }
                if (this.ctx.lookupStringProperty("startup.recovery.type").equalsIgnoreCase("COMPLETE")) {
                    this.recoveryType = MailBoxRecoveryType.COMPLETE;
                }
            }
            if (this.ctx.existsProperty("startup.recovery.depth")) {
                this.recoveryDepth = this.ctx.lookupNumericProperty("startup.recovery.depth");
            }
            if (this.ctx.existsProperty("startup.recovery.fetch.size")) {
                this.recoveryFetchSize = this.ctx.lookupNumericProperty("startup.recovery.fetch.size");
            }
            if (this.ctx.existsProperty("startup.recovery.step")) {
                this.recoveryStep = this.ctx.lookupNumericProperty("startup.recovery.step");
            }
            if (this.ctx.existsProperty("emails.black.list.domain")) {
                String blackListDomainName = this.ctx.lookupStringProperty("emails.black.list.domain");
                Moderator moderator = this.ctx.getModerator();
                this.blackListDomain = moderator.lookupDomainConstraint(blackListDomainName);
                if (this.blackListDomain == null) {
                    this.blackListDomain = moderator.lookupDomainConstraint(blackListDomainName);
                }
                if (this.blackListDomain == null) {
                    this.ctx.logError("There is not black list domain with name: '" + String.valueOf(this.blackListDomain) + "'");
                } else {
                    this.ctx.logInfo("Black List has been loaded: " + String.valueOf(this.blackListDomain.listStringValues()));
                }
            }
            this.emailSession = this.createSession();
            this.emailStore = this.emailSession.getStore("imaps");
            Folder emailFolder = this.initStoreFolder(this.emailStore);
            this.checkServiceCollection();
            this.ctx.logInfo("Initialize LastUID...");
            this.lastUID = this.getLastUID();
            this.ctx.logInfo("Initialized LastUID is " + this.lastUID + ".");
            this.initImapEmailFolder(emailFolder);
            if (this.ctx.existsProperty("mail.index")) {
                this.archiveEnabled = this.initArchiveDataspace();
            }
            if (this.ctx.existsProperty("dataspace.name")) {
                this.dataspaceName = this.ctx.lookupStringProperty("dataspace.name");
            }
            if (this.ctx.existsProperty("message.last.only")) {
                this.lastMessageOnly = this.ctx.lookupBooleanProperty("message.last.only");
            }
            if (this.ctx.existsProperty("message.exclude.signature")) {
                this.excludeSignature = this.ctx.lookupBooleanProperty("message.exclude.signature");
            }
        }
        catch (Exception ex) {
            this.ctx.logError("Service initialization error: " + Utils.formatException((Throwable)ex, (String)"\n"));
            throw new ServiceFrameworkException(6065, (Throwable)ex);
        }
    }

    public void start() throws ServiceFrameworkException {
        super.start();
        String threadName = this.ctx.getName() + "_msgrecovery";
        this.recoveryThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(RuntimeContext.getInstance().getSystemClassLoaderChain());
                    MailcapCommandMap mc = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
                    mc.addMailcap("text/html;; x-java-content-handler=com.sun.mail.handlers.text_html");
                    mc.addMailcap("text/xml;; x-java-content-handler=com.sun.mail.handlers.text_xml");
                    mc.addMailcap("text/plain;; x-java-content-handler=com.sun.mail.handlers.text_plain");
                    mc.addMailcap("multipart/*;; x-java-content-handler=com.sun.mail.handlers.multipart_mixed");
                    mc.addMailcap("message/rfc822;; x-java-content- handler=com.sun.mail.handlers.message_rfc822");
                    MailReader.this.recovery = true;
                    MailReader.this.recoveryMessages();
                }
                catch (Exception ex) {
                    MailReader.this.ctx.logError("Service initialization error: " + Utils.formatException((Throwable)ex, (String)"\n"));
                }
                finally {
                    Thread.currentThread().setContextClassLoader(contextClassLoader);
                    MailReader.this.recovery = false;
                }
            }
        }, threadName);
        this.recoveryThread.start();
    }

    public void destroy() throws ServiceFrameworkException {
        this.interruptRecoveryThread = true;
        if (this.sdsAccessor != null) {
            this.sdsAccessor.close();
            this.sdsAccessor = null;
        }
        if (this.emailStore != null && this.emailStore.isConnected()) {
            try {
                this.emailStore.close();
            }
            catch (Exception ex) {
                this.ctx.logError("Cannot close Email Store: " + Utils.formatException((Throwable)ex, (String)"\n"));
            }
        }
        super.destroy();
    }

    public String getMessageCount() {
        try {
            return Long.toString(this.imapEmailFolder.getMessageCount());
        }
        catch (Exception ex) {
            this.ctx.logError("Describe Service error: " + Utils.formatException((Throwable)ex, (String)"\n"));
            return "n/a";
        }
    }

    public long getLastMessageUIDValue() throws MessagingException {
        return this.imapEmailFolder.getUID(this.imapEmailFolder.getMessage(this.imapEmailFolder.getMessageCount()));
    }

    public String getLastMessageUID() {
        try {
            return Long.toString(this.getLastMessageUIDValue());
        }
        catch (Exception ex) {
            this.ctx.logError("Describe Service error: " + Utils.formatException((Throwable)ex, (String)"\n"));
            return "n/a";
        }
    }

    public String getLastProcessedUID() {
        try {
            return Long.toString(this.lastUID);
        }
        catch (Exception ex) {
            this.ctx.logError("Describe Service error: " + Utils.formatException((Throwable)ex, (String)"\n"));
            return "n/a";
        }
    }

    public String getLastProcessedMessageNum() {
        try {
            return Long.toString(this.imapEmailFolder.getMessageByUID(this.lastUID).getMessageNumber());
        }
        catch (Exception ex) {
            this.ctx.logError("Describe Service error: " + Utils.formatException((Throwable)ex, (String)"\n"));
            return "n/a";
        }
    }

    private Session createSession() {
        Properties properties = new Properties();
        properties.setProperty("mail.store.protocol", "imaps");
        properties.setProperty("mail.imaps.connectionpoolsize", "10");
        properties.setProperty("mail.imaps.partialfetch", "false");
        properties.put("mail.transport.protocol", "smtp");
        properties.put("mail.smtp.host", this.host);
        properties.put("mail.smtp.port", this.port);
        properties.put("mail.debug", "false");
        boolean needAuthentication = this.username != null && !this.username.isEmpty();
        properties.put("mail." + (this.sslRequired ? "smtps" : "smtp") + ".auth", Boolean.toString(needAuthentication));
        properties.put("mail.smtp.connectiontimeout", (Object)(this.connectionTimeout * 1000));
        if (this.startTlsRequired) {
            properties.put("mail.smtp.starttls.enable", "true");
        }
        if (this.sslRequired) {
            if (this.port.isEmpty()) {
                this.port = "465";
            }
            properties.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            properties.put("mail.smtp.socketFactory.port", "465");
        }
        Session emailSession = Session.getInstance((Properties)properties, (Authenticator)(needAuthentication ? new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(MailReader.this.username, MailReader.this.password);
            }
        } : null));
        return emailSession;
    }

    private Folder initStoreFolder(Store emailStore) throws MessagingException {
        if (!emailStore.isConnected()) {
            emailStore.connect(this.host, this.username, this.password);
        }
        Folder emailFolder = emailStore.getFolder("INBOX");
        emailFolder.open(1);
        return emailFolder;
    }

    private boolean initArchiveDataspace() throws DataspaceManagerException, FabricComponentAccessorException, DataspaceComponentException, ServiceConfigurationException, NamingException, RepositoryAccessorException, RepositoryException, RuntimeException {
        this.ctx.logInfo("Load Email Archiving config");
        ObjectPropertyValue opv = this.ctx.lookupObjectProperty("mail.index");
        ReferenceContext refCtx = new ReferenceContext(ReferenceContext.ROOT, MailIndex.MAIL_INDEX_NAMESPACE);
        if (!RuntimeContext.getInstance().getRepositoryAccessor().existsReferenceContext(MailIndex.MAIL_INDEX_NAMESPACE)) {
            this.ctx.logInfo("Reference context '" + MailIndex.MAIL_INDEX_NAMESPACE + "' does not exist. Skip Archiving dataspae initialization.");
            return false;
        }
        this.mailIndex = (MailIndex)RuntimeContext.getInstance().getRepositoryAccessor().lookupObject(refCtx, opv.getObjectName());
        if (this.mailIndex == null) {
            this.ctx.logInfo("MailIndex object is null. Skip Archiving dataspae initialization.");
            return false;
        }
        this.ctx.logInfo("Initialize Archive Dataspace and Collections");
        DataspaceManager manager = RuntimeContext.getInstance().getDataspaceManager();
        if (!manager.existsDataspace(this.mailIndex.getDataspaceName())) {
            manager.createDataspace(DataspaceType.TSPACE, this.mailIndex.getDataspaceName(), EventScope.OBSERVABLE);
            this.ctx.logInfo("Tablespace '" + this.mailIndex.getDataspaceName() + "' has been created.");
        } else {
            this.ctx.logInfo("Tablespace '" + this.mailIndex.getDataspaceName() + "' already exists.");
        }
        this.archiveAccessor = this.ctx.createDataspaceAccessor(DataspaceType.TSPACE, this.mailIndex.getDataspaceName());
        this.archiveAccessor.setSessionContext(SLFileSessionContext.SERVER);
        this.ctx.logInfo("Create Archive Table [" + this.mailIndex.getArchiveCollection() + "]...");
        this.archiveAccessor.executeQuery("create persistent table if not exists [" + this.mailIndex.getArchiveCollection() + "] (   MailID string PRIMARY KEY, Sender string, Recipients string array[], Subject string, Message FLOB(LOCATION './email/archive/" + this.mailIndex.getArchiveName() + "'))");
        this.ctx.logInfo("Archive Table has been created.");
        this.ctx.logInfo("Create Text Index for " + this.mailIndex.getArchiveCollection() + "...");
        ArrayList<String> textIndexes = new ArrayList<String>();
        try {
            RowSet rs = this.archiveAccessor.executeQuery("list text indexes");
            rs.beforeFirst();
            while (rs.next()) {
                textIndexes.add(rs.getString(1));
            }
        }
        catch (Exception ex) {
            this.ctx.logError("Failed to check exiting text indexes: " + Utils.formatException((Throwable)ex, (String)"\n"));
        }
        if (textIndexes.contains(this.mailIndex.getTextIndexName())) {
            this.ctx.logInfo("Text Index '" + this.mailIndex.getTextIndexName() + "' already exists.");
        } else {
            this.archiveAccessor.executeQuery("create text index [" + this.mailIndex.getTextIndexName() + "] on [" + this.mailIndex.getArchiveCollection() + "] (Sender, Recipients, Subject, Message)");
            this.ctx.logInfo("Text Index has been created.");
        }
        this.ctx.logInfo("Create Attachments Table [" + this.mailIndex.getAttachmentsCollection() + "]...");
        this.archiveAccessor.executeQuery("create persistent table if not exists [" + this.mailIndex.getAttachmentsCollection() + "] (   AttachmentID string PRIMARY KEY, MailID string, Subject string, Message FLOB(LOCATION './email/archive/" + this.mailIndex.getArchiveName() + "'))");
        this.ctx.logInfo("Attachments Table has been created.");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doRepeatableServiceLogic() {
        int waitTimeout = this.pollingInterval * 1000;
        try {
            if (this.recovery) return;
            this.ctx.logDebug("Check Email Folder for new messages...");
            if (!this.emailStore.isConnected() || !this.imapEmailFolder.isOpen()) {
                try {
                    this.ctx.logError("Store is not connected. Try to reconnect....");
                    Folder emailFolder = this.initStoreFolder(this.emailStore);
                    this.ctx.logInfo("Connection to Store has been established.");
                    this.initImapEmailFolder(emailFolder);
                    return;
                }
                catch (Exception ex) {
                    this.ctx.logError("Cannot establish connection to the Store. Try again later...");
                    this.ctx.logError("Store Connection error: " + Utils.formatException((Throwable)ex, (String)"\n"));
                    waitTimeout = this.reconnectInterval * 1000;
                }
                return;
            } else {
                int msgCount = this.imapEmailFolder.getMessageCount();
                long storedLastUID = this.getLastUID();
                long startUID = this.getNextMessageUID(storedLastUID);
                this.ctx.logInfo("Messages Count: " + msgCount + "; Stored Last UID: " + storedLastUID + "; Start UID: " + startUID);
                if (startUID != storedLastUID) {
                    FetchResult result = new FetchResult(this, startUID, 0);
                    do {
                        result = this.fetchMessages(startUID, msgCount);
                        startUID = this.getNextMessageUID(result.lastFectedUID);
                        msgCount = this.imapEmailFolder.getMessageCount();
                        if (result == null) return;
                    } while (result.lastFetchedNum < msgCount);
                    return;
                } else {
                    this.ctx.logDebug("Last UID and Next UID are the same. There is end of mailbox.");
                }
            }
            return;
        }
        catch (Exception ex) {
            this.ctx.logError("Mail Folder error: " + Utils.formatException((Throwable)ex, (String)"\n"));
            this.raiseException((ExceptionEventDatagram)this.createClientException("Mail Folder error.", ex));
            return;
        }
        finally {
            try {
                Thread.sleep(waitTimeout);
            }
            catch (InterruptedException ex) {
                Trace.logDebug((Object)((Object)this), (String)("Mail pooling interrupt: " + Utils.formatException((Throwable)ex, (String)"\n")));
            }
        }
    }

    private long getNextMessageUID(long uid) throws MessagingException {
        Message result = null;
        Message msg = this.imapEmailFolder.getMessageByUID(uid);
        if (msg != null) {
            int num = msg.getMessageNumber();
            if (this.imapEmailFolder.getMessageCount() >= num + 1) {
                result = this.imapEmailFolder.getMessage(num + 1);
            }
        }
        if (result == null || uid >= this.imapEmailFolder.getUID(result)) {
            while (msg == null) {
                msg = this.imapEmailFolder.getMessageByUID(++uid);
                if (uid <= this.getLastMessageUIDValue()) continue;
            }
            result = msg;
        }
        return result != null ? this.imapEmailFolder.getUID(result) : -1L;
    }

    private void handleMessage(Message msg, long uid) {
        this.handleMessage(msg, uid, null);
    }

    private void handleMessage(Message msg, long uid, ProcessedMessage pmsg) {
        long pt1 = System.currentTimeMillis();
        if (pmsg == null) {
            pmsg = MailReaderUtils.parseMessage(this.ctx, msg, uid);
        }
        long pt2 = System.currentTimeMillis();
        if (pmsg.mailDescriptor != null) {
            long t1 = System.currentTimeMillis();
            this.raiseMailEvent(pmsg);
            long t2 = System.currentTimeMillis();
            this.archiveMessage(pmsg);
            long t3 = System.currentTimeMillis();
            this.ctx.logInfo("Message processing completed. Duration: Parsing " + (pt2 - pt1) + "ms; Raising " + (t2 - t1) + "ms; Archiving " + (t3 - t2) + "ms");
        } else {
            this.ctx.logError("Failed to parse Message.");
            this.ctx.logDebug("Message processing failed. Duration: Parsing " + (pt2 - pt1));
        }
    }

    private void recoveryMessages(long startUID) throws MessagingException, InterruptedException {
        int msgCount = this.imapEmailFolder.getMessageCount();
        int endMsgNum = 0;
        boolean error = false;
        boolean firstErrorIteration = false;
        int retries = 3;
        FetchResult result = new FetchResult(this, startUID, endMsgNum);
        block4: do {
            for (int j = 0; j < retries; ++j) {
                if (this.interruptRecoveryThread) {
                    return;
                }
                if (error) {
                    this.ctx.logInfo("Check Email Store connection...");
                    if (!this.emailStore.isConnected() || !this.imapEmailFolder.isOpen() || firstErrorIteration) {
                        try {
                            this.ctx.logError("Store is not connected. Try to reconnect....");
                            Folder emailFolder = this.initStoreFolder(this.emailStore);
                            this.ctx.logInfo("Connection to Store has been established.");
                            this.initImapEmailFolder(emailFolder);
                            error = false;
                        }
                        catch (Exception ex) {
                            this.ctx.logError("Cannot establish connection to the Store. Try again later...");
                            this.ctx.logError("Store Connection error: " + Utils.formatException((Throwable)ex, (String)"\n"));
                            Thread.sleep(this.reconnectInterval * 1000);
                        }
                    } else {
                        this.ctx.logInfo("EmailStore is connected and Imap Folder is opened.");
                        error = false;
                    }
                    firstErrorIteration = false;
                }
                try {
                    result = this.fetchMessages(startUID, msgCount);
                    startUID = this.getNextMessageUID(result.lastFectedUID);
                    msgCount = this.imapEmailFolder.getMessageCount();
                    continue block4;
                }
                catch (Exception ex) {
                    this.ctx.logError("Failed to recovery message: " + Utils.formatException((Throwable)ex));
                    this.ctx.logError("Exception: " + ex.getClass().toString());
                    error = true;
                    firstErrorIteration = true;
                    continue;
                }
            }
        } while (result.lastFetchedNum < msgCount);
    }

    private void recoveryMessages() throws ServiceFrameworkException {
        long lastRecoveredUID = 0L;
        if (this.recoveryEnabled) {
            long t1 = System.currentTimeMillis();
            long lastProcessedUID = this.lastUID;
            ArrayList messages = new ArrayList();
            try {
                long startUID = 0L;
                boolean error = false;
                int retries = 3;
                switch (this.recoveryType.ordinal()) {
                    case 0: {
                        this.ctx.logInfo("Recovery Messages by Message Count.");
                        startUID = this.recoveryByMessage();
                        this.recoveryMessages(startUID);
                        return;
                    }
                    case 1: {
                        this.ctx.logInfo("Recovery Messages by Time.");
                        startUID = this.recoveryByTime();
                        if (startUID != 0L) break;
                        return;
                    }
                    case 3: {
                        this.ctx.logInfo("Recovery from Last Message.");
                        startUID = this.recoveryFromLastMessage();
                        this.recoveryMessages(startUID);
                        return;
                    }
                    case 2: {
                        this.ctx.logInfo("Complete Recovery mode.");
                        startUID = this.completeRecovery();
                        lastProcessedUID = 0L;
                        if (this.archiveAccessor == null) break;
                        this.ctx.logInfo("Truncate Collection [" + this.mailIndex.getArchiveCollection() + "]...");
                        this.archiveAccessor.executeQuery("truncate collection [" + this.mailIndex.getArchiveCollection() + "]");
                        this.ctx.logInfo("Reindex Text Index " + this.mailIndex.getTextIndexName() + "...");
                        this.archiveAccessor.executeQuery("reindex text index " + this.mailIndex.getTextIndexName());
                        break;
                    }
                    default: {
                        this.ctx.logError("Unknown Recovery Type: " + String.valueOf((Object)this.recoveryType) + ". Skip messages recovery.");
                    }
                }
                this.ctx.logInfo("Start recovery from UID: " + startUID);
                long uid = startUID;
                int processedMessages = 0;
                int recoveredMessages = 0;
                while (uid > 0L) {
                    for (int j = 0; j < retries; ++j) {
                        if (this.interruptRecoveryThread) {
                            return;
                        }
                        if (error) {
                            this.ctx.logInfo("Check Email Store connection...");
                            if (!this.emailStore.isConnected() || !this.imapEmailFolder.isOpen()) {
                                try {
                                    this.ctx.logError("Store is not connected. Try to reconnect....");
                                    Folder emailFolder = this.initStoreFolder(this.emailStore);
                                    this.ctx.logInfo("Connection to Store has been established.");
                                    this.initImapEmailFolder(emailFolder);
                                    error = false;
                                }
                                catch (Exception ex) {
                                    this.ctx.logError("Cannot establish connection to the Store. Try again later...");
                                    this.ctx.logError("Store Connection error: " + Utils.formatException((Throwable)ex, (String)"\n"));
                                    Thread.sleep(this.reconnectInterval * 1000);
                                }
                            } else {
                                error = false;
                            }
                        }
                        if (error) continue;
                        try {
                            Message msg = this.imapEmailFolder.getMessageByUID(uid);
                            if (lastProcessedUID < uid) {
                                this.handleMessage(msg, uid);
                                this.ctx.logInfo("Message with UID '" + uid + "' has been recovered.");
                                ++recoveredMessages;
                            } else {
                                this.ctx.logInfo("Message with UID '" + uid + "' was already processed. Skip.");
                            }
                            this.ctx.logDebug(++processedMessages + " messages have been processed. " + recoveredMessages + " messages have been recovered.");
                            lastRecoveredUID = uid;
                            uid = this.getNextMessageUID(uid);
                            this.storeLastUID(lastRecoveredUID);
                            break;
                        }
                        catch (Exception ex) {
                            this.ctx.logError("Failed to recovery message: " + Utils.formatException((Throwable)ex));
                            this.ctx.logError("Exception: " + ex.getClass().toString());
                            error = true;
                        }
                    }
                    if (!error) continue;
                    this.ctx.logError("Failed to recovery messages. Skip");
                    break;
                }
            }
            catch (Exception ex) {
                this.ctx.logError("Message Recovery error: " + Utils.formatException((Throwable)ex, (String)"\n"));
                Trace.logError((Object)((Object)this), (String)("Message Recovery error: " + Utils.formatExceptionWithUnrepeatedCauses((Throwable)ex)));
                throw new ServiceFrameworkException(6065, (Throwable)ex);
            }
            finally {
                try {
                    if (lastRecoveredUID > this.lastUID) {
                        this.storeLastUID(lastRecoveredUID);
                    }
                }
                catch (Exception ex) {
                    this.ctx.logError("Cannot store LastUID: " + Utils.formatException((Throwable)ex, (String)"\n"));
                    throw new ServiceFrameworkException(6065, (Throwable)ex);
                }
                long t2 = System.currentTimeMillis();
                this.ctx.logInfo("Recovery duration " + (t2 - t1) + " ms");
            }
        }
    }

    private FetchResult fetchMessages(long startUID, int msgCount) throws MessagingException, DataspaceComponentException {
        int step = (int)(this.recoveryStep - 1L);
        long t1 = System.currentTimeMillis();
        this.ctx.logInfo("Start fetch UID: " + startUID);
        Message startMessage = this.imapEmailFolder.getMessageByUID(startUID);
        while (startMessage == null) {
            if ((startUID = this.getNextMessageUID(startUID)) == -1L) {
                this.ctx.logInfo("There is not new messages after " + startUID);
                return null;
            }
            startMessage = this.imapEmailFolder.getMessageByUID(startUID);
        }
        int startMsgNum = startMessage.getMessageNumber();
        int endMsgNum = startMsgNum + step > msgCount ? msgCount : startMsgNum + step;
        this.ctx.logInfo("Start Message Number: " + startMsgNum + ", End Message Number: " + endMsgNum);
        long endUID = this.imapEmailFolder.getUID(this.imapEmailFolder.getMessage(endMsgNum));
        this.ctx.logInfo("Start UID: " + startUID + ", End UID: " + endUID);
        Message[] msgtorcv = this.imapEmailFolder.getMessages(startMsgNum, endMsgNum);
        this.fetchMessages(this.imapEmailFolder, msgtorcv, startUID);
        long lastRecoveredUID = this.imapEmailFolder.getUID(msgtorcv[msgtorcv.length - 1]);
        this.storeLastUID(lastRecoveredUID);
        startUID = this.getNextMessageUID(lastRecoveredUID);
        long t2 = System.currentTimeMillis();
        this.ctx.logInfo("Recovery iteration duration (id_" + startUID + "): " + (t2 - t1) + " ms");
        return new FetchResult(this, lastRecoveredUID, endMsgNum);
    }

    private void fetchMessages(IMAPFolder inbox, Message[] messages, long uid) throws MessagingException, DataspaceComponentException {
        FetchProfile fp = new FetchProfile();
        fp.add(FetchProfile.Item.SIZE);
        int msgCount = messages.length;
        this.ctx.logInfo("Fetch messages count: " + msgCount);
        long t1 = System.currentTimeMillis();
        inbox.fetch(messages, fp);
        long t2 = System.currentTimeMillis();
        this.ctx.logInfo("Fetch messages duration (" + messages.length + ") (id_" + uid + "): " + (t2 - t1) + " ms");
        int index = 0;
        int maxDoc = 5000;
        long maxSize = this.recoveryFetchSize * 0x100000L;
        this.ctx.logInfo("Get messages numbers...");
        HashMap<Integer, Message> msgByNum = new HashMap<Integer, Message>();
        for (Message message : messages) {
            msgByNum.put(message.getMessageNumber(), message);
        }
        int totalSize = 0;
        this.ctx.logInfo("Download messages count: " + msgCount);
        while (index < msgCount) {
            int startIndex = index;
            int start = messages[index].getMessageNumber();
            int docs = 0;
            int sizeToFetch = 0;
            boolean noskip = true;
            boolean notend = true;
            t1 = System.currentTimeMillis();
            while (docs < 5000 && (long)sizeToFetch < maxSize && noskip && notend) {
                ++docs;
                sizeToFetch += messages[index].getSize();
                if (!(notend = ++index < msgCount)) continue;
                noskip = messages[index - 1].getMessageNumber() + 1 == messages[index].getMessageNumber();
            }
            t2 = System.currentTimeMillis();
            this.ctx.logInfo("Size calculation duration (id_" + uid + "): " + (t2 - t1) + " ms");
            int end = messages[index - 1].getMessageNumber();
            long startUID = inbox.getUID(messages[startIndex]);
            long endUID = inbox.getUID(messages[index - 1]);
            this.ctx.logInfo("Start Index: " + startIndex + ", End Index: " + index);
            this.ctx.logInfo("Start UID: " + startUID + ", End UID: " + endUID);
            this.ctx.logInfo("Start Message: " + start + ", End Message: " + end);
            this.ctx.logInfo("Total Size: " + sizeToFetch / 1000000 + " Mb");
            totalSize += sizeToFetch;
            t1 = System.currentTimeMillis();
            FullFetchByUIDCommand cmd = new FullFetchByUIDCommand(this.ctx, startUID, endUID);
            inbox.doCommand((IMAPFolder.ProtocolCommand)cmd);
            t2 = System.currentTimeMillis();
            this.ctx.logInfo("Command duration (" + (index - startIndex) + ") (id_" + uid + "): " + (t2 - t1) + " ms");
            this.ctx.logInfo("Messages have been fetched. Process them...");
            t1 = System.currentTimeMillis();
            HashMap<Integer, ProcessedMessage> processedMsg = cmd.getMessagesMap();
            ArrayList<Integer> msgNums = new ArrayList<Integer>(processedMsg.keySet());
            Collections.sort(msgNums);
            long lastHandledUID = -1L;
            for (Integer msgNum : msgNums) {
                try {
                    ProcessedMessage prcMsg = processedMsg.get(msgNum);
                    String from = this.getMailFromAddresses(prcMsg.truncatedMessage.getFrom()).toLowerCase();
                    if (this.blackListDomain != null && this.blackListDomain.matchesValue((Object)from)) {
                        this.ctx.logInfo("Sender '" + from + "' is in black list. Skip.");
                        continue;
                    }
                    prcMsg.mailDescriptor.receivedDate = new Date(prcMsg.mailDescriptor.sentDate.getTime());
                    Message msg = (Message)msgByNum.get(msgNum);
                    this.handleMessage(msg, prcMsg.messageUID, prcMsg);
                    lastHandledUID = prcMsg.messageUID;
                }
                catch (Exception ex) {
                    this.ctx.logError("Unable to handle processed messages: " + Utils.formatException((Throwable)ex, (String)"\n"));
                }
            }
            this.ctx.logInfo("Try to store last UID: " + lastHandledUID);
            if (lastHandledUID > 0L) {
                this.storeLastUID(lastHandledUID);
            }
            t2 = System.currentTimeMillis();
            this.ctx.logInfo("Messages handling duration (" + processedMsg.size() + ") (id_" + uid + "): " + (t2 - t1));
            this.ctx.logInfo("Fetched messages have been processed.");
        }
        this.ctx.logInfo("Total Size was fetched: " + totalSize / 1000000 + " Mb");
    }

    private long recoveryByMessage() throws MessagingException {
        long mcount = this.imapEmailFolder.getMessageCount();
        long msgtorcv = this.recoveryDepth > mcount ? mcount : this.recoveryDepth;
        this.ctx.logInfo("Email Folder Message count: " + mcount + ". " + msgtorcv + " messages will be recovered.");
        long uid = this.imapEmailFolder.getUID(this.imapEmailFolder.getMessage((int)(mcount - msgtorcv + 1L)));
        return uid;
    }

    private long recoveryByTime() throws MessagingException {
        Calendar clndr = Calendar.getInstance();
        clndr.setTimeInMillis(System.currentTimeMillis());
        clndr.set(12, (int)((long)clndr.get(12) - this.recoveryDepth));
        int mcount = this.imapEmailFolder.getMessageCount();
        this.ctx.logInfo("Email Folder Message count: " + mcount + ". Messages for last " + this.recoveryDepth + " minutes will be recovery.");
        Calendar lmrdc = Calendar.getInstance();
        Message lastMessage = null;
        for (int i = 0; i < mcount; ++i) {
            Message msg = this.imapEmailFolder.getMessage(mcount - i);
            Date lmrd = msg.getReceivedDate();
            lmrdc.setTime(lmrd);
            if (lmrdc.before(clndr)) break;
            lastMessage = msg;
        }
        if (lastMessage != null) {
            int rcount = mcount - lastMessage.getMessageNumber();
            this.ctx.logInfo(rcount + " messages will be recovered.");
            return this.imapEmailFolder.getUID(lastMessage);
        }
        this.ctx.logInfo("There is nothing to recovery.");
        return 0L;
    }

    private long recoveryFromLastMessage() throws MessagingException {
        if (this.lastUID == 0L) {
            this.ctx.logInfo("There is not LastUID, start full recovery...");
            return this.completeRecovery();
        }
        int mcount = this.imapEmailFolder.getMessageCount();
        Message lastMsg = this.imapEmailFolder.getMessageByUID(this.lastUID);
        int rcount = -1;
        if (lastMsg != null) {
            rcount = mcount - lastMsg.getMessageNumber();
        }
        if (rcount == -1) {
            this.ctx.logError("Cannot calculate number of messages that will recovered.");
        } else {
            this.ctx.logInfo("Email Folder Message count: " + mcount + ". " + rcount + " messages will be recovered.");
        }
        return this.lastUID;
    }

    private long completeRecovery() throws MessagingException {
        this.ctx.logInfo(this.imapEmailFolder.getMessageCount() + " messages will be recovered.");
        return this.imapEmailFolder.getUID(this.imapEmailFolder.getMessage(1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void archiveMessage(ProcessedMessage pmsg) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            long attArchT2;
            long msgArchT2;
            Thread.currentThread().setContextClassLoader(RuntimeContext.getInstance().getSystemClassLoaderChain());
            MailcapCommandMap mc = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
            mc.addMailcap("text/html;; x-java-content-handler=com.sun.mail.handlers.text_html");
            mc.addMailcap("text/xml;; x-java-content-handler=com.sun.mail.handlers.text_xml");
            mc.addMailcap("text/plain;; x-java-content-handler=com.sun.mail.handlers.text_plain");
            mc.addMailcap("multipart/*;; x-java-content-handler=com.sun.mail.handlers.multipart_mixed");
            mc.addMailcap("message/rfc822;; x-java-content- handler=com.sun.mail.handlers.message_rfc822");
            if (!this.archiveEnabled) {
                return;
            }
            long t1 = System.currentTimeMillis();
            String messageId = null;
            long msgArchT1 = System.currentTimeMillis();
            try {
                messageId = this.insertIntoMessageArchiveCollection(pmsg);
            }
            catch (Exception ex) {
                this.ctx.logError("Failed to archive Message: " + Utils.formatException((Throwable)ex, (String)"\n"));
            }
            finally {
                msgArchT2 = System.currentTimeMillis();
            }
            long attArchT1 = System.currentTimeMillis();
            try {
                if (messageId != null) {
                    this.insertIntoAttachmentsArchiveCollection(pmsg, messageId);
                }
            }
            catch (Exception ex) {
                this.ctx.logError("Failed to archive Attachments: " + Utils.formatException((Throwable)ex, (String)"\n"));
            }
            finally {
                attArchT2 = System.currentTimeMillis();
            }
            long t2 = System.currentTimeMillis();
            this.ctx.logDebug("Archiving Completed. Durations: Message " + (msgArchT2 - msgArchT1) + " ms; Attachments " + (attArchT2 - attArchT1) + " ms");
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    private String insertIntoMessageArchiveCollection(ProcessedMessage pmsg) throws IOException, MessagingException, DataspaceComponentException {
        if (this.mailIndex == null) {
            return null;
        }
        this.ctx.logInfo("Archive Message to [" + this.mailIndex.getArchiveCollection() + "] collection.");
        String subj = pmsg.truncatedMessage.getSubject();
        String messageId = this.getMailboxMessageId(Long.toString(pmsg.messageUID));
        Object fileName = messageId + "_" + subj + ".eml";
        fileName = ((String)fileName).replaceAll(":", "");
        fileName = ((String)fileName).replaceAll(" ", "_");
        fileName = ((String)fileName).replaceAll("\\|", "");
        fileName = ((String)fileName).replaceAll("'", "");
        fileName = ((String)fileName).replaceAll("\\\\", "");
        fileName = this.normalizeFileName((String)fileName);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        pmsg.truncatedMessage.writeTo((OutputStream)baos);
        baos.flush();
        baos.close();
        byte[] bytes = baos.toByteArray();
        this.ctx.logInfo("Message UID: " + pmsg.messageUID + "; Subject: '" + subj + "'; EML File Name: '" + (String)fileName + "'");
        String sender = this.getMailFromAddresses(pmsg.truncatedMessage.getFrom());
        Address[] recipients = pmsg.truncatedMessage.getAllRecipients();
        Object recipientsStr = "array[";
        for (Address recipient : recipients) {
            recipientsStr = (String)recipientsStr + "'" + this.getMailFromAddress(recipient) + "',";
        }
        recipientsStr = ((String)recipientsStr).substring(0, ((String)recipientsStr).length() - 1) + "]";
        String cmdFileName = ((String)fileName).replaceAll("'", "''");
        String cmd = "insert into [" + this.mailIndex.getArchiveCollection() + "] values ('" + messageId + "', '" + sender + "', " + (String)recipientsStr + ",'" + subj + "', toFlob('" + cmdFileName + "', ?))";
        this.ctx.logDebug(cmd);
        this.archiveAccessor.executeQuery(cmd, new Object[]{bytes});
        this.ctx.logInfo("Message has been archived to [" + this.mailIndex.getArchiveCollection() + "]");
        return messageId;
    }

    private void insertIntoAttachmentsArchiveCollection(ProcessedMessage pmsg, String messageId) throws MessagingException, SecurityViolationException, DataspaceComponentException {
        if (this.mailIndex == null) {
            return;
        }
        this.ctx.logInfo("Archive Attachments to [" + this.mailIndex.getAttachmentsCollection() + "] collection.");
        int attchCount = pmsg.mailDescriptor.attachments.size();
        if (attchCount == 0) {
            this.ctx.logInfo("There is no attachments to archive");
        } else {
            this.ctx.logInfo("There are " + attchCount + " attachments to archive");
        }
        String subj = pmsg.truncatedMessage.getSubject();
        for (int i = 0; i < attchCount; ++i) {
            try {
                MailEvent.MailAttachment mailAttch = pmsg.mailDescriptor.attachments.get(i);
                String attachName = mailAttch.getName();
                this.ctx.logInfo("Archive Attachment '" + mailAttch.getName() + "'");
                String[] arr = attachName.split("[.]");
                String ext = "";
                if (arr.length > 1) {
                    ext = arr[arr.length - 1];
                }
                attachName = attachName.substring(0, attachName.length() - ext.length());
                Object fileName = messageId + "_" + attachName + (String)(!ext.isEmpty() ? "." + ext : "");
                fileName = ((String)fileName).replaceAll(":", "");
                fileName = ((String)fileName).replaceAll(" ", "_");
                fileName = ((String)fileName).replaceAll("\\|", "");
                fileName = ((String)fileName).replaceAll("'", "");
                fileName = ((String)fileName).replaceAll("\\\\", "");
                fileName = this.normalizeFileName((String)fileName);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                baos.write(mailAttch.getData());
                baos.flush();
                baos.close();
                byte[] bytes = baos.toByteArray();
                String cmdFileName = ((String)fileName).replaceAll("'", "''");
                String cmd = "insert into [" + this.mailIndex.getAttachmentsCollection() + "] values ('" + cmdFileName + "', '" + messageId + "', '" + subj + "', toFlob('" + cmdFileName + "', ?))";
                this.ctx.logDebug(cmd);
                this.archiveAccessor.executeQuery(cmd, new Object[]{bytes});
                this.ctx.logInfo("Attachment '" + mailAttch.getName() + "' has been archived to [" + this.mailIndex.getAttachmentsCollection() + "]");
                continue;
            }
            catch (Exception ex) {
                this.ctx.logError("Failed to archive Attachment: " + Utils.formatException((Throwable)ex, (String)"\n"));
            }
        }
    }

    private void initImapEmailFolder(Folder emailFolder) throws Exception {
        if (!(emailFolder instanceof IMAPFolder)) {
            this.ctx.logError("Configured Email Folder is not IMAP Folder: " + String.valueOf(emailFolder.getClass()));
            if (this.emailStore != null && this.emailStore.isConnected()) {
                this.emailStore.close();
            }
            throw new Exception("Configured Email Folder is not IMAP Folder.");
        }
        this.imapEmailFolder = (IMAPFolder)emailFolder;
    }

    private void openAccessor() throws FabricComponentAccessorException {
        this.ctx.logInfo("Open Accessor to TSPACE.SDS...");
        if (!this.ctx.getState().isRunning()) {
            this.ctx.logError("Service is not running. Skip Accessor opening.");
            return;
        }
        this.sdsAccessor = this.ctx.createDataspaceAccessor(DataspaceType.TSPACE, "SDS");
        this.ctx.logInfo("Accessor has been openeed.");
    }

    private void checkServiceCollection() throws Exception {
        this.openAccessor();
        if (this.sdsAccessor == null || !this.sdsAccessor.isAvailable()) {
            throw new IllegalStateException("Unable to open accessor to dataspace the service collection.");
        }
        this.ctx.logInfo("Check " + this.sdsCollectionName + " service collection...");
        this.sdsAccessor.executeQuery("create persistent table if not exists [" + this.sdsCollectionName + "] (Property string, Value string)");
        this.ctx.logInfo("Collection has been created.");
    }

    private String getLastUidPropertyName() {
        return "LAST_UID_" + this.ctx.getName();
    }

    private void storeLastUID(long storeLastUID) throws DataspaceComponentException {
        this.ctx.logDebug("Save LastUID '" + storeLastUID + "' to " + this.sdsCollectionName + " service collection...");
        if (storeLastUID == this.lastUID || storeLastUID == 0L) {
            this.ctx.logDebug("LastUID saving is not necessary. Skip.");
            return;
        }
        int count = this.sdsAccessor.executeQuery("select * from " + this.sdsCollectionName + " where Property = '" + this.getLastUidPropertyName() + "'").getRowCount();
        if (count != 0) {
            this.sdsAccessor.executeQuery("update MAIL_READER set Value = '" + storeLastUID + "' where Property = '" + this.getLastUidPropertyName() + "'");
        } else {
            this.sdsAccessor.executeQuery("insert into MAIL_READER values ('" + this.getLastUidPropertyName() + "', '" + storeLastUID + "')");
        }
        this.lastUID = storeLastUID;
    }

    private long getLastUID() throws DataspaceComponentException, SQLException {
        if (this.lastUID == 0L) {
            this.ctx.logInfo("Select LastUID from " + this.sdsCollectionName + " collection...");
            RowSet rs = this.sdsAccessor.executeQuery("select Value from " + this.sdsCollectionName + " where Property = '" + this.getLastUidPropertyName() + "'");
            rs.beforeFirst();
            if (rs.next()) {
                String value = rs.getString(1);
                this.lastUID = Long.parseLong(value);
                this.ctx.logInfo("LastUID is " + this.lastUID + ".");
            }
        }
        return this.lastUID;
    }

    private String getMailboxMessageId(String messageUID) {
        return this.username + "_" + messageUID;
    }

    private String normalizeFileName(String fileName) {
        int limit = 250;
        if (fileName.length() > limit) {
            String[] arr = fileName.split("[.]");
            String ext = "";
            if (arr.length > 1) {
                ext = arr[arr.length - 1];
            }
            String fileNameWithoutExt = fileName.substring(0, fileName.length() - ext.length());
            int trunc = fileName.length() - limit;
            String newName = fileNameWithoutExt.substring(0, fileNameWithoutExt.length() - trunc) + "." + ext;
            return newName;
        }
        return fileName;
    }

    private String getMailFromAddress(Address address) {
        if (address instanceof InternetAddress) {
            InternetAddress ia = (InternetAddress)address;
            return ia.getAddress();
        }
        return address.toString();
    }

    private String getMailFromAddresses(Address[] from) {
        if (from.length != 0) {
            if (from.length > 1) {
                this.ctx.logError("Message contains more that one From: " + Arrays.toString(from));
            }
            return this.getMailFromAddress(from[0]);
        }
        this.ctx.logError("Message Sender field is empty");
        return "n/a";
    }

    private String getMailFromNames(Address[] from) {
        if (from.length != 0) {
            if (from.length > 1) {
                this.ctx.logError("Message contains more that one From: " + Arrays.toString(from));
            }
            return this.getMailFromName(from[0]);
        }
        this.ctx.logError("Message Sender field is empty");
        return "n/a";
    }

    private String getMailFromName(Address address) {
        if (address instanceof InternetAddress) {
            InternetAddress ia = (InternetAddress)address;
            return ia.getPersonal();
        }
        return "";
    }

    private List<String> getMailToAddresses(Address[] to) {
        ArrayList<String> result = new ArrayList<String>();
        if (to.length == 0) {
            this.ctx.logError("Message Sender field is empty");
        } else {
            for (Address toAddress : to) {
                result.add(this.getMailFromAddress(toAddress));
            }
        }
        return result;
    }

    private void raiseMailEvent(ProcessedMessage pmsg) {
        try {
            if (this.newMailEvenId.isEmpty()) {
                return;
            }
            MailDescriptor mailDescriptor = pmsg.mailDescriptor;
            MailEvent event = (MailEvent)EventDatagramFactory.getInstance().createEvent(this.newMailEvenId);
            event.setCorrelationId(this.getMailboxMessageId(Long.toString(pmsg.messageUID)));
            event.setSubject(mailDescriptor.subject);
            event.setContentType(mailDescriptor.contentType);
            event.setSentDate(mailDescriptor.sentDate);
            event.setReceivedDate(mailDescriptor.receivedDate);
            event.setFrom(mailDescriptor.from);
            event.setFromAddress(this.getMailFromAddresses(pmsg.truncatedMessage.getFrom()));
            event.setFromName(this.getMailFromNames(pmsg.truncatedMessage.getFrom()));
            event.setTo(mailDescriptor.to);
            event.setToAddresses(this.getMailToAddresses(pmsg.truncatedMessage.getRecipients(Message.RecipientType.TO)));
            event.setCc(mailDescriptor.cc);
            event.setBcc(mailDescriptor.bcc);
            if (this.lastMessageOnly) {
                try {
                    String lastMessage = EmailSplitter.getTopMessage(mailDescriptor.body);
                    this.ctx.logInfo("From Email:" + String.valueOf(event.getFrom()));
                    this.ctx.logInfo("From Name:" + event.getFromName());
                    if (this.excludeSignature) {
                        EmailSignature.Result signResult = EmailSignature.process(lastMessage, event.getFromName());
                        lastMessage = signResult.getWithoutSignature();
                        event.setSignature(signResult.getSignature());
                    }
                    event.setLastMessage(lastMessage);
                }
                catch (Exception ex) {
                    event.setLastMessage(mailDescriptor.body);
                    this.ctx.logError("Failed to set message field. " + Utils.formatException((Throwable)ex, (String)"\n"));
                }
            } else {
                event.setBody(mailDescriptor.body);
            }
            for (int i = 0; i < mailDescriptor.attachments.size(); ++i) {
                event.addAttachment(mailDescriptor.attachments.get(i));
            }
            this.ctx.raiseEvent((ImmutableEventDatagram)event, 0L);
            this.ctx.logDebug("Mail Event has been raised.");
        }
        catch (Exception ex) {
            this.ctx.logError("Failed to raise Mail Event. " + Utils.formatException((Throwable)ex, (String)"\n"));
        }
    }

    private ClientException createClientException(String error, Throwable cause) {
        ClientException exception = new ClientException(1000, error, cause, Severity.SEVERE);
        return exception;
    }

    private void raiseException(ExceptionEventDatagram error) {
        try {
            this.ctx.raiseException(error);
        }
        catch (Exception ex) {
            this.ctx.logError("Event dispatch exception: " + ex.getMessage() + " for Error: " + error.getErrorMessage());
        }
    }

    protected long getPassiveIterationInterval() {
        return this.pollingInterval * 1000;
    }

    public int getMinorBuild() {
        return Version.getBuild();
    }

    public int getMajorVersion() {
        return Version.getMajorVersion();
    }

    public int getMinorVersion() {
        return Version.getMinorVersion();
    }

    public String getVersion() {
        return Version.getVersionString();
    }

    static enum MailBoxRecoveryType {
        MESSAGE,
        TIME,
        COMPLETE,
        LAST_MESSAGE;

    }

    private class FetchResult {
        long lastFectedUID;
        int lastFetchedNum;

        public FetchResult(MailReader mailReader, long lastFectedUID, int lastFetchedNum) {
            this.lastFectedUID = lastFectedUID;
            this.lastFetchedNum = lastFetchedNum;
        }
    }
}

