/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.mail;

import com.streamscape.sdo.advisory.ThreadDeadlockAdvisory;
import com.streamscape.service.mail.AbstractStreamscapeMail;
import java.util.ArrayList;

public class ThreadDeadlockMail
extends AbstractStreamscapeMail<ThreadDeadlockAdvisory> {
    @Override
    protected void beforeCreateMailEvent() {
        if (this.getSubjectLevel() == null) {
            this.setSubjectLevel("Advisory");
        }
        if (this.getSubject() == null) {
            this.setSubject("Thread Deadlock Advisory");
        }
    }

    @Override
    protected String getBodyHtml() {
        StringBuffer body = new StringBuffer();
        ThreadDeadlockAdvisory advisory = (ThreadDeadlockAdvisory)this.getSourceEvent();
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        rows.add(new Object[]{"Timestamp", advisory.getTimestamp()});
        rows.add(new String[]{"Component Full Name", this.getSourceComponentName()});
        StringBuilder builder = new StringBuilder();
        for (StackTraceElement elem : advisory.getFirstThreadStackTrace()) {
            builder.append(elem.toString()).append('\n');
        }
        rows.add(new Object[]{"First Thread (" + advisory.getFirstThreadId() + ")", builder.toString()});
        builder = new StringBuilder();
        for (StackTraceElement elem : advisory.getSecondThreadStackTrace()) {
            builder.append(elem.toString()).append('\n');
        }
        rows.add(new Object[]{"Second Thread (" + advisory.getSecondThreadId() + ")", builder.toString()});
        body.append(this.createTableHtml(rows));
        return body.toString();
    }
}

