/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.mail;

import com.streamscape.sdo.advisory.ConnectionStateChangeAdvisory;
import com.streamscape.sdo.enums.ConnectionState;
import com.streamscape.service.mail.AbstractStreamscapeMail;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class ConnectionStateChangeMail
extends AbstractStreamscapeMail<ConnectionStateChangeAdvisory> {
    @Override
    protected void beforeCreateMailEvent() {
        if (this.getSubjectLevel() == null) {
            this.setSubjectLevel("Advisory");
        }
        if (this.getSubject() == null) {
            this.setSubject("Connection State Change Notification");
        }
    }

    @Override
    protected String getBodyHtml() {
        StringBuffer body = new StringBuffer();
        ConnectionStateChangeAdvisory notification = (ConnectionStateChangeAdvisory)this.getSourceEvent();
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        if (notification.getConnectionName() != null) {
            StringTokenizer tokenizer = new StringTokenizer(notification.getConnectionName(), ".");
            if (tokenizer.countTokens() == 3) {
                rows.add(new String[]{"Connection Name", tokenizer.nextToken()});
                rows.add(new String[]{"Connection Factory Type", tokenizer.nextToken()});
                rows.add(new String[]{"Connection Factory Name", tokenizer.nextToken()});
            } else {
                rows.add(new String[]{"Connection Name", notification.getConnectionName()});
            }
        } else {
            rows.add(new String[]{"Connection Name", "N/A"});
        }
        rows.add(new String[]{"Connection URL", notification.getConnectionUrl()});
        rows.add(new String[]{"Timestamp", notification.getTimestamp().toString()});
        rows.add(new String[]{"Component Name", notification.getComponentName()});
        rows.add(new String[]{"Component Full Name", this.getSourceComponentName()});
        String stateColor = "green";
        stateColor = notification.getState() == ConnectionState.CONNECTED ? "green" : (notification.getState() == ConnectionState.CLOSED ? "red" : "#FFC900");
        rows.add(new String[]{"State", "<p style='color:" + stateColor + "'>" + notification.getState().toString() + "</p>"});
        rows.add(new String[]{"Message", notification.getMessage()});
        body.append(this.createTableHtml(rows));
        return body.toString();
    }
}

