/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.mail;

import com.streamscape.Trace;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.RuntimeState;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.event.MailEvent;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.exchange.FabricAddress;
import com.streamscape.sef.moderator.ComponentReference;
import com.streamscape.service.converter.ConverterPluginException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;

public abstract class AbstractStreamscapeMail<T extends ImmutableEventDatagram> {
    private String environmentType;
    private String subjectLevel;
    private String subject;
    private String recipients;
    private String imagePath;
    private String imageCid = "imagecid";
    private String tableHeader;
    private T sourceEvent;
    private String retryDiscardUrl;

    protected AbstractStreamscapeMail() {
    }

    public String getEnvironmentType() {
        return this.environmentType;
    }

    public void setEnvironmentType(String environmentType) {
        this.environmentType = environmentType;
    }

    public String getSubjectLevel() {
        return this.subjectLevel;
    }

    public void setSubjectLevel(String subjectLevel) {
        this.subjectLevel = subjectLevel;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
        this.setTableHeader(subject);
    }

    public String getRecipients() {
        return this.recipients;
    }

    public void setRecipients(String recipients) {
        this.recipients = recipients;
    }

    public String getImagePath() {
        return this.imagePath;
    }

    public void setImagePath(String imagePath) {
        this.imagePath = imagePath;
    }

    public String getImageCid() {
        return this.imageCid;
    }

    public void setImageCid(String imageCid) {
        this.imageCid = imageCid;
    }

    public String getTableHeader() {
        return this.tableHeader;
    }

    public void setTableHeader(String tableHeader) {
        this.tableHeader = tableHeader;
    }

    public T getSourceEvent() {
        return this.sourceEvent;
    }

    public void setSourceEvent(T sourceEvent) {
        this.sourceEvent = sourceEvent;
    }

    public String getRetryDiscardUrl() {
        return this.retryDiscardUrl;
    }

    public void setRetryDiscardUrl(String retryDiscardUrl) {
        this.retryDiscardUrl = retryDiscardUrl;
    }

    protected void beforeCreateMailEvent() throws Exception {
    }

    public MailEvent fillMailEvent(MailEvent mailEvent) throws Exception {
        this.beforeCreateMailEvent();
        mailEvent.setSubject(this.getEnvironmentType() + ": [" + this.getSubjectLevel() + "] " + this.getSubject());
        if (this.recipients == null || this.recipients.length() == 0) {
            throw new Exception("Recipients not set.");
        }
        mailEvent.setTo(Arrays.asList(this.recipients.split(",")));
        mailEvent.setContentType("text/html");
        if (this.getImagePath() != null) {
            try {
                mailEvent.attachFile(this.getImagePath(), (String)null, this.getImageCid());
            }
            catch (Exception exception) {
                Trace.logError((Object)this, (String)("Failed to attach image. Cause: " + exception.getMessage()));
            }
        }
        mailEvent.setBody(this.createMailBody());
        return mailEvent;
    }

    private final String createMailBody() throws Exception {
        StringBuilder body = new StringBuilder();
        body.append("<html><body>\n");
        body.append("<div style='width: 700px'>\n");
        body.append("<table style='background-color:white;color:black;font-size:10pt;font-family: arial, sans-serif;border: 1px solid gray;border-collapse: collapse;'>\n");
        body.append("<tbody><tr><td rowspan='2'><img src='cid:" + this.getImageCid() + "' height='100' width='100'></img></td>\n");
        body.append("<td width='100%' style='padding-left:15px;border: 1px solid gray;border-collapse: collapse;' height='70'>\n");
        body.append(this.getTableHeaderHtml());
        body.append("</td></tr><tr><td style='padding-left:15px;border: 1px solid gray;border-collapse: collapse; font-size:6pt;'>\n");
        body.append("This error or status message is generated by the StreamScape Operations Console and is intended for viewing by designated recipients and support personnel. If you are not an authorized recipient, please disregard this message. For further information contact <a href='www.streamscape.com'>www.streamscape.com</a>\n");
        body.append("</td></tr>\n");
        body.append("</tbody></table>\n");
        body.append("<br/>\n");
        body.append(this.getBodyHtml());
        body.append("</div>\n");
        body.append("</body></html>\n");
        return body.toString();
    }

    protected String getTableHeaderHtml() throws Exception {
        return "<b><p>" + this.getTableHeader() + "</p></b>\n";
    }

    protected abstract String getBodyHtml() throws Exception;

    protected String getSourceComponentName() {
        byte[] eventSource;
        String sourceName = "Unknown";
        if (RuntimeState.isActive() && (eventSource = this.sourceEvent.getEventSource()) != null) {
            FabricAddress source = new FabricAddress(this.sourceEvent.getEventSource());
            ComponentReference component = RuntimeContext.getInstance().getModerator().lookupComponent(source);
            if (component == null) {
                component = RuntimeContext.getInstance().getModerator().lookupFabricNode(source);
            }
            if (component != null) {
                sourceName = component.getName();
            }
        }
        return sourceName;
    }

    protected String createTableHtml(List<Object[]> rows) {
        StringBuilder table = new StringBuilder();
        table.append("<table border='0' style='background-color:#C0C0C0;color:black;font-size: 10pt;font-family: arial, sans-serif;' width='100%'><tbody>\n");
        for (int i = 0; i < rows.size(); ++i) {
            table.append("<tr>\n");
            table.append("<td style='background-color:#808080;color:white' width='25%'><p><nobr><b>" + String.valueOf(rows.get(i)[0]) + "</b></nobr></p></td>\n");
            table.append("<td style='background-color:#C0C0C0;color:black'><p>" + String.valueOf(rows.get(i)[1]) + "</p></td>\n");
            table.append("</tr>\n");
        }
        table.append("</tbody></table>");
        return table.toString();
    }

    protected String createRowSetHtml(RowSet rowSet) throws Exception {
        StringBuffer body = new StringBuffer();
        body.append("<table border='0' width='100%' style='background-color:#F0F0F0;color:black;font-size: 10pt;font-family: arial, sans-serif;'><tbody>");
        RowMetaData descriptor = rowSet.getRowMetaData();
        try {
            body.append("<tr style='background-color:#808080;color:white'>");
            for (String column : descriptor.getColumnNames()) {
                body.append("<th>" + column + "</th>");
            }
            body.append("</tr>");
        }
        catch (Exception error) {
            throw new ConverterPluginException(error.getMessage());
        }
        try {
            rowSet.beforeFirst();
            while (rowSet.next()) {
                body.append("<tr>");
                for (int j = 1; j <= descriptor.getColumnCount(); ++j) {
                    body.append("<td align='center'>" + String.valueOf(rowSet.getObject(j)) + "</td>");
                }
                body.append("</tr>");
            }
        }
        catch (SQLException error) {
            throw new ConverterPluginException("Failed to extract data from RowSet. Cause: " + error.getMessage());
        }
        body.append("</tbody></table>");
        return body.toString();
    }

    protected String createRetryDiscardHtml(String processGroupId, String processId, boolean isUndelivered, boolean isExpired) {
        StringBuilder body = new StringBuilder();
        String urlPrefix = this.retryDiscardUrl + "?action=";
        String urlPostfix = "&processType=" + processGroupId + "&processId=" + processId;
        body.append("<div style='background-color:white;color:black;font-size: 10pt;font-family: arial, sans-serif;'>");
        body.append("<p><a href='" + urlPrefix + "view" + urlPostfix + "'>View Process Request</a></p>");
        body.append("<p>Displays the process request that caused this error.</p>");
        body.append("<p><a href='" + urlPrefix + "retry" + urlPostfix + "'>Retry Process</a></p>");
        body.append("<p>The retry option allows you to resubmit the  process and retry the operation.<br/>");
        if (isUndelivered) {
            body.append("This option will automatically re-start the suspended process queue.</p>");
        } else if (isExpired) {
            body.append("This option will fail if the process queue is suspended.</p>");
        } else {
            body.append("</p>");
        }
        body.append("<p><a href='" + urlPrefix + "discard" + urlPostfix + "'>Discard Process</a></p>");
        body.append("<p>The discard option allows you discard the process from the queue.  The process<br/>will be marked as discarded and will be tried again.  Further retry attempts are <br/>not possible. ");
        if (isUndelivered) {
            body.append("This option will automatically re-start the suspended process queue.</p>");
        } else if (isExpired) {
            body.append("This option will fail if the process queue is suspended.</p>");
        } else {
            body.append("</p>");
        }
        body.append("</div>");
        return body.toString();
    }
}

